/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.ExpressionOwner;
import biouml.plugins.simulation.Preprocessor;
import biouml.standard.type.Base;
import biouml.standard.type.Stub;
import java.util.List;
import java.util.logging.Level;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.Utils;

public class DelayPreprocessor
extends Preprocessor {
    @Override
    public Diagram preprocess(Diagram diagram) {
        try {
            EModel eModel = (EModel)diagram.getRole(EModel.class);
            LinearFormatter formatter = new LinearFormatter();
            List<ExpressionOwner> expressionOwners = DelayPreprocessor.getExpressionOwners(diagram);
            for (ExpressionOwner owner : expressionOwners) {
                String[] oldExpressions = owner.getExpressions();
                String[] newExpressions = new String[oldExpressions.length];
                boolean changedAny = false;
                for (int i = 0; i < oldExpressions.length; ++i) {
                    AstStart start = eModel.readMath(oldExpressions[i], owner.getRole());
                    if (start == null) continue;
                    boolean changed = this.process((Node)start, diagram);
                    changedAny |= changed;
                    newExpressions[i] = changed ? formatter.format(start)[1] : oldExpressions[i];
                }
                if (!changedAny) continue;
                owner.setExpressions(newExpressions);
            }
            return diagram;
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "Error during static model preprocessing " + ex);
            return null;
        }
    }

    @Override
    public boolean accept(Diagram diagram) {
        Role role = diagram.getRole();
        if (!(role instanceof EModel)) {
            return false;
        }
        return EModel.isOfType((int)((EModel)role).getModelType(), (int)4);
    }

    private boolean process(Node node, Diagram diagram) throws Exception {
        boolean changed = false;
        if (node instanceof AstFunNode && "delay".equals(((AstFunNode)node).getFunction().getName())) {
            Node parent = node.jjtGetParent();
            Node delayedNode = node.jjtGetChild(0);
            if (delayedNode instanceof AstVarNode) {
                return false;
            }
            if (delayedNode instanceof AstConstant) {
                delayedNode.jjtSetParent(parent);
                parent.jjtReplaceChild(node, delayedNode);
                changed = true;
            } else {
                this.process(delayedNode, diagram);
                delayedNode = node.jjtGetChild(0);
                LinearFormatter formatter = new LinearFormatter();
                AstStart start = Utils.createStart((Node)delayedNode);
                this.process((Node)start, diagram);
                String formula = formatter.format(start)[1];
                String varName = DelayPreprocessor.generateAuxVariable(diagram, "delayed");
                DelayPreprocessor.generateAuxEquation(diagram, varName, formula);
                AstVarNode newVarNode = new AstVarNode(4);
                newVarNode.setName(varName);
                newVarNode.jjtSetParent(node);
                node.jjtReplaceChild(delayedNode, (Node)newVarNode);
                changed = true;
            }
            Node delayNode = node.jjtGetChild(1);
            changed |= this.process(delayNode, diagram);
        } else {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                Node childNode = node.jjtGetChild(i);
                changed |= this.process(childNode, diagram);
            }
        }
        return changed;
    }

    public static String generateAuxVariable(Diagram diagram, String baseName) throws Exception {
        EModel emodel = (EModel)diagram.getRole(EModel.class);
        int suffix = 1;
        String name = baseName;
        while (emodel.containsVariable(name)) {
            name = baseName + "_" + suffix;
            ++suffix;
        }
        emodel.declareVariable(name, (Object)0.0);
        return name;
    }

    public static void generateAuxEquation(Diagram diagram, String varName, String formula) throws Exception {
        String eqName = DefaultSemanticController.generateUniqueNodeName((Compartment)diagram, (String)"equation");
        biouml.model.Node node = new biouml.model.Node((DataCollection)diagram, (Base)new Stub((DataCollection)diagram, eqName, "math-equation"));
        Equation equation = new Equation((DiagramElement)node, "scalar_delayed", varName);
        equation.setFormula(formula);
        node.setRole((Role)equation);
        diagram.put((DiagramElement)node);
    }

    public static List<ExpressionOwner> getExpressionOwners(Diagram diagram) {
        return ((StreamEx)diagram.recursiveStream().map(DiagramElement::getRole).filter(ExpressionOwner.class::isInstance)).map(ExpressionOwner.class::cast).toList();
    }
}

