/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Node;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.Constraint;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Event;
import biouml.plugins.simulation.Preprocessor;
import biouml.standard.type.Base;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.Point;
import ru.biosoft.access.core.DataCollection;

public class ConstraintPreprocessor
extends Preprocessor {
    public static final String CONSTRAINTS_IGNORE = "Ignore";
    public static final String CONSTRAINTS_LOG = "Log message";
    public static final String CONSTRAINTS_STOP = "Stop simulation";
    private String constraintHandling = null;

    public ConstraintPreprocessor(String type) {
        this.constraintHandling = type;
    }

    @Override
    public boolean accept(Diagram diagram) {
        return diagram.getRole() instanceof EModel;
    }

    @Override
    public Diagram preprocess(Diagram diagram) throws Exception {
        if (this.constraintHandling.equals(CONSTRAINTS_IGNORE)) {
            return diagram;
        }
        boolean stop = this.constraintHandling.equals(CONSTRAINTS_STOP);
        EModel emodel = (EModel)diagram.getRole(EModel.class);
        for (Constraint constraint : emodel.getConstraints()) {
            String name = DefaultSemanticController.generateUniqueNodeName((Compartment)diagram, (String)(constraint.getDiagramElement().getName() + "_event"));
            Node node = new Node((DataCollection)diagram, (Base)new Stub((DataCollection)diagram, name));
            Event event = new Event((DiagramElement)node);
            event.setTrigger("!( " + constraint.getFormula() + " )");
            event.setEventAssignment(new Assignment[0]);
            event.setTriggerMessage(constraint.getMessage());
            DiagramElement de = diagram.getType().getSemanticController().createInstance((Compartment)diagram, Event.class, new Point(), (Object)event).getElement();
            if (stop) {
                de.getAttributes().add(new DynamicProperty("Terminal", Boolean.class, (Object)Boolean.TRUE));
            }
            diagram.put(de);
        }
        return diagram;
    }

    public static String[] getConstraintMethods() {
        return new String[]{CONSTRAINTS_STOP, CONSTRAINTS_LOG, CONSTRAINTS_IGNORE};
    }
}

