/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.ExpressionOwner;
import biouml.plugins.simulation.Preprocessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstPiece;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.DefaultParserContext;
import ru.biosoft.math.model.Function;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.PredefinedFunction;
import ru.biosoft.math.model.Utils;

public class BooleanPreprocessor
extends Preprocessor {
    private EModel emodel;
    private static Map<String, String> nameToNumeric = new HashMap(){
        {
            this.put("<", "NUMERIC_LT");
            this.put(">", "NUMERIC_GT");
            this.put("==", "NUMERIC_EQ");
            this.put(">=", "NUMERIC_GEQ");
            this.put("<=", "NUMERIC_LEQ");
            this.put("!=", "NUMERIC_NEQ");
            this.put("&&", "NUMERIC_AND");
            this.put("||", "NUMERIC_OR");
            this.put("xor", "NUMERIC_XOR");
            this.put("!", "NUMERIC_NOT");
        }
    };

    @Override
    public boolean accept(Diagram diagram) {
        return diagram.getRole() instanceof EModel;
    }

    @Override
    public Diagram preprocess(Diagram diagram) throws Exception {
        this.emodel = (EModel)diagram.getRole(EModel.class);
        List owners = diagram.recursiveStream().map(de -> de.getRole()).select(ExpressionOwner.class).toList();
        for (ExpressionOwner owner : owners) {
            String[] expressions = owner.getExpressions();
            for (int i = 0; i < expressions.length; ++i) {
                AstStart start = this.emodel.readMath(expressions[i], owner.getRole());
                if (start == null) continue;
                this.processConstants((Node)start);
                this.processFunctions((Node)start);
                this.processPiecewise((Node)start);
                expressions[i] = new LinearFormatter().format(start)[1];
            }
            owner.setExpressions(expressions);
            if (!(owner.getRole() instanceof Event)) continue;
            this.processEvent((Event)owner.getRole());
        }
        return diagram;
    }

    public void processConstants(Node node) {
        if (node instanceof AstConstant) {
            Node parent = node.jjtGetParent();
            if (((AstConstant)node).getValue().equals(true)) {
                node.jjtGetParent().jjtReplaceChild(node, (Node)Utils.createConstant((Object)1.0));
            } else if (((AstConstant)node).getValue().equals(false)) {
                node.jjtGetParent().jjtReplaceChild(node, (Node)Utils.createConstant((Object)0.0));
            }
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            this.processConstants(node.jjtGetChild(i));
        }
    }

    public void processFunctions(Node node) {
        Function f;
        if (node instanceof AstFunNode && (DefaultParserContext.isRelationalOperator((Function)(f = ((AstFunNode)node).getFunction())) || DefaultParserContext.isLogicalOperator((Function)f))) {
            Node parent = node.jjtGetParent();
            PredefinedFunction function = new PredefinedFunction(nameToNumeric.get(f.getName()), 7, 2);
            AstFunNode newNode = node.jjtGetNumChildren() == 2 ? Utils.applyFunction((Node)node.jjtGetChild(0), (Node)node.jjtGetChild(1), (Function)function) : Utils.applyFunction((Node)node.jjtGetChild(0), (Function)function);
            parent.jjtReplaceChild(node, (Node)newNode);
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            this.processFunctions(node.jjtGetChild(i));
        }
    }

    public void processEvent(Event event) {
        event.setTrigger("(" + event.getTrigger() + ") != 0");
    }

    public void processPiecewise(Node node) {
        if (node instanceof AstPiece && ((AstPiece)node).jjtGetNumChildren() == 2) {
            Node condition = node.jjtGetChild(0);
            PredefinedFunction f = new PredefinedFunction("!=", 2, 2);
            node.jjtReplaceChild(condition, (Node)Utils.applyFunction((Node)condition, (Node)Utils.createConstant((Object)0.0), (Function)f));
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            this.processPiecewise(node.jjtGetChild(i));
        }
    }
}

