/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.plugins.simulation.Span;
import java.util.Arrays;
import java.util.stream.Stream;
import one.util.streamex.DoubleStreamEx;

public class ArraySpan
implements Span {
    private double[] times;
    private boolean proper;

    public ArraySpan(double a, double b) {
        this(a, b, b - a);
    }

    public ArraySpan(double a, double b, double inc) {
        boolean bl = this.proper = b > a || inc < 0.0;
        if (inc == 0.0 || !this.proper) {
            return;
        }
        int length = (int)Math.ceil((b - a) / inc) + 1;
        this.times = new double[length];
        for (int i = 0; i < length - 1; ++i) {
            this.times[i] = a + (double)i * inc;
        }
        this.times[length - 1] = b;
        this.checkProper();
    }

    public ArraySpan(double[] times) {
        this.times = Arrays.copyOf(times, times.length);
        this.checkProper();
    }

    private void checkProper() {
        this.proper = DoubleStreamEx.of((double[])this.times).pairMap((a, b) -> a >= b ? 1.0 : 0.0).allMatch(x -> x == 0.0);
    }

    @Override
    public double getTimeStart() {
        return this.times[0];
    }

    @Override
    public double getTimeFinal() {
        return this.times[this.times.length - 1];
    }

    public double[] getTimes() {
        return this.times;
    }

    @Override
    public double getTime(int i) {
        if (i >= this.times.length) {
            throw new IndexOutOfBoundsException("ArraySpan index" + i + "> " + this.getLength());
        }
        return this.times[i];
    }

    @Override
    public int getLength() {
        if (this.times == null) {
            return 0;
        }
        return this.times.length;
    }

    @Override
    public boolean isProper() {
        return this.proper;
    }

    @Override
    public Span getRestrictedSpan(double a, double b) {
        if (this.times == null) {
            return null;
        }
        int n = 0;
        for (double time : this.times) {
            if (!(time > a) || !(time < b)) continue;
            ++n;
        }
        double[] newTimes = new double[n + 2];
        newTimes[0] = a;
        n = 1;
        for (double time : this.times) {
            if (!(time > a) || !(time < b)) continue;
            newTimes[n++] = time;
        }
        newTimes[n] = b;
        return new ArraySpan(newTimes);
    }

    @Override
    public void addPoints(double[] points) {
        this.times = Stream.of(points, this.times).flatMapToDouble(Arrays::stream).sorted().distinct().toArray();
        this.checkProper();
    }

    @Override
    public ArraySpan clone() {
        return new ArraySpan((double[])this.times.clone());
    }
}

