/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math.xml;

import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import one.util.streamex.IntStreamEx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;
import ru.biosoft.math.model.AbstractParser;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstFunctionDeclaration;
import ru.biosoft.math.model.AstPiece;
import ru.biosoft.math.model.AstPiecewise;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.DefaultParserContext;
import ru.biosoft.math.model.Function;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.ParserContext;
import ru.biosoft.math.model.PredefinedFunction;
import ru.biosoft.math.model.SimpleNode;
import ru.biosoft.math.model.UndeclaredFunction;
import ru.biosoft.math.model.Utils;
import ru.biosoft.math.model.VariableResolver;
import ru.biosoft.math.parser.ParserTreeConstants;
import ru.biosoft.util.XmlStream;
import ru.biosoft.util.XmlUtil;

public class MathMLParser
extends AbstractParser
implements ParserTreeConstants {
    protected Document xmlDoc = null;
    protected Hashtable<String, String> mathSignsMap = new Hashtable();
    protected Hashtable<String, CSymbol> csymbolMap = new Hashtable();
    protected Hashtable<String, CSymbol> csymbolURLMap = new Hashtable();
    private Map<String, String> replacements = new HashMap<String, String>();
    private static final Set<String> potentiallyNAryFunctions = new HashSet<String>(Arrays.asList("==", ">=", "<=", "<", ">"));
    protected String lambdaFunctionName = null;
    public static Set<String> parserConstants = new HashSet<String>(){
        {
            this.add("function");
            this.add("diff");
            this.add("piecewise");
            this.add("xor");
        }
    };

    public MathMLParser() {
        this.fillMathSignsMap();
    }

    public void setReplacements(Map<String, String> replacements) {
        this.replacements = replacements;
    }

    protected void fillMathSignsMap() {
        this.mathSignsMap.put("or", "||");
        this.mathSignsMap.put("and", "&&");
        this.mathSignsMap.put("not", "!");
        this.mathSignsMap.put("xor", "xor");
        this.mathSignsMap.put("gt", ">");
        this.mathSignsMap.put("lt", "<");
        this.mathSignsMap.put("eq", "==");
        this.mathSignsMap.put("leq", "<=");
        this.mathSignsMap.put("geq", ">=");
        this.mathSignsMap.put("neq", "!=");
        this.mathSignsMap.put("plus", "+");
        this.mathSignsMap.put("minus", "u-");
        this.mathSignsMap.put("minus", "-");
        this.mathSignsMap.put("times", "*");
        this.mathSignsMap.put("divide", "/");
        this.mathSignsMap.put("power", "^");
        this.mathSignsMap.put("root", "root");
        this.mathSignsMap.put("abs", "abs");
        this.mathSignsMap.put("exp", "exp");
        this.mathSignsMap.put("ln", "ln");
        this.mathSignsMap.put("log", "log");
        this.mathSignsMap.put("sin", "sin");
        this.mathSignsMap.put("cos", "cos");
        this.mathSignsMap.put("tan", "tan");
        this.mathSignsMap.put("cot", "cot");
        this.mathSignsMap.put("arcsin", "arcsin");
        this.mathSignsMap.put("arccos", "arccos");
        this.mathSignsMap.put("arctan", "arctan");
        this.mathSignsMap.put("arccosh", "arccosh");
        this.mathSignsMap.put("arcsinh", "arcsinh");
        this.mathSignsMap.put("arccot", "arccot");
        this.mathSignsMap.put("arccoth", "arccoth");
        this.mathSignsMap.put("arccsc", "arccsc");
        this.mathSignsMap.put("arccsch", "arccsch");
        this.mathSignsMap.put("arcsec", "arcsec");
        this.mathSignsMap.put("arcsech", "arcsech");
        this.mathSignsMap.put("arctanh", "arctanh");
        this.mathSignsMap.put("cosh", "cosh");
        this.mathSignsMap.put("coth", "coth");
        this.mathSignsMap.put("csc", "csc");
        this.mathSignsMap.put("csch", "csch");
        this.mathSignsMap.put("sec", "sec");
        this.mathSignsMap.put("sech", "sech");
        this.mathSignsMap.put("sinh", "sinh");
        this.mathSignsMap.put("tanh", "tanh");
        this.mathSignsMap.put("diff", "diff");
    }

    public void declareCSymbol(String name) {
        this.csymbolMap.put(name, new CSymbol(name, 4));
    }

    public void declareCSymbol(Function function) {
        String name = function.getName();
        this.csymbolMap.put(name, new CSymbol(name, 2));
        this.context.declareFunction(function);
    }

    public void declareCSymbol(String definitionURL, String varName) {
        this.declareCSymbol(definitionURL, varName, 0.0);
    }

    public void declareCSymbol(String definitionURL, String varName, double initialValue) {
        CSymbol csymbol = new CSymbol(varName, 4);
        csymbol.initialValue = initialValue;
        this.csymbolURLMap.put(definitionURL, csymbol);
    }

    public void declareCSymbol(String definitionURL, Function function) {
        String name = function.getName();
        this.csymbolURLMap.put(definitionURL, new CSymbol(name, 2));
        this.context.declareFunction(function);
    }

    public int parse(Document doc) {
        this.reinit();
        this.astStart = new AstStart(0);
        try {
            this.xmlDoc = doc;
            this.buildTree();
        }
        catch (Exception e) {
            this.fatalError("Can NOT build DOM document");
        }
        this.astStart.setStatus(this.status);
        this.astStart.setMessages(this.messages);
        return this.status;
    }

    @Override
    public int parse(String xmlString) {
        try {
            StringReader sr = new StringReader(xmlString);
            InputSource xmlSource = new InputSource(sr);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xmlSource);
            this.parse(doc);
        }
        catch (Exception e) {
            this.fatalError("Can NOT build DOM document");
        }
        return this.status;
    }

    public Set<Element> getRecursiveElements(Element element, String tag) {
        HashSet<Element> result = new HashSet<Element>();
        for (Element innerElement : XmlUtil.elements((Element)element)) {
            if (innerElement.getTagName().equals(tag)) {
                result.add(innerElement);
            }
            result.addAll(this.getRecursiveElements(innerElement, tag));
        }
        return result;
    }

    public Set<String> getFunctions(Element funcElement) {
        HashSet<String> result = new HashSet<String>();
        Set<Element> elements = this.getRecursiveElements(funcElement, "apply");
        for (Element innerFunction : elements) {
            org.w3c.dom.Node item = innerFunction.getChildNodes().item(1);
            if (!item.getNodeName().equals("ci")) continue;
            String innerFuncName = item.getFirstChild().getNodeValue();
            result.add(innerFuncName.trim());
        }
        return result;
    }

    public int parse(Element math) {
        try {
            this.reinit();
            this.astStart = new AstStart(0);
            Node astRoot = this.processMATH(math);
            if (astRoot != null) {
                int nChilds = this.astStart.jjtGetNumChildren();
                this.astStart.jjtAddChild(astRoot, nChilds);
            }
        }
        catch (Throwable t) {
            this.fatalError("Can not parse MathML element, error: " + t);
        }
        return this.status;
    }

    public void buildTree() {
        Document xmlRoot;
        Node astRoot;
        if (this.xmlDoc == null || this.astStart == null) {
            return;
        }
        if (this.context == null) {
            this.context = new DefaultParserContext();
        }
        if ((astRoot = this.buildAstTree(xmlRoot = this.xmlDoc)) != null) {
            int nChilds = this.astStart.jjtGetNumChildren();
            this.astStart.jjtAddChild(astRoot, nChilds);
        }
    }

    protected Node buildAstTree(org.w3c.dom.Node xmlRoot) {
        if (xmlRoot == null) {
            return null;
        }
        Node astRoot = null;
        for (org.w3c.dom.Node domNode = xmlRoot.getFirstChild(); domNode != null; domNode = domNode.getNextSibling()) {
            String domNodeName = domNode.getNodeName();
            if (!"math".equals(domNodeName)) continue;
            astRoot = this.processMATH(domNode);
            break;
        }
        return astRoot;
    }

    protected Node processMATH(org.w3c.dom.Node domNodeRoot) {
        if (domNodeRoot == null) {
            return null;
        }
        Node astRoot = null;
        for (org.w3c.dom.Node domNode = domNodeRoot.getFirstChild(); domNode != null; domNode = domNode.getNextSibling()) {
            Node node = this.processNode(domNode);
            if (node == null) continue;
            astRoot = node;
            break;
        }
        return astRoot;
    }

    protected Node processNode(org.w3c.dom.Node domNode) {
        String nodeName = domNode.getNodeName();
        if (nodeName.equals("apply")) {
            return this.processAPPLY(domNode);
        }
        if (nodeName.equals("lambda")) {
            return this.processLAMBDA(domNode);
        }
        if (nodeName.equals("ci")) {
            return this.processCI(domNode);
        }
        if (nodeName.equals("cn")) {
            return this.processCN((Element)domNode);
        }
        if (nodeName.equals("csymbol")) {
            return this.processCSYMBOL(domNode);
        }
        if (nodeName.equals("piecewise")) {
            return this.processPIECEWISE(domNode);
        }
        if (nodeName.equals("pi")) {
            return this.processPI(domNode);
        }
        if (nodeName.equals("exponentiale")) {
            return this.processEXP(domNode);
        }
        if (nodeName.equals("true")) {
            return this.processTRUE();
        }
        if (nodeName.equals("false")) {
            return this.processFALSE();
        }
        if (nodeName.equals("infinity")) {
            return this.processINFINITY();
        }
        if (nodeName.equals("notanumber")) {
            return this.processNAN();
        }
        if (nodeName.equals("semantics")) {
            return this.processMATH(domNode);
        }
        return null;
    }

    protected AstFunNode processAPPLY(org.w3c.dom.Node domNodeRoot) {
        org.w3c.dom.Node domNode;
        if (domNodeRoot == null) {
            return null;
        }
        AstFunNode astNode = null;
        for (domNode = domNodeRoot.getFirstChild(); domNode != null; domNode = domNode.getNextSibling()) {
            if (domNode.getNodeType() != 1) {
                continue;
            }
            String nodeName = domNode.getNodeName();
            astNode = nodeName.equals("csymbol") ? (AstFunNode)this.processCSYMBOL(domNode) : this.processFunction(domNode);
            domNode = domNode.getNextSibling();
            break;
        }
        if (astNode == null) {
            return null;
        }
        int argc = 0;
        Node logBase = null;
        Node rootDegree = null;
        if (domNode != null) {
            while (true) {
                if (domNode.getNodeType() != 1) {
                    if ((domNode = domNode.getNextSibling()) != null) continue;
                    break;
                }
                String qualName = domNode.getNodeName();
                Node qual = null;
                if (qualName.equals("bvar")) {
                    qual = this.processBVAR(domNode);
                    if (qual != null) {
                        ++argc;
                        int nChilds = astNode.jjtGetNumChildren();
                        astNode.jjtAddChild(qual, nChilds);
                    }
                } else if (qualName.equals("degree")) {
                    qual = this.processDEGREE(domNode);
                    rootDegree = qual;
                } else if (qualName.equals("logbase")) {
                    qual = this.processLOGBASE(domNode);
                    logBase = qual;
                }
                if (qual == null) break;
                domNode = domNode.getNextSibling();
            }
        }
        while (domNode != null) {
            if (domNode.getNodeType() != 1) {
                domNode = domNode.getNextSibling();
                continue;
            }
            Node child = null;
            child = this.processNode(domNode);
            if (child != null) {
                ++argc;
                int nChilds = astNode.jjtGetNumChildren();
                astNode.jjtAddChild(child, nChilds);
            }
            domNode = domNode.getNextSibling();
        }
        Function suspicious = astNode.getFunction();
        if (suspicious.getName().equals("-") && argc == 1) {
            this.setOperator(astNode, "u-");
        } else if (suspicious.getName().equals("log")) {
            if (logBase != null) {
                int nChilds = astNode.jjtGetNumChildren();
                astNode.jjtAddChild(logBase, nChilds);
            }
        } else if (suspicious.getName().equals("root")) {
            if (rootDegree == null) {
                rootDegree = new AstConstant(4);
                Integer two = 2;
                ((AstConstant)rootDegree).setValue(two);
            }
            int nChilds = astNode.jjtGetNumChildren();
            astNode.jjtAddChild(rootDegree, nChilds);
        } else if (potentiallyNAryFunctions.contains(suspicious.getName()) && argc > 2) {
            astNode = this.processNAryFunction(astNode, argc);
        }
        if (argc == 0) {
            this.processNullAryFunctions(astNode);
        }
        if (argc == 1) {
            this.processUnaryFunctions(astNode);
        }
        if (argc != (suspicious = astNode.getFunction()).getNumberOfParameters() && suspicious.getNumberOfParameters() != -1) {
            astNode = null;
        }
        return astNode;
    }

    protected AstFunNode processNAryFunction(AstFunNode node, int argc) {
        Function f = node.getFunction();
        String name = f.getName();
        int priority = f.getPriority();
        Node[] arguments = (Node[])IntStreamEx.range((int)argc).mapToObj(node::jjtGetChild).pairMap((a, b) -> Utils.applyFunction(a, b, (Function)new PredefinedFunction(name, priority, 2))).toArray(Node[]::new);
        return (AstFunNode)Utils.applyFunction(arguments, (Function)new PredefinedFunction("&&", 1, -1));
    }

    protected void processNullAryFunctions(AstFunNode node) {
        if (node.getFunction().getName().equals("+")) {
            node.jjtAddChild(Utils.createConstant(0), 0);
        } else if (node.getFunction().getName().equals("*")) {
            node.jjtAddChild(Utils.createConstant(1), 0);
        } else if (node.getFunction().getName().equals("&&")) {
            node.jjtAddChild(Utils.createConstant(true), 0);
        } else if (node.getFunction().getName().equals("||") || node.getFunction().getName().equals("xor")) {
            node.jjtAddChild(Utils.createConstant(false), 0);
        }
    }

    protected void processUnaryFunctions(AstFunNode node) {
        if (node.getFunction().getName().equals("&&")) {
            node.jjtAddChild(Utils.createConstant(true), 1);
        } else if (node.getFunction().getName().equals("||")) {
            node.jjtAddChild(Utils.createConstant(false), 1);
        } else if (node.getFunction().getName().equals("xor")) {
            node.jjtAddChild(Utils.createConstant(false), 1);
        }
    }

    protected AstVarNode processCI(org.w3c.dom.Node domNode) {
        AstVarNode var = new AstVarNode(4);
        String varName = domNode.getFirstChild().getNodeValue().trim();
        if (varName.equals("time") && this.context.containsVariable("_CONFLICTS_WITH_TIME_")) {
            varName = "_CONFLICTS_WITH_TIME_";
        }
        varName = this.processVariable(varName);
        var.setName(varName);
        if (domNode.getAttributes() != null) {
            XmlStream.nodes((NamedNodeMap)domNode.getAttributes()).findFirst(n -> n.getNodeName().equals("definitionURL")).ifPresent(n -> var.setDefinitionUrl(n.getNodeValue()));
        }
        return var;
    }

    protected AstVarNode processPI(org.w3c.dom.Node piNode) {
        AstVarNode astVar = new AstVarNode(4);
        astVar.setName("pi");
        return astVar;
    }

    protected AstVarNode processEXP(org.w3c.dom.Node expNode) {
        AstVarNode astVar = new AstVarNode(4);
        astVar.setName("exponentiale");
        return astVar;
    }

    protected AstConstant processTRUE() {
        AstConstant astCN = new AstConstant(7);
        astCN.setValue(true);
        return astCN;
    }

    protected AstConstant processFALSE() {
        AstConstant astCN = new AstConstant(7);
        astCN.setValue(false);
        return astCN;
    }

    protected AstConstant processINFINITY() {
        AstConstant astCN = new AstConstant(7);
        astCN.setValue(Double.POSITIVE_INFINITY);
        return astCN;
    }

    protected AstConstant processNAN() {
        AstConstant astCN = new AstConstant(7);
        astCN.setValue(Double.NaN);
        return astCN;
    }

    protected AstPiecewise processPIECEWISE(org.w3c.dom.Node domNodePW) {
        AstPiecewise astPW = new AstPiecewise(5);
        org.w3c.dom.Node domNode = domNodePW.getFirstChild();
        while (domNode != null) {
            if (domNode.getNodeType() != 1) {
                domNode = domNode.getNextSibling();
                continue;
            }
            String tagName = domNode.getNodeName();
            AstPiece piece = null;
            if (!tagName.equals("piece") && !tagName.equals("otherwise")) break;
            piece = this.processPIECE(domNode);
            if (piece != null) {
                astPW.jjtAddChild(piece, astPW.jjtGetNumChildren());
            }
            domNode = domNode.getNextSibling();
        }
        return astPW;
    }

    protected AstPiece processPIECE(org.w3c.dom.Node domNodePiece) {
        org.w3c.dom.Node domNode;
        AstPiece astPiece = new AstPiece(6);
        Node expr1 = null;
        Node expr2 = null;
        for (domNode = domNodePiece.getFirstChild(); domNode != null; domNode = domNode.getNextSibling()) {
            if (domNode.getNodeType() != 1) continue;
            expr1 = this.processNode(domNode);
            domNode = domNode.getNextSibling();
            break;
        }
        while (domNode != null) {
            if (domNode.getNodeType() == 1) {
                expr2 = this.processNode(domNode);
                domNode = domNode.getNextSibling();
                break;
            }
            domNode = domNode.getNextSibling();
        }
        if (expr2 instanceof AstPiecewise) {
            expr2 = MathMLParser.translatePiecewise((AstPiecewise)expr2);
        }
        if (domNodePiece.getNodeName().equals("piece")) {
            if (expr2 != null) {
                astPiece.jjtAddChild(expr2, astPiece.jjtGetNumChildren());
            }
            if (expr1 != null) {
                astPiece.jjtAddChild(expr1, astPiece.jjtGetNumChildren());
            }
        } else if (expr1 != null) {
            astPiece.jjtAddChild(expr1, astPiece.jjtGetNumChildren());
        }
        return astPiece;
    }

    protected AstConstant processCN(Element cnElement) {
        AstConstant constant = new AstConstant(7);
        String constName = cnElement.getFirstChild().getNodeValue().trim();
        if (Character.isLetter(constName.charAt(0)) || constName.charAt(0) == '_') {
            this.processConstant(constant, constName);
            return constant;
        }
        String base = "10";
        if (cnElement.hasAttribute("base")) {
            base = cnElement.getAttribute("base");
        }
        if (!base.equals("10")) {
            this.error("Unsupported base value = " + base);
        }
        String type = "real";
        if (cnElement.hasAttribute("type")) {
            type = cnElement.getAttribute("type");
        }
        Number value = new Double(0.0);
        try {
            if (type.equals("real")) {
                if (cnElement.getChildNodes().getLength() == 1) {
                    value = new Double(constName);
                }
            } else if (type.equals("double")) {
                if (cnElement.getChildNodes().getLength() == 1) {
                    value = new Double(constName);
                }
            } else if (type.equals("integer")) {
                if (cnElement.getChildNodes().getLength() == 1) {
                    value = Integer.valueOf(constName);
                }
            } else if (type.equals("e-notation")) {
                if (cnElement.getChildNodes().getLength() == 3) {
                    String factor = constName;
                    String power = cnElement.getLastChild().getNodeValue();
                    String e_string = factor.trim() + "e" + power.trim();
                    value = new Double(e_string);
                }
            } else if (type.equals("rational")) {
                if (cnElement.getChildNodes().getLength() == 3) {
                    String ch1 = cnElement.getFirstChild().getNodeValue();
                    String ch2 = cnElement.getLastChild().getNodeValue();
                    int numerator = Integer.parseInt(ch1.toString().trim());
                    int denominator = Integer.parseInt(ch2.toString().trim());
                    value = new Double((double)numerator / (double)denominator);
                }
            } else {
                this.error("Unsupported or unknown type value = " + type);
            }
        }
        catch (Throwable t) {
            this.error("Can NOT parse the const value = " + constName + ", error=" + t);
        }
        constant.setValue(value);
        return constant;
    }

    protected Node processCSYMBOL(org.w3c.dom.Node domNode) {
        String name;
        CSymbol csymbol = null;
        String definitionURL = domNode.getAttributes().getNamedItem("definitionURL").getNodeValue();
        if (definitionURL != null) {
            csymbol = this.csymbolURLMap.get(definitionURL);
            if (csymbol != null && csymbol.type == 4) {
                AstVarNode var = new AstVarNode(4);
                if (!this.context.containsVariable(csymbol.name) && !this.context.containsConstant(csymbol.name)) {
                    this.context.declareVariable(csymbol.name, csymbol.initialValue);
                }
                var.setName(csymbol.name);
                var.setIsCSymbol(true);
                return var;
            }
            if (csymbol != null && csymbol.type == 2) {
                AstFunNode astFunc = new AstFunNode(2);
                this.setOperator(astFunc, csymbol.name);
                return astFunc;
            }
        }
        if ((csymbol = this.csymbolMap.get(name = domNode.getFirstChild().getNodeValue().trim())) == null || csymbol.type == 4) {
            AstVarNode var = new AstVarNode(4);
            var.setName(this.processVariable(name));
            var.setIsCSymbol(true);
            return var;
        }
        if (csymbol.type == 2) {
            AstFunNode astFunc = new AstFunNode(2);
            this.setOperator(astFunc, name);
            return astFunc;
        }
        return null;
    }

    protected AstFunNode processFunction(org.w3c.dom.Node domNode) {
        String sign;
        AstFunNode astNode = new AstFunNode(2);
        String funcName = domNode.getNodeName();
        if (funcName.equals("csymbol") || funcName.equals("ci")) {
            funcName = domNode.getFirstChild().getNodeValue().trim();
        }
        if ((sign = this.mathSignsMap.get(funcName)) == null) {
            Function func;
            if (this.replacements.containsKey(funcName)) {
                funcName = this.replacements.get(funcName);
            }
            if ((func = this.context.getFunction(funcName)) == null) {
                this.warning("Unknown function '" + funcName + "'");
                func = new UndeclaredFunction(funcName, 7);
            }
            astNode.setFunction(func);
        } else {
            this.setOperator(astNode, sign);
        }
        return astNode;
    }

    public void setLambdaFunctionName(String lambdaFunctionName) {
        this.lambdaFunctionName = lambdaFunctionName;
    }

    protected AstFunctionDeclaration processLAMBDA(org.w3c.dom.Node domNodeRoot) {
        String tagName;
        if (domNodeRoot == null) {
            return null;
        }
        AstFunctionDeclaration astFD = new AstFunctionDeclaration(3);
        astFD.setName(this.lambdaFunctionName);
        ParserContext oldContext = this.getContext();
        astFD.init(oldContext);
        this.setContext(astFD);
        VariableResolver oldResolver = this.getVariableResolver();
        this.setVariableResolver(null);
        org.w3c.dom.Node domNode = domNodeRoot.getFirstChild();
        while (domNode != null) {
            if (domNode.getNodeType() != 1) {
                domNode = domNode.getNextSibling();
                continue;
            }
            tagName = domNode.getNodeName();
            AstVarNode bvar = null;
            if (!tagName.equals("bvar")) break;
            boolean declareVars = this.isDeclareUndefinedVariables();
            this.setDeclareUndefinedVariables(true);
            bvar = this.processBVAR(domNode);
            this.setDeclareUndefinedVariables(declareVars);
            if (bvar != null) {
                int nChilds = astFD.jjtGetNumChildren();
                astFD.jjtAddChild(bvar, nChilds);
            }
            domNode = domNode.getNextSibling();
        }
        while (domNode != null) {
            if (domNode.getNodeType() != 1) {
                domNode = domNode.getNextSibling();
                continue;
            }
            tagName = domNode.getNodeName();
            SimpleNode func = null;
            if (tagName.equals("apply")) {
                func = this.processAPPLY(domNode);
            } else if (tagName.equals("piecewise")) {
                func = this.processPIECEWISE(domNode);
            } else if (tagName.equals("ci")) {
                func = this.processCI(domNode);
            } else if (tagName.equals("cn")) {
                func = this.processCN((Element)domNode);
            } else if (tagName.equals("pi")) {
                func = this.processPI(domNode);
            } else if (tagName.equals("exponentiale")) {
                func = this.processEXP(domNode);
            } else if (tagName.equals("true")) {
                func = this.processTRUE();
            } else if (tagName.equals("false")) {
                func = this.processFALSE();
            } else if (tagName.equals("infinity")) {
                func = this.processINFINITY();
            } else if (tagName.equals("notanumber")) {
                func = this.processNAN();
            }
            if (func != null) {
                int nChilds = astFD.jjtGetNumChildren();
                astFD.jjtAddChild(func, nChilds);
            }
            domNode = domNode.getNextSibling();
        }
        this.setContext(oldContext);
        this.setVariableResolver(oldResolver);
        return astFD;
    }

    protected Node processDEGREE(org.w3c.dom.Node domNode) {
        if (this.getFirstChildElement(domNode) == null) {
            return null;
        }
        String type = this.getFirstChildElement(domNode).getNodeName();
        SimpleNode astNode = null;
        if (type.equals("cn")) {
            astNode = this.processCN((Element)this.getFirstChildElement(domNode));
        } else if (type.equals("ci")) {
            astNode = this.processCI(this.getFirstChildElement(domNode));
        }
        return astNode;
    }

    protected Node processLOGBASE(org.w3c.dom.Node domNode) {
        if (this.getFirstChildElement(domNode) == null) {
            return null;
        }
        String type = this.getFirstChildElement(domNode).getNodeName();
        SimpleNode astNode = null;
        if (type.equals("cn")) {
            astNode = this.processCN((Element)this.getFirstChildElement(domNode));
        } else if (type.equals("ci")) {
            astNode = this.processCI(this.getFirstChildElement(domNode));
        }
        return astNode;
    }

    protected AstVarNode processBVAR(org.w3c.dom.Node domNode) {
        if (this.getFirstChildElement(domNode) == null) {
            return null;
        }
        String type = this.getFirstChildElement(domNode).getNodeName();
        AstVarNode astNode = null;
        if (type.equals("ci")) {
            astNode = this.processCI(this.getFirstChildElement(domNode));
        }
        return astNode;
    }

    protected org.w3c.dom.Node getFirstChildElement(org.w3c.dom.Node domNode) {
        if (domNode == null) {
            return null;
        }
        for (domNode = domNode.getFirstChild(); domNode != null && domNode.getNodeType() != 1; domNode = domNode.getNextSibling()) {
        }
        return domNode;
    }

    public static Node translatePiecewise(AstPiecewise piecewise) {
        Node[] processedPieces = new Node[piecewise.jjtGetNumChildren()];
        for (int i = 0; i < piecewise.jjtGetNumChildren(); ++i) {
            AstPiece child = (AstPiece)piecewise.jjtGetChild(i);
            Node condition = child.getCondition();
            Node value = child.getValue();
            processedPieces[i] = condition == null ? value : Utils.applyFunction(condition, value, (Function)new PredefinedFunction("&&", 1, -1));
        }
        return Utils.applyFunction(processedPieces, (Function)new PredefinedFunction("||", 1, -1));
    }

    protected static class CSymbol {
        public String name;
        public int type;
        public double initialValue;

        public CSymbol(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

