/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math.xml;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstFunctionDeclaration;
import ru.biosoft.math.model.AstPiece;
import ru.biosoft.math.model.AstPiecewise;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.Formatter;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.ParserContext;
import ru.biosoft.math.model.Utils;

public class MathMLFormatter
implements Formatter {
    protected Document doc = null;
    protected Hashtable<String, String> mathSignsMap = new Hashtable();
    protected ParserContext parserContext;
    private final Map<String, String> definitionUrlToName;

    public ParserContext getParserContext() {
        return this.parserContext;
    }

    public void setParserContext(ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    public MathMLFormatter() {
        this.fillMathSignsMap();
        this.definitionUrlToName = new HashMap<String, String>();
    }

    @Override
    public String[] format(AstStart start) {
        this.createDocument();
        if (this.doc == null) {
            return null;
        }
        this.processStartNode(start, this.doc);
        return new String[]{"", this.dom2String()};
    }

    public void format(AstStart start, org.w3c.dom.Node parent, Document document) {
        if (parent != null) {
            this.doc = document;
            this.processStartNode(start, parent);
        }
    }

    protected void processStartNode(AstStart start, org.w3c.dom.Node parent) {
        Element math = this.doc.createElement("math");
        math.setAttribute("xmlns", "http://www.w3.org/1998/Math/MathML");
        parent.appendChild(math);
        for (Node node : Utils.children(start)) {
            this.processNode(node, math);
        }
    }

    protected void processNode(Node astNode, org.w3c.dom.Node parent) {
        if (astNode instanceof AstConstant) {
            this.processConstant((AstConstant)astNode, parent);
        } else if (astNode instanceof AstVarNode) {
            this.processVariable((AstVarNode)astNode, parent);
        } else if (astNode instanceof AstFunNode) {
            this.processFunction((AstFunNode)astNode, parent);
        } else if (astNode instanceof AstFunctionDeclaration) {
            this.processFunctionDeclaration((AstFunctionDeclaration)astNode, parent);
        } else if (astNode instanceof AstPiece) {
            this.processPiece((AstPiece)astNode, parent);
        } else if (astNode instanceof AstPiecewise) {
            this.processPiecewise((AstPiecewise)astNode, parent);
        }
    }

    protected void processPiecewise(AstPiecewise pw, org.w3c.dom.Node parent) {
        Element pwise = this.doc.createElement("piecewise");
        for (Node node : Utils.children(pw)) {
            this.processNode(node, pwise);
        }
        parent.appendChild(pwise);
    }

    protected void processPiece(AstPiece piece, org.w3c.dom.Node parent) {
        Element p = null;
        if (piece.jjtGetNumChildren() == 2) {
            p = this.doc.createElement("piece");
            this.processNode(piece.jjtGetChild(1), p);
            this.processNode(piece.jjtGetChild(0), p);
        } else {
            p = this.doc.createElement("otherwise");
            this.processNode(piece.jjtGetChild(0), p);
        }
        parent.appendChild(p);
    }

    protected void processConstant(AstConstant constant, org.w3c.dom.Node parent) {
        String name = null;
        name = constant.getName() != null ? constant.getName() : constant.getValue().toString();
        if ("true".equals(name) || "false".equals(name)) {
            parent.appendChild(this.doc.createElement(name));
        } else if ("pi".equals(name) || "exp".equals(name) || "exponentiale".equals(name)) {
            parent.appendChild(this.doc.createElement(name));
        } else {
            Element cn = this.doc.createElement("cn");
            Text cnValue = this.doc.createTextNode(name);
            cn.appendChild(cnValue);
            parent.appendChild(cn);
        }
    }

    protected void processVariable(AstVarNode var, org.w3c.dom.Node parent) {
        String name = var.getName();
        Text ciValue = this.doc.createTextNode(name);
        if (var.isCSymbol()) {
            Element csymbol = this.doc.createElement("csymbol");
            parent.appendChild(csymbol);
        } else if (this.definitionUrlToName.containsKey(name)) {
            Element csymbol = this.doc.createElement("csymbol");
            csymbol.appendChild(ciValue);
            csymbol.setAttribute("definitionURL", this.definitionUrlToName.get(name));
            csymbol.setAttribute("encoding", "text");
            parent.appendChild(csymbol);
        } else {
            Element ci = this.doc.createElement("ci");
            ci.appendChild(ciValue);
            parent.appendChild(ci);
        }
    }

    protected void processFunction(AstFunNode astFunc, org.w3c.dom.Node parent) {
        Element apply = this.doc.createElement("apply");
        parent.appendChild(apply);
        String sign = astFunc.getFunction().getName();
        String name = this.mathSignsMap.get(sign);
        if (name == null) {
            Text nameText;
            Element csymbolTag;
            name = sign;
            if (this.definitionUrlToName.containsKey(name)) {
                csymbolTag = this.doc.createElement("csymbol");
                apply.appendChild(csymbolTag);
                nameText = this.doc.createTextNode(name);
                csymbolTag.appendChild(nameText);
                csymbolTag.setAttribute("definitionURL", this.definitionUrlToName.get(name));
                csymbolTag.setAttribute("encoding", "text");
            } else if (this.parserContext.getFunction(name) != null) {
                Text funcName = this.doc.createTextNode(name);
                Element ciTag = this.doc.createElement("ci");
                ciTag.appendChild(funcName);
                apply.appendChild(ciTag);
            } else {
                csymbolTag = this.doc.createElement("csymbol");
                apply.appendChild(csymbolTag);
                nameText = this.doc.createTextNode(name);
                csymbolTag.appendChild(nameText);
            }
        } else if (astFunc.getFunction() instanceof AstFunctionDeclaration) {
            Element ciTag = this.doc.createElement("ci");
            apply.appendChild(ciTag);
            Text funcName = this.doc.createTextNode(name);
            ciTag.appendChild(funcName);
        } else {
            Element nameTag = this.doc.createElement(name);
            apply.appendChild(nameTag);
        }
        if (name.equals("log")) {
            if (astFunc.jjtGetNumChildren() == 2) {
                Element logbase = this.doc.createElement("logbase");
                apply.appendChild(logbase);
                this.processNode(astFunc.jjtGetChild(1), logbase);
                this.processNode(astFunc.jjtGetChild(0), apply);
            } else if (astFunc.jjtGetNumChildren() == 1) {
                this.processNode(astFunc.jjtGetChild(0), apply);
            }
            return;
        }
        if (name.equals("root")) {
            if (astFunc.jjtGetNumChildren() == 2) {
                Element degree = this.doc.createElement("degree");
                apply.appendChild(degree);
                this.processNode(astFunc.jjtGetChild(1), degree);
            }
            this.processNode(astFunc.jjtGetChild(0), apply);
            return;
        }
        if (name.equals("diff")) {
            int n = astFunc.jjtGetNumChildren();
            for (int i = 0; i < n - 1; ++i) {
                Element bvar = this.doc.createElement("bvar");
                apply.appendChild(bvar);
                this.processNode(astFunc.jjtGetChild(i), bvar);
            }
            this.processNode(astFunc.jjtGetChild(n - 1), apply);
            return;
        }
        for (Node node : Utils.children(astFunc)) {
            this.processNode(node, apply);
        }
    }

    protected void processFunctionDeclaration(AstFunctionDeclaration astFuncDecl, org.w3c.dom.Node parent) {
        Element lambda = this.doc.createElement("lambda");
        parent.appendChild(lambda);
        int n = astFuncDecl.jjtGetNumChildren();
        for (int i = 0; i < n - 1; ++i) {
            Element bvar = this.doc.createElement("bvar");
            lambda.appendChild(bvar);
            this.processNode(astFuncDecl.jjtGetChild(i), bvar);
        }
        this.processNode(astFuncDecl.jjtGetChild(n - 1), lambda);
    }

    protected void createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.newDocument();
        }
        catch (Throwable t) {
            System.out.println("Can NOT create DOM document");
            t.printStackTrace();
        }
    }

    protected String dom2String() {
        try {
            DOMSource source = new DOMSource(this.doc);
            StringWriter string = new StringWriter();
            StreamResult result = new StreamResult(string);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            String rawOut = string.toString();
            int n = rawOut.indexOf(60);
            n = rawOut.indexOf(60, n + 1);
            String out = rawOut.substring(n);
            return out;
        }
        catch (Throwable t) {
            System.out.println("Can NOT create create string representation of DOM documnet");
            t.printStackTrace();
            return null;
        }
    }

    protected void fillMathSignsMap() {
        this.mathSignsMap.put("||", "or");
        this.mathSignsMap.put("&&", "and");
        this.mathSignsMap.put("!", "not");
        this.mathSignsMap.put("xor", "xor");
        this.mathSignsMap.put(">", "gt");
        this.mathSignsMap.put("<", "lt");
        this.mathSignsMap.put("==", "eq");
        this.mathSignsMap.put("<=", "leq");
        this.mathSignsMap.put(">=", "geq");
        this.mathSignsMap.put("!=", "neq");
        this.mathSignsMap.put("+", "plus");
        this.mathSignsMap.put("-", "minus");
        this.mathSignsMap.put("u-", "minus");
        this.mathSignsMap.put("*", "times");
        this.mathSignsMap.put("/", "divide");
        this.mathSignsMap.put("^", "power");
        this.mathSignsMap.put("root", "root");
        this.mathSignsMap.put("abs", "abs");
        this.mathSignsMap.put("exp", "exp");
        this.mathSignsMap.put("ln", "ln");
        this.mathSignsMap.put("log", "log");
        this.mathSignsMap.put("sin", "sin");
        this.mathSignsMap.put("cos", "cos");
        this.mathSignsMap.put("tan", "tan");
        this.mathSignsMap.put("cot", "cot");
        this.mathSignsMap.put("sec", "sec");
        this.mathSignsMap.put("csc", "csc");
        this.mathSignsMap.put("sinh", "sinh");
        this.mathSignsMap.put("cosh", "cosh");
        this.mathSignsMap.put("tanh", "tanh");
        this.mathSignsMap.put("coth", "coth");
        this.mathSignsMap.put("sech", "sech");
        this.mathSignsMap.put("csch", "csch");
        this.mathSignsMap.put("arcsin", "arcsin");
        this.mathSignsMap.put("arccos", "arccos");
        this.mathSignsMap.put("arctan", "arctan");
        this.mathSignsMap.put("arcsec", "arcsec");
        this.mathSignsMap.put("arccsc", "arccsc");
        this.mathSignsMap.put("arccot", "arccot");
        this.mathSignsMap.put("arcsinh", "arcsinh");
        this.mathSignsMap.put("arccosh", "arccosh");
        this.mathSignsMap.put("arctanh", "arctanh");
        this.mathSignsMap.put("arcsech", "arcsech");
        this.mathSignsMap.put("arccsch", "arccsch");
        this.mathSignsMap.put("arccoth", "arccoth");
        this.mathSignsMap.put("diff", "diff");
        this.mathSignsMap.put("=", "eq");
        this.mathSignsMap.put("ceiling", "ceiling");
        this.mathSignsMap.put("floor", "floor");
        this.mathSignsMap.put("factorial", "factorial");
        this.mathSignsMap.put("quotient", "quotient");
        this.mathSignsMap.put("min", "min");
        this.mathSignsMap.put("max", "max");
        this.mathSignsMap.put("sqrt", "root");
    }

    public void declareCSymbol(String varName, String definitionURL) {
        this.definitionUrlToName.put(varName, definitionURL);
    }
}

