/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import ru.biosoft.graphics.BoxView;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.LineView;
import ru.biosoft.graphics.PathView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.TextView;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.font.ColorFont;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstFunctionDeclaration;
import ru.biosoft.math.model.AstPiece;
import ru.biosoft.math.model.AstPiecewise;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.Function;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.Utils;

public class FormulaViewBuilder {
    protected ColorFont defaultFont = new ColorFont("Arial", 1, 14, Color.black);
    protected ColorFont superscriptFont = new ColorFont("Arial", 1, 10, Color.black);
    protected ColorFont subscriptFont = new ColorFont("Arial", 1, 10, Color.black);
    protected ColorFont errorFont = new ColorFont("Arial", 1, 14, Color.red);
    protected Point offset = new Point(3, 0);
    protected Point subscript = new Point(1, -7);
    protected Point superscript = new Point(1, -7);
    protected int y;
    protected int dy;
    protected Pen defaultPen = new Pen(1.0f, Color.black);
    protected Pen boldPen = new Pen(2.0f, Color.black);

    public ColorFont getDefaultFont() {
        return this.defaultFont;
    }

    public FormulaViewBuilder() {
        this.init();
    }

    protected void init() {
    }

    @Nonnull
    public CompositeView createView(AstStart start, Graphics g) {
        CompositeView view = new CompositeView();
        if (start == null) {
            return view;
        }
        this.y = 0;
        this.dy = 0;
        for (Node node : Utils.children(start)) {
            view.add(this.createNodeView(node, g), 121, this.offset);
        }
        return view;
    }

    public static boolean needParenthis(AstFunNode node) {
        Function f0;
        if (!(node.jjtGetParent() instanceof AstFunNode)) {
            return false;
        }
        AstFunNode parent = (AstFunNode)node.jjtGetParent();
        Function f1 = parent.getFunction();
        Function f2 = node.getFunction();
        if (f1.getPriority() == 7 || f1.getName().equals("=") || f1.getName().equals("/")) {
            return false;
        }
        if (f2.getName().equals("u-") && parent.jjtGetChild(0) != node) {
            return true;
        }
        if (f2.getName().equals("u-") && parent.jjtGetParent() instanceof AstFunNode && (f0 = ((AstFunNode)parent.jjtGetParent()).getFunction()).getPriority() == 3 && parent.jjtGetParent().jjtGetChild(0) != parent) {
            return true;
        }
        return f1.getPriority() > f2.getPriority();
    }

    @Nonnull
    public View createTitleView(String title, ColorFont font, Graphics g) {
        if (title.indexOf(95) < 1) {
            return new TextView(title, font, g);
        }
        StringTokenizer tokens = new StringTokenizer(title, "_");
        CompositeView view = new CompositeView();
        int height = 0;
        while (tokens.hasMoreTokens()) {
            view.add((View)new TextView(tokens.nextToken(), font, g), 73, this.subscript);
            if (view.size() == 1) {
                height = view.getBounds().height;
            }
            if (font != this.defaultFont) continue;
            font = this.subscriptFont;
        }
        this.dy = (height - view.getBounds().height) / 2;
        return view;
    }

    protected void addAligned(CompositeView cv, Node node, int mode, Point offset, Graphics g) {
        this.dy = 0;
        View view = this.createNodeView(node, g);
        this.align(view);
        cv.add(view, mode | 8, offset);
    }

    protected void addAligned(CompositeView cv, View view, int mode, Point offset) {
        this.dy = 0;
        this.align(view);
        cv.add(view, mode | 8, offset);
    }

    protected void align(View view) {
        Rectangle r = view.getBounds();
        view.setLocation(r.x, this.y - r.height / 2 - this.dy);
    }

    @Nonnull
    public View createNodeView(Node node, Graphics g) {
        try {
            if (node instanceof AstConstant) {
                return this.createConstantView((AstConstant)node, g);
            }
            if (node instanceof AstVarNode) {
                return this.createVariableView((AstVarNode)node, g);
            }
            if (node instanceof AstFunNode) {
                return this.createFunctionView((AstFunNode)node, g);
            }
            if (node instanceof AstFunctionDeclaration) {
                return this.createFunctionDeclarationView((AstFunctionDeclaration)node, g);
            }
            if (node instanceof AstPiecewise) {
                return this.createPiecewiseView((AstPiecewise)node, g);
            }
        }
        catch (Throwable t) {
            new TextView(node.toString() + " - " + t.getMessage(), this.errorFont, g);
        }
        return new TextView(node.toString(), this.errorFont, g);
    }

    @Nonnull
    public View createConstantView(AstConstant node, Graphics g) {
        String text = node.getName();
        if (text == null) {
            text = node.getValue() != null ? node.getValue().toString() : "?";
        }
        return new TextView(text, this.defaultFont, g);
    }

    @Nonnull
    public View createVariableView(AstVarNode node, Graphics g) {
        return this.createTitleView(node.getName(), this.defaultFont, g);
    }

    @Nonnull
    public View createFunctionView(AstFunNode node, Graphics g) {
        Function f = node.getFunction();
        if ("/".equals(f.getName())) {
            return this.createDivisionView(node, g);
        }
        if ("diff".equals(f.getName())) {
            return this.createDifferentiationView(node, g);
        }
        if ("^".equals(f.getName())) {
            return this.createPowerView(node, g);
        }
        CompositeView view = new CompositeView();
        TextView funcView = null;
        if (f.getPriority() != 7) {
            String name = f.getName();
            if (name.equals("u-")) {
                name = "-";
            }
            funcView = new TextView(name, this.defaultFont, g);
            this.y = funcView.getBounds().y + funcView.getBounds().height / 2;
            view.add((View)funcView);
            if (f.getNumberOfParameters() == 1) {
                if (node.jjtGetNumChildren() == 1) {
                    this.addAligned(view, node.jjtGetChild(0), 9, this.offset, g);
                }
            } else if (node.jjtGetNumChildren() == 2) {
                this.addAligned(view, node.jjtGetChild(0), 14, this.offset, g);
                this.addAligned(view, node.jjtGetChild(1), 9, this.offset, g);
            }
        } else {
            TextView centerView = new TextView("(", this.defaultFont, g);
            this.y = centerView.getBounds().y + centerView.getBounds().height / 2;
            view.add((View)centerView);
            this.dy = 0;
            funcView = this.createTitleView(f.getName(), this.defaultFont, g);
            this.align((View)funcView);
            view.add((View)funcView, 14, null);
            int n = node.jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                this.addAligned(view, node.jjtGetChild(i), 9, null, g);
                if (i >= n - 1) continue;
                this.addAligned(view, (View)new TextView(", ", this.defaultFont, g), 9, null);
            }
            this.addAligned(view, (View)new TextView(")", this.defaultFont, g), 9, null);
            funcView = centerView;
        }
        this.dy = funcView.getBounds().y + funcView.getBounds().height / 2 - view.getBounds().y - view.getBounds().height / 2;
        boolean parenthis = FormulaViewBuilder.needParenthis(node);
        if (parenthis) {
            view.add((View)new TextView("(", this.defaultFont, g), 126, new Point(0, this.dy));
            view.add((View)new TextView(")", this.defaultFont, g), 121, new Point(0, this.dy));
        }
        return view;
    }

    @Nonnull
    public View createDivisionView(AstFunNode node, Graphics g) {
        CompositeView view = new CompositeView();
        view.add(this.createNodeView(node.jjtGetChild(0), g));
        int h = view.getBounds().height;
        view.add(this.createNodeView(node.jjtGetChild(1), g), 79, new Point(0, 5));
        this.addHorisontalLine(view, h);
        this.dy = (2 * h + 5 - view.getBounds().height) / 2;
        return view;
    }

    @Nonnull
    public View createDifferentiationView(AstFunNode node, Graphics g) {
        CompositeView view = new CompositeView();
        AstVarNode dx = (AstVarNode)node.jjtGetChild(0);
        view.add((View)new TextView("d(", this.defaultFont, g));
        view.add(this.createTitleView(dx.getName(), this.defaultFont, g), 25, null);
        this.addAligned(view, (View)new TextView(")", this.defaultFont, g), 9, null);
        int h = view.getBounds().height;
        AstVarNode dt = (AstVarNode)node.jjtGetChild(1);
        view.add(this.createTitleView("d(" + dt.getName() + ")", this.defaultFont, g), 79, new Point(0, 5));
        this.addHorisontalLine(view, h);
        this.dy = (2 * h + 5 - view.getBounds().height) / 2;
        return view;
    }

    protected void addHorisontalLine(CompositeView view, int h) {
        view.add((View)new LineView(this.defaultPen, 0.0f, 0.0f, (float)(view.getBounds().width + 5), 0.0f), 31, new Point(0, h + 2));
        view.add((View)new BoxView(null, null, 0, 0, view.getBounds().width + 7, 0), 31, new Point(0, h + 2));
    }

    @Nonnull
    protected View createPowerView(AstFunNode node, Graphics g) {
        CompositeView view = new CompositeView();
        this.dy = 0;
        view.add(this.createNodeView(node.jjtGetChild(0), g));
        int center = view.getBounds().y + view.getBounds().height / 2 + this.dy;
        ColorFont oldFont = this.defaultFont;
        this.defaultFont = this.superscriptFont;
        view.add(this.createNodeView(node.jjtGetChild(1), g), 57, this.superscript);
        this.defaultFont = oldFont;
        this.dy = center - view.getBounds().y - view.getBounds().height / 2;
        return view;
    }

    @Nonnull
    public View createFunctionDeclarationView(AstFunctionDeclaration node, Graphics g) {
        CompositeView view = new CompositeView();
        TextView centerView = new TextView("(", this.defaultFont, g);
        this.y = centerView.getBounds().y + centerView.getBounds().height / 2;
        view.add((View)centerView);
        this.dy = 0;
        View funcView = this.createTitleView(node.getName(), this.defaultFont, g);
        this.align(funcView);
        view.add(funcView, 14, null);
        int n = node.jjtGetNumChildren() - 1;
        for (int i = 0; i < n; ++i) {
            this.addAligned(view, node.jjtGetChild(i), 9, null, g);
            if (i >= n - 1) continue;
            this.addAligned(view, (View)new TextView(", ", this.defaultFont, g), 9, null);
        }
        this.addAligned(view, (View)new TextView(")", this.defaultFont, g), 9, null);
        this.addAligned(view, (View)new TextView(" = ", this.defaultFont, g), 9, null);
        this.addAligned(view, node.jjtGetChild(n), 9, null, g);
        this.dy = centerView.getBounds().y + centerView.getBounds().height / 2 - view.getBounds().y - view.getBounds().height / 2;
        return view;
    }

    @Nonnull
    public View createPiecewiseView(AstPiecewise node, Graphics g) {
        int i;
        CompositeView view = new CompositeView();
        int n = node.jjtGetNumChildren();
        int maxWidth = 0;
        View[] values = new View[n];
        int[] valueDy = new int[n];
        for (i = 0; i < n; ++i) {
            this.dy = 0;
            AstPiece piece = (AstPiece)node.jjtGetChild(i);
            values[i] = this.createNodeView(piece.getValue(), g);
            valueDy[i] = this.dy;
            maxWidth = Math.max(maxWidth, values[i].getBounds().width);
        }
        for (i = 0; i < n; ++i) {
            View pieceView = this.createPieceView((AstPiece)node.jjtGetChild(i), values[i], valueDy[i], maxWidth, g);
            view.add(pieceView, 76, new Point(0, 5));
        }
        int h = view.getBounds().height;
        GeneralPath path = new GeneralPath();
        path.moveTo(5.0f, -5.0f);
        path.quadTo(0.0f, -5.0f, 0.0f, 0.0f);
        path.lineTo(0.0, (double)h / 2.0 - 7.0);
        path.quadTo(0.0, (double)h / 2.0 - 1.0, -3.0, (double)h / 2.0);
        path.quadTo(0.0, (double)h / 2.0 + 1.0, 0.0, (double)h / 2.0 + 7.0);
        path.lineTo(0.0f, h);
        path.quadTo(0.0f, h + 4, 5.0f, h + 4);
        view.add((View)new PathView(this.boldPen, path), 126, this.offset);
        view.add((View)new BoxView(null, null, 0, 0, 3, 0), 126, null);
        this.dy = 0;
        return view;
    }

    public View createPieceView(AstPiece node, View valueView, int valueDy, int conditionOffset, Graphics g) {
        CompositeView view = new CompositeView();
        String text = "if ";
        if (node.getCondition() == null) {
            text = "otherwise";
        }
        TextView textView = new TextView(text, this.defaultFont, g);
        view.add((View)textView);
        this.y = textView.getBounds().y + textView.getBounds().height / 2;
        valueView.setLocation(-(conditionOffset + 10), 0);
        this.dy = valueDy;
        this.align(valueView);
        view.add(valueView);
        if (node.getCondition() != null) {
            this.addAligned(view, node.getCondition(), 9, this.offset, g);
        }
        return view;
    }
}

