/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import ru.biosoft.math.MathRoutines;
import ru.biosoft.math.model.ASTVisitor;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstPiece;
import ru.biosoft.math.model.AstPiecewise;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.DefaultParserContext;
import ru.biosoft.math.model.Function;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.Parser;
import ru.biosoft.math.model.PredefinedFunction;
import ru.biosoft.math.model.VariableResolver;

public class Utils {
    public static AstConstant createConstant(Object value) {
        AstConstant result = new AstConstant(7);
        result.setValue(value);
        return result;
    }

    public static AstVarNode createVariabl(String name) {
        AstVarNode result = new AstVarNode(4);
        result.setName(name);
        return result;
    }

    public static AstFunNode applyFunction(Node node1, Node node2, Function function) {
        AstFunNode astFunNode = new AstFunNode(2);
        astFunNode.setFunction(function);
        astFunNode.jjtAddChild(node1, 0);
        astFunNode.jjtAddChild(node2, 1);
        return astFunNode;
    }

    public static AstFunNode applyFunction(Node node1, Function function) {
        AstFunNode astFunNode = new AstFunNode(2);
        astFunNode.setFunction(function);
        astFunNode.jjtAddChild(node1, 0);
        return astFunNode;
    }

    public static Node applyFunction(Node[] nodes, Function function) {
        Node firstArgument = nodes[0];
        for (int i = 1; i < nodes.length; ++i) {
            firstArgument = Utils.applyFunction(firstArgument, nodes[i], function);
        }
        return firstArgument;
    }

    public static Node applyFunction(AstStart node1, AstStart node2, Function function) {
        Node n1 = Utils.cloneAST(node1.jjtGetChild(0));
        Node n2 = Utils.cloneAST(node2.jjtGetChild(0));
        return Utils.applyFunction(n1, n2, function);
    }

    public static Node applyPlus(AstStart node1, AstStart node2) {
        return Utils.applyFunction(node1, node2, (Function)new PredefinedFunction("+", 3, -1));
    }

    public static Node applyMinus(Node node1, Node node2) {
        return Utils.applyFunction(node1, node2, (Function)new PredefinedFunction("-", 3, -1));
    }

    public static Node applyPlus(Node[] nodes) {
        return Utils.applyFunction(nodes, (Function)new PredefinedFunction("+", 3, -1));
    }

    public static AstFunNode applyTimes(Node node1, Node node2) {
        return Utils.applyFunction(node1, node2, (Function)new PredefinedFunction("*", 4, -1));
    }

    public static AstFunNode applyDivide(Node node1, Node node2) {
        return Utils.applyFunction(node1, node2, (Function)new PredefinedFunction("/", 4, -1));
    }

    public static Node cloneAST(Node node) {
        Node destNode = node.cloneAST();
        Utils.copyChildren(node, destNode);
        return destNode;
    }

    private static void copyChildren(Node srcNode, Node destNode) {
        for (int i = 0; i < srcNode.jjtGetNumChildren(); ++i) {
            destNode.jjtAddChild(Utils.cloneAST(srcNode.jjtGetChild(i)), i);
        }
    }

    public static boolean equalsAST(Node node1, Node node2) {
        if (node1 == null) {
            return node2 == null;
        }
        if (!node1.equals(node2)) {
            return false;
        }
        if (node1.jjtGetNumChildren() != node2.jjtGetNumChildren()) {
            return false;
        }
        for (int i = 0; i < node1.jjtGetNumChildren(); ++i) {
            if (Utils.equalsAST(node1.jjtGetChild(i), node2.jjtGetChild(i))) continue;
            return false;
        }
        return true;
    }

    private static void substituteVarsInPlace(Node node, Map<String, String> mapping) {
        if (node instanceof AstVarNode) {
            AstVarNode varNode = (AstVarNode)node;
            String substName = mapping.get(varNode.getName());
            if (substName != null) {
                varNode.setName(substName);
            }
        } else {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                Utils.substituteVarsInPlace(node.jjtGetChild(i), mapping);
            }
        }
    }

    public static AstStart substituteVars(AstStart math, Map<String, String> srcToDestVars) {
        Node node = Utils.cloneAST(math);
        Utils.substituteVarsInPlace(node, srcToDestVars);
        return (AstStart)node;
    }

    public static AstStart createStart(Node node) {
        AstStart astStart = new AstStart(0);
        astStart.jjtAddChild(node, 0);
        return astStart;
    }

    public static void calculateVariables(Node node, Map<String, ? extends Object> values) {
        if (node instanceof AstVarNode) {
            Node parent;
            AstVarNode varNode = (AstVarNode)node;
            String varName = varNode.getName();
            Object value = values.get(varName);
            if (value != null && (parent = node.jjtGetParent()) != null) {
                AstConstant constant = new AstConstant(7);
                constant.setValue(value);
                parent.jjtReplaceChild(node, constant);
            }
        } else {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                Utils.calculateVariables(node.jjtGetChild(i), values);
            }
        }
    }

    public static Node optimizeAST(Node node) {
        Node optimized = Utils.cloneAST(node);
        Utils.pruneFunctions(optimized);
        Utils.optimizeDummyExpressions(optimized);
        return optimized;
    }

    public static void optimizeDummyExpressions(Node node) {
        if (node instanceof AstFunNode || node instanceof AstStart) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                Utils.optimizeDummyExpressions(node.jjtGetChild(i));
            }
        }
        if (node instanceof AstFunNode) {
            AstFunNode funNode = (AstFunNode)node;
            Function function = funNode.getFunction();
            String functionName = function.getName();
            if ("+".equals(functionName)) {
                Node arg1 = node.jjtGetChild(0);
                Node arg2 = node.jjtGetChild(1);
                if (arg1 instanceof AstConstant && Utils.getAsDouble((AstConstant)arg1) == 0.0) {
                    Utils.replaceNode(node, arg2);
                }
                if (arg2 instanceof AstConstant && Utils.getAsDouble((AstConstant)arg2) == 0.0) {
                    Utils.replaceNode(node, arg1);
                }
            } else if ("*".equals(functionName)) {
                Node arg1 = node.jjtGetChild(0);
                Node arg2 = node.jjtGetChild(1);
                if (arg1 instanceof AstConstant) {
                    Double v1 = Utils.getAsDouble((AstConstant)arg1);
                    if (v1 == 1.0) {
                        Utils.replaceNode(node, arg2);
                    } else if (v1 == 0.0) {
                        Utils.replaceNode(node, arg1);
                    }
                }
                if (arg2 instanceof AstConstant) {
                    Double v2 = Utils.getAsDouble((AstConstant)arg2);
                    if (v2 == 1.0) {
                        Utils.replaceNode(node, arg1);
                    } else if (v2 == 0.0) {
                        Utils.replaceNode(node, arg2);
                    }
                }
            } else if ("^".equals(functionName)) {
                Node arg1 = node.jjtGetChild(0);
                Node arg2 = node.jjtGetChild(1);
                if (arg1 instanceof AstConstant && Utils.getAsDouble((AstConstant)arg1) == 1.0) {
                    Utils.replaceNode(node, arg1);
                }
                if (arg2 instanceof AstConstant) {
                    Double v2 = Utils.getAsDouble((AstConstant)arg2);
                    if (v2 == 1.0) {
                        Utils.replaceNode(node, arg1);
                    }
                    if (v2 == 0.0) {
                        AstConstant constant = new AstConstant(7);
                        constant.setValue(1.0);
                        node.jjtGetParent().jjtReplaceChild(node, constant);
                    }
                }
            } else if ("/".equals(functionName)) {
                Node arg2;
                Node arg1 = node.jjtGetChild(0);
                if (Utils.equalsAST(arg1, arg2 = node.jjtGetChild(1))) {
                    AstConstant constant = new AstConstant(7);
                    constant.setValue(1.0);
                    node.jjtGetParent().jjtReplaceChild(node, constant);
                } else {
                    Double v2;
                    Double v1;
                    if (arg1 instanceof AstConstant && (v1 = Utils.getAsDouble((AstConstant)arg1)) == 0.0) {
                        Utils.replaceNode(node, arg1);
                    }
                    if (arg2 instanceof AstConstant && (v2 = Utils.getAsDouble((AstConstant)arg2)) == 1.0) {
                        Utils.replaceNode(node, arg1);
                    }
                }
            }
        }
    }

    private static void replaceNode(Node node, Node arg1) {
        Node parent = node.jjtGetParent();
        if (parent != null) {
            parent.jjtReplaceChild(node, arg1);
        }
    }

    public static void visitAST(Node node, ASTVisitor astVisitor) throws Exception {
        Utils.visitAST(node, new ASTVisitor[]{astVisitor});
    }

    public static void visitAST(Node node, ASTVisitor[] astVisitors) throws Exception {
        if (node == null) {
            return;
        }
        if (node instanceof AstStart) {
            for (ASTVisitor visitor : astVisitors) {
                visitor.visitStart((AstStart)node);
            }
        } else {
            for (ASTVisitor visitor : astVisitors) {
                visitor.visitNode(node);
            }
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Utils.visitAST(node.jjtGetChild(i), astVisitors);
        }
    }

    public static void visitAST(Node node, Collection<ASTVisitor> astVisitors) throws Exception {
        if (node == null) {
            return;
        }
        if (node instanceof AstStart) {
            for (ASTVisitor visitor : astVisitors) {
                visitor.visitStart((AstStart)node);
            }
        } else {
            for (ASTVisitor visitor : astVisitors) {
                visitor.visitNode(node);
            }
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Utils.visitAST(node.jjtGetChild(i), astVisitors);
        }
    }

    public static void pruneFunctions(Node node) {
        int i;
        if (node == null) {
            return;
        }
        if (node instanceof AstFunNode || node instanceof AstStart || node instanceof AstPiecewise || node instanceof AstPiece) {
            for (i = 0; i < node.jjtGetNumChildren(); ++i) {
                Utils.pruneFunctions(node.jjtGetChild(i));
            }
        }
        if (node instanceof AstFunNode) {
            boolean allChildrenAreConstants = true;
            for (int i2 = 0; i2 < node.jjtGetNumChildren(); ++i2) {
                if (node.jjtGetChild(i2) instanceof AstConstant) continue;
                allChildrenAreConstants = false;
                break;
            }
            if (allChildrenAreConstants) {
                AstFunNode funNode = (AstFunNode)node;
                Node result = Utils.calculateFunctionApplicationResult(funNode);
                Node parent = node.jjtGetParent();
                parent.jjtReplaceChild(node, result);
            }
        } else if (node instanceof AstPiecewise) {
            for (i = 0; i < node.jjtGetNumChildren(); ++i) {
                AstPiece piece = (AstPiece)node.jjtGetChild(i);
                if (piece.jjtGetNumChildren() == 1) {
                    Node otherwise = piece.jjtGetChild(0);
                    node.jjtGetParent().jjtReplaceChild(node, otherwise);
                    return;
                }
                Node condition = piece.getCondition();
                if (condition instanceof AstConstant) {
                    Object condValue = ((AstConstant)condition).getValue();
                    if (!(condValue instanceof Boolean)) {
                        return;
                    }
                    if (!((Boolean)condValue).booleanValue()) continue;
                    Node result = piece.getValue();
                    node.jjtGetParent().jjtReplaceChild(node, result);
                    return;
                }
                return;
            }
        }
    }

    private static Node calculateFunctionApplicationResult(AstFunNode funNode) {
        Function function = funNode.getFunction();
        String functionName = function.getName();
        if ("+".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(Utils.getAsDouble(arg1) + Utils.getAsDouble(arg2));
            return constant;
        }
        if ("-".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(Utils.getAsDouble(arg1) - Utils.getAsDouble(arg2));
            return constant;
        }
        if ("*".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(Utils.getAsDouble(arg1) * Utils.getAsDouble(arg2));
            return constant;
        }
        if ("/".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(Utils.getAsDouble(arg1) / Utils.getAsDouble(arg2));
            return constant;
        }
        if ("^".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(Math.pow(Utils.getAsDouble(arg1), Utils.getAsDouble(arg2)));
            return constant;
        }
        if ("root".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(Math.pow(Utils.getAsDouble(arg1), 1.0 / Utils.getAsDouble(arg2)));
            return constant;
        }
        if ("u-".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(-Utils.getAsDouble(arg1).doubleValue());
            return constant;
        }
        if ("abs".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(Math.abs(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("exp".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(Math.exp(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("ln".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(Math.log(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("log".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            if (funNode.jjtGetNumChildren() == 1) {
                AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
                constant.setValue(Math.log10(Utils.getAsDouble(arg1)));
                return constant;
            }
            if (funNode.jjtGetNumChildren() == 2) {
                AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
                AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
                constant.setValue(Math.log(Utils.getAsDouble(arg1)) / Math.log(Utils.getAsDouble(arg2)));
                return constant;
            }
            return null;
        }
        if ("sin".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(Math.sin(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("cos".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(Math.cos(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("tan".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(Math.tan(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("cot".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(1.0 / Math.tan(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("arcsin".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(Math.asin(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("arccos".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(Math.acos(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("arccosh".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(MathRoutines.ach(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("arcsinh".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(MathRoutines.ash(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("arccoth".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(MathRoutines.actgh(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("arctanh".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(MathRoutines.atgh(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("sec".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(MathRoutines.sec(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("sech".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(MathRoutines.sech(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("csc".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(MathRoutines.csec(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("csch".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(MathRoutines.csech(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("arcsec".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(MathRoutines.asec(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("arcsech".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(MathRoutines.asech(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("arccsc".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(MathRoutines.acsec(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("arccoth".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(MathRoutines.actgh(Utils.getAsDouble(arg1)));
            return constant;
        }
        if ("||".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(Utils.getAsBoolean(arg1) != false || Utils.getAsBoolean(arg2) != false);
            return constant;
        }
        if ("&&".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(Utils.getAsBoolean(arg1) != false && Utils.getAsBoolean(arg2) != false);
            return constant;
        }
        if ("!".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            constant.setValue(Utils.getAsBoolean(arg1) == false);
            return constant;
        }
        if ("xor".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(Utils.getAsBoolean(arg1) ^ Utils.getAsBoolean(arg2));
            return constant;
        }
        if (">".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(Utils.getAsDouble(arg1) > Utils.getAsDouble(arg2));
            return constant;
        }
        if ("<".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(Utils.getAsDouble(arg1) < Utils.getAsDouble(arg2));
            return constant;
        }
        if (">=".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(Utils.getAsDouble(arg1) >= Utils.getAsDouble(arg2));
            return constant;
        }
        if ("<=".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(Utils.getAsDouble(arg1) <= Utils.getAsDouble(arg2));
            return constant;
        }
        if ("==".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(Utils.getAsDouble(arg1).equals(Utils.getAsDouble(arg2)));
            return constant;
        }
        if ("!=".equals(functionName)) {
            AstConstant constant = new AstConstant(7);
            AstConstant arg1 = (AstConstant)funNode.jjtGetChild(0);
            AstConstant arg2 = (AstConstant)funNode.jjtGetChild(1);
            constant.setValue(!Utils.getAsDouble(arg1).equals(Utils.getAsDouble(arg2)));
            return constant;
        }
        return funNode;
    }

    private static Double getAsDouble(AstConstant arg) {
        Object value = arg.getValue();
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return 0.0;
    }

    private static Boolean getAsBoolean(AstConstant arg) {
        Object value = arg.getValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        return false;
    }

    public static StreamEx<Node> children(Node start) {
        return IntStreamEx.range((int)0, (int)start.jjtGetNumChildren()).mapToObj(start::jjtGetChild);
    }

    public static StreamEx<Node> deepChildren(Node start) {
        return StreamEx.ofTree((Object)start, n -> n.jjtGetNumChildren() == 0 ? null : IntStream.range(0, n.jjtGetNumChildren()).mapToObj(n::jjtGetChild));
    }

    public static List<String> getVariables(Node node) {
        return Utils.variables(node).toList();
    }

    public static StreamEx<String> variables(Node node) {
        return (StreamEx)Utils.deepChildren(node).select(AstVarNode.class).map(AstVarNode::getName).distinct();
    }

    public static Stream<String> variables(String formula) {
        DefaultParserContext context = new DefaultParserContext();
        ru.biosoft.math.parser.Parser parser = new ru.biosoft.math.parser.Parser();
        parser.setContext(context);
        parser.setVariableResolver(new SimpleVariableResolver(context));
        parser.parse(formula);
        return context.getVariableNames().stream();
    }

    public static Stream<String> functions(String formula) {
        ru.biosoft.math.parser.Parser parser = new ru.biosoft.math.parser.Parser();
        parser.parse(formula);
        return Utils.deepChildren(parser.getStartNode()).select(AstFunNode.class).map(n -> n.getFunction().getName());
    }

    public static String formatErrors(Parser p) {
        List<String> errorList = p.getMessages();
        StringBuilder msg = new StringBuilder();
        for (String error : errorList) {
            msg.append("    ");
            msg.append(error);
            msg.append("\n");
        }
        return msg.toString();
    }

    public static AstStart parseExpression(String expression) {
        ru.biosoft.math.parser.Parser parser = new ru.biosoft.math.parser.Parser();
        parser.setContext(new DefaultParserContext());
        int status = parser.parse(expression);
        if (status != 0) {
            throw new ParseException(expression, status);
        }
        return parser.getStartNode();
    }

    public static Object evaluateExpression(AstStart ast, Map<String, Object> scope) {
        Utils.calculateVariables(ast, scope);
        List<String> otherVariables = Utils.getVariables(ast);
        if (!otherVariables.isEmpty()) {
            throw new UnresolvedVariablesException(otherVariables);
        }
        Utils.pruneFunctions(ast);
        Node lastNode = ast.jjtGetChild(ast.jjtGetNumChildren() - 1);
        return ((AstConstant)lastNode).getValue();
    }

    public static Object evaluateExpression(String expression, Map<String, Object> scope) {
        return Utils.evaluateExpression(Utils.parseExpression(expression), scope);
    }

    public static void renameVariableInAST(Node node, Map<String, String> replaces) {
        if (node == null) {
            return;
        }
        ((StreamEx)Utils.deepChildren(node).select(AstVarNode.class).filter(var -> replaces.containsKey(var.getName()))).forEach(var -> {
            String replacement = (String)replaces.get(var.getName());
            var.setName(replacement);
            var.setTitle(replacement);
        });
    }

    public static class SimpleVariableResolver
    implements VariableResolver {
        private DefaultParserContext context;

        SimpleVariableResolver(DefaultParserContext context) {
            this.context = context;
        }

        @Override
        public String getVariableName(String variableTitle) {
            return this.context.containsVariable(variableTitle) ? variableTitle : null;
        }

        @Override
        public String resolveVariable(String variableName) {
            return this.context.containsVariable(variableName) ? variableName : null;
        }
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String expression, int errorCode) {
            super("Can not parse '" + expression + "': " + errorCode);
        }
    }

    public static class UnresolvedVariablesException
    extends RuntimeException {
        public UnresolvedVariablesException(List<String> variables) {
            super("Unresolved variales: " + variables);
        }
    }
}

