/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math.model;

import ru.biosoft.math.model.Node;

public abstract class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;

    public SimpleNode(int i) {
        this.id = i;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
        n.jjtSetParent(this);
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    @Override
    public void jjtReplaceChild(Node oldChild, Node newChild) {
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            if (this.jjtGetChild(i) != oldChild) continue;
            oldChild.jjtSetParent(null);
            this.children[i] = newChild;
            newChild.jjtSetParent(this);
            break;
        }
    }

    public void dump(StringBuffer msg, String prefix) {
        msg.append(this.toString(prefix));
        msg.append("\r\n");
        if (this.children != null) {
            prefix = prefix + "  ";
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(msg, prefix);
            }
        }
    }
}

