/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math.model;

import ru.biosoft.math.model.AstPiece;
import ru.biosoft.math.model.AstPiecewise;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.Node;

public abstract class PiecewiseExtFormatter
extends LinearFormatter {
    private static int auxVariableCounter = 0;
    protected String auxVariableName = null;
    StringBuilder declarations = null;

    protected void resetVariableCounter() {
        auxVariableCounter = 0;
    }

    @Override
    public String[] format(AstStart start) {
        this.result = new StringBuilder();
        this.declarations = new StringBuilder();
        int n = start.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Node node = start.jjtGetChild(i);
            if (node instanceof AstPiecewise) {
                this.processPiecewise((AstPiecewise)node);
                continue;
            }
            this.processNode(node);
        }
        return new String[]{this.declarations.toString(), this.result.toString()};
    }

    @Override
    protected void processPiecewise(AstPiecewise node) {
        int n = node.jjtGetNumChildren();
        StringBuilder oldResult = this.result;
        this.result = new StringBuilder();
        String local_auxVariableName = this.auxVariableName;
        this.auxVariableName = "piecewise_" + auxVariableCounter++;
        if (n > 0) {
            this.processPiecewiseBegin(node);
            this.processIf((AstPiece)node.jjtGetChild(0));
            for (int i = 1; i < n; ++i) {
                this.result.append(this.endl);
                AstPiece piece = (AstPiece)node.jjtGetChild(i);
                if ("Otherwise".equals(piece.toString())) {
                    this.processOtherwise(piece);
                    continue;
                }
                this.processElseIf(piece);
            }
            this.processPiecewiseEnd(node);
        }
        AstVarNode varNode = new AstVarNode(4);
        varNode.setName(this.auxVariableName);
        node.jjtGetParent().jjtReplaceChild(node, varNode);
        this.declarations.append(this.result.toString() + this.endl);
        this.result = oldResult;
        this.result.append(this.auxVariableName);
        this.auxVariableName = local_auxVariableName;
    }

    protected abstract void processIf(AstPiece var1);

    protected abstract void processElseIf(AstPiece var1);

    protected abstract void processOtherwise(AstPiece var1);

    protected abstract void processPiecewiseBegin(Node var1);

    protected abstract void processPiecewiseEnd(Node var1);
}

