/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math.model;

import java.util.ArrayList;
import java.util.List;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstFunctionDeclaration;
import ru.biosoft.math.model.AstPiece;
import ru.biosoft.math.model.AstPiecewise;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.Formatter;
import ru.biosoft.math.model.Function;
import ru.biosoft.math.model.Node;

public class LinearFormatter
implements Formatter {
    protected StringBuilder result;
    protected String endl = System.getProperty("line.separator");

    @Override
    public String[] format(AstStart start) {
        this.result = new StringBuilder();
        if (start != null) {
            int n = start.jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                this.processNode(start.jjtGetChild(i));
            }
        }
        return new String[]{"", String.valueOf(this.result)};
    }

    public List<String> format(List<AstStart> starts) {
        ArrayList<String> result = new ArrayList<String>();
        for (AstStart start : starts) {
            result.add(this.format(start)[1]);
        }
        return result;
    }

    protected void processNode(Node node) {
        if (node instanceof AstConstant) {
            this.processConstant((AstConstant)node);
        } else if (node instanceof AstVarNode) {
            this.processVariable((AstVarNode)node);
        } else if (node instanceof AstFunNode) {
            this.processFunction((AstFunNode)node);
        } else if (node instanceof AstFunctionDeclaration) {
            this.processFunctionDeclaration((AstFunctionDeclaration)node);
        } else if (node instanceof AstPiecewise) {
            this.processPiecewise((AstPiecewise)node);
        } else {
            this.result.append("???" + node + "???");
            System.out.println("Unknown node type, node=" + node);
        }
    }

    protected void processConstant(AstConstant node) {
        if (node.getName() != null) {
            this.result.append(node.getName());
        } else {
            Object value = node.getValue();
            if (value instanceof String) {
                this.result.append("\"" + value + "\"");
            } else {
                this.result.append(node.getValue());
            }
        }
    }

    protected void processVariable(AstVarNode node) {
        this.result.append(node.getName());
    }

    protected void processFunction(AstFunNode node) {
        boolean parenthis;
        Function function = node.getFunction();
        String name = this.getFunctionName(function.getName());
        if (name.startsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        if (parenthis = this.needParenthis(node)) {
            this.result.append('(');
        }
        if (function.getPriority() == 7) {
            this.result.append(name);
            this.result.append("(");
            int n = node.jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                this.processNode(node.jjtGetChild(i));
                if (i >= n - 1) continue;
                this.result.append(", ");
            }
            this.result.append(")");
            return;
        }
        if (function.getNumberOfParameters() == 1) {
            if (name.equals("u-")) {
                name = "-";
            }
            this.result.append(name);
            this.processNode(node.jjtGetChild(0));
        } else {
            int n = node.jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                this.processNode(node.jjtGetChild(i));
                if (i >= n - 1) continue;
                if (function.getPriority() == 4 || function.getPriority() == 6) {
                    this.result.append(name);
                    continue;
                }
                this.result.append(" " + name + " ");
            }
        }
        if (parenthis) {
            this.result.append(')');
        }
    }

    protected String getFunctionName(String name) {
        return name;
    }

    public boolean needParenthis(AstFunNode node) {
        if (!(node.jjtGetParent() instanceof AstFunNode)) {
            return false;
        }
        AstFunNode parent = (AstFunNode)node.jjtGetParent();
        Function f1 = parent.getFunction();
        Function f2 = node.getFunction();
        if (f1.getPriority() == 7 || f1.getName().equals("=")) {
            return false;
        }
        if (f2.getName().equals("u-")) {
            Function f0;
            if (parent.jjtGetChild(0) != node) {
                return true;
            }
            if (parent.jjtGetParent() instanceof AstFunNode && (f0 = ((AstFunNode)parent.jjtGetParent()).getFunction()).getPriority() == 3 && parent.jjtGetParent().jjtGetChild(0) != parent) {
                return true;
            }
        }
        if (f2.getPriority() == 1 && f1.getPriority() == 2 || f2.getPriority() == 2 && f1.getPriority() == 1) {
            return true;
        }
        if (f1.getPriority() > f2.getPriority()) {
            return true;
        }
        return f1.getPriority() == f2.getPriority() && f1.getPriority() != 7 && parent.jjtGetChild(0) != node;
    }

    protected void processFunctionDeclaration(AstFunctionDeclaration node) {
        this.result.append("function ");
        this.result.append(node.getName());
        this.result.append("(");
        int n = node.jjtGetNumChildren() - 1;
        for (int i = 0; i < n; ++i) {
            this.processNode(node.jjtGetChild(i));
            if (i >= n - 1) continue;
            this.result.append(", ");
        }
        this.result.append(")");
        this.result.append(" = ");
        this.processNode(node.jjtGetChild(n));
    }

    protected void processPiecewise(AstPiecewise node) {
        this.result.append("piecewise");
        this.result.append("( ");
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.result.append("; ");
            }
            this.processPiece((AstPiece)node.jjtGetChild(i));
        }
        this.result.append(" )");
    }

    protected void processPiece(AstPiece node) {
        if (node.getCondition() != null) {
            this.processNode(node.getCondition());
            this.result.append(" => ");
        }
        this.processNode(node.getValue());
    }

    protected void append(String str) {
        this.result.append(str);
    }

    protected void append(String before, Node node, String after) {
        this.result.append(before);
        this.processNode(node);
        this.result.append(after);
    }

    protected void append(String start, Node node1, String middle, Node node2, String end) {
        this.result.append(start);
        this.processNode(node1);
        this.result.append(middle);
        this.processNode(node2);
        this.result.append(end);
    }
}

