/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math.model;

import java.util.HashMap;
import java.util.Map;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstFunctionDeclaration;
import ru.biosoft.math.model.AstPiece;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.Function;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.PiecewiseExtFormatter;

public class JavaFormatter
extends PiecewiseExtFormatter {
    protected Map<String, Integer> historicalIndexes;
    private static final Map<String, String> badConstants = new HashMap<String, String>();
    private static final Map<String, String> badFuncNames = new HashMap<String, String>();

    public JavaFormatter(Map<String, Integer> historicalIndexes) {
        badConstants.put("exp", "exponentiale");
        badFuncNames.put("abs", "Math.abs");
        badFuncNames.put("arccos", "Math.acos");
        badFuncNames.put("arcsin", "Math.asin");
        badFuncNames.put("arctan", "Math.atan");
        badFuncNames.put("cos", "Math.cos");
        badFuncNames.put("exp", "Math.exp");
        badFuncNames.put("ln", "Math.log");
        badFuncNames.put("sqrt", "Math.sqrt");
        badFuncNames.put("sin", "Math.sin");
        badFuncNames.put("tan", "Math.tan");
        badFuncNames.put("xor", "^");
        badFuncNames.put("floor", "Math.floor");
        badFuncNames.put("ceiling", "Math.ceil");
        badFuncNames.put("random", "Math.random");
        badFuncNames.put("uniform", "MathRoutines.uniform");
        badFuncNames.put("normal", "MathRoutines.normal");
        badFuncNames.put("logNormal", "MathRoutines.logNormal");
        badFuncNames.put("binomial", "MathRoutines.binomial");
        badFuncNames.put("factorial", "MathRoutines.factorial");
        badFuncNames.put("sinh", "Math.sinh");
        badFuncNames.put("cosh", "Math.cosh");
        badFuncNames.put("tanh", "Math.tanh");
        badFuncNames.put("coth", "MathRoutines.ctgh");
        badFuncNames.put("arccosh", "MathRoutines.ach");
        badFuncNames.put("arcsinh", "MathRoutines.ash");
        badFuncNames.put("arccoth", "MathRoutines.actgh");
        badFuncNames.put("arctanh", "MathRoutines.atgh");
        badFuncNames.put("sec", "MathRoutines.sec");
        badFuncNames.put("csc", "MathRoutines.csec");
        badFuncNames.put("csch", "MathRoutines.csech");
        badFuncNames.put("sech", "MathRoutines.sech");
        badFuncNames.put("arcsec", "MathRoutines.asec");
        badFuncNames.put("arccsc", "MathRoutines.acsec");
        badFuncNames.put("arcsech", "MathRoutines.asech");
        badFuncNames.put("arccsch", "MathRoutines.acsech");
        badFuncNames.put("arccot", "MathRoutines.actg");
        this.historicalIndexes = historicalIndexes;
    }

    @Override
    protected String getFunctionName(String name) {
        String strTestName = badFuncNames.get(name);
        return strTestName == null ? name : strTestName;
    }

    @Override
    protected void processFunction(AstFunNode node) {
        Node second;
        Function function = node.getFunction();
        String functionName = function.getName();
        Node first = node.jjtGetNumChildren() > 0 ? node.jjtGetChild(0) : null;
        Node node2 = second = node.jjtGetNumChildren() > 1 ? node.jjtGetChild(1) : null;
        if (function.getPriority() == 6 && "^".equals(functionName)) {
            if (second instanceof AstConstant && ((AstConstant)second).getValue() instanceof Number) {
                double value = ((Number)((AstConstant)second).getValue()).doubleValue();
                if (value == -1.0) {
                    this.append("(1.0/(", first, "))");
                } else if (value == 0.0) {
                    this.append("1");
                } else if (value == 1.0) {
                    this.append("(", first, ")");
                } else if (value >= -1.0 && value < 1000.0 && Math.floor(value) == value) {
                    this.append("MathRoutines.pow(", first, ", (int)", second, ")");
                } else {
                    this.append("Math.pow(", first, ",", second, ")");
                }
            } else {
                this.append("Math.pow(", first, ",", second, ")");
            }
            return;
        }
        if (function.getPriority() == 7) {
            if ("delay".equals(functionName)) {
                Integer index;
                if (this.historicalIndexes != null && first instanceof AstVarNode && (index = this.historicalIndexes.get(((AstVarNode)first).getName())) != null) {
                    this.append("delay(" + index + ", time - (", second, "))");
                }
            } else if ("root".equals(functionName)) {
                this.append("(Math.pow(", first, ", 1.0/( (double)(", second, "))))");
            } else if ("ln".equals(functionName)) {
                this.append("Math.log(", first, ")");
            } else if ("log".equals(functionName)) {
                if (second == null) {
                    this.append("Math.log10(", first, ")");
                } else {
                    this.append("(Math.log(", first, ")/Math.log(", second, "))");
                }
            } else if ("cot".equals(functionName)) {
                this.append("(1/Math.tan(", first, "))");
            } else if ("mod".equals(functionName)) {
                this.append("((", first, ")%(", second, "))");
            } else if ("rem".equals(functionName)) {
                this.append("((", first, ")%(", second, "))");
            } else if ("quotient".equals(functionName)) {
                this.append("Math.floor(", first, "/", second, ")");
            } else {
                super.processFunction(node);
            }
            return;
        }
        super.processFunction(node);
    }

    @Override
    protected void processConstant(AstConstant node) {
        if (badConstants.containsKey(node.getName())) {
            this.result.append(badConstants.get(node.getName()));
            return;
        }
        String formatted = this.processSpecialValues(node);
        if (formatted != null) {
            this.result.append(formatted);
            return;
        }
        super.processConstant(node);
    }

    protected String processSpecialValues(AstConstant node) {
        if (node.getValue() == null) {
            return null;
        }
        if (node.getValue().equals(Double.POSITIVE_INFINITY)) {
            return "Double.POSITIVE_INFINITY";
        }
        if (node.getValue().equals(Double.NEGATIVE_INFINITY)) {
            return "Double.NEGATIVE_INFINITY";
        }
        if (node.getValue().equals(Double.NaN)) {
            return "Double.NaN";
        }
        return null;
    }

    @Override
    protected void processFunctionDeclaration(AstFunctionDeclaration node) {
        int n = node.jjtGetNumChildren() - 1;
        this.append("    protected static double " + node.getName() + "(");
        for (int i = 0; i < n; ++i) {
            this.append("double ", node.jjtGetChild(i), i < n - 1 ? ", " : "");
        }
        this.append(")" + this.endl + "    {" + this.endl + "         return ", node.jjtGetChild(n), ";" + this.endl + "    }" + this.endl);
    }

    @Override
    protected void processIf(AstPiece node) {
        this.append("if (", node.getCondition(), ") {" + this.endl + "    " + this.auxVariableName + " = ", node.getValue(), ";" + this.endl + "}");
    }

    @Override
    protected void processElseIf(AstPiece node) {
        this.append("else if (", node.getCondition(), ") {" + this.endl + "    " + this.auxVariableName + " = ", node.getValue(), ";" + this.endl + "}");
    }

    @Override
    protected void processOtherwise(AstPiece node) {
        this.append("else {" + this.endl + "    " + this.auxVariableName + " = ", node.getValue(), ";" + this.endl + "}" + this.endl);
    }

    @Override
    protected void processPiecewiseEnd(Node node) {
    }

    @Override
    protected void processPiecewiseBegin(Node node) {
        this.append("double " + this.auxVariableName + " = 0;" + this.endl);
    }
}

