/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math.model;

import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.Function;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.PredefinedFunction;
import ru.biosoft.math.model.SimpleNode;
import ru.biosoft.math.model.Utils;
import ru.biosoft.math.model.VariableResolver;

public class HTMLLinearFormatter
extends LinearFormatter {
    private VariableResolver variableResolver;

    public String[] format(AstStart start, VariableResolver resolver, boolean isMinus) {
        this.result = new StringBuilder();
        if (start != null) {
            this.variableResolver = resolver;
            if (isMinus) {
                this.changeOperations(start);
            }
            Utils.children(start).forEach(this::processNode);
        }
        String resultFormula = String.valueOf(this.result);
        if (isMinus) {
            resultFormula = resultFormula.startsWith("&minus;") ? resultFormula.substring(7) : "&minus; " + resultFormula;
        }
        return new String[]{"", resultFormula};
    }

    protected void changeOperations(SimpleNode start) {
        int n = start.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            PredefinedFunction newFunction;
            Node node = start.jjtGetChild(i);
            if (!(node instanceof AstFunNode) || this.needParenthis((AstFunNode)node)) continue;
            Function function = ((AstFunNode)node).getFunction();
            String name = this.getFunctionName(function.getName());
            if (name.equals("-")) {
                newFunction = new PredefinedFunction("+", function.getPriority(), function.getNumberOfParameters());
                ((AstFunNode)node).setFunction(newFunction);
            }
            if (name.equals("+")) {
                newFunction = new PredefinedFunction("-", function.getPriority(), function.getNumberOfParameters());
                ((AstFunNode)node).setFunction(newFunction);
            }
            if (name.equals("u-")) {
                newFunction = new PredefinedFunction("u+", function.getPriority(), function.getNumberOfParameters());
                ((AstFunNode)node).setFunction(newFunction);
            }
            this.changeOperations((SimpleNode)node);
        }
    }

    @Override
    protected void processVariable(AstVarNode node) {
        String name = node.getName();
        String title = this.variableResolver.resolveVariable(name);
        if (title == null) {
            title = name;
        }
        if (title.indexOf("$") > -1) {
            title = "[" + title + "]";
        }
        title = title.replace("$", "");
        title = title.replace("\"", "");
        title = title.replace("<br>", "");
        this.result.append("<nobr>" + title + "</nobr>");
    }

    @Override
    protected void processFunction(AstFunNode node) {
        Function function = node.getFunction();
        String name = this.getFunctionName(function.getName());
        if (name.startsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        AstFunNode parent = null;
        Function parentFunction = null;
        String parentName = "";
        if (node.jjtGetParent() instanceof AstFunNode) {
            parent = (AstFunNode)node.jjtGetParent();
            parentFunction = parent.getFunction();
            parentName = this.getFunctionName(parentFunction.getName());
        }
        boolean parenthis = this.needParenthis(node);
        if (parentName != null && parentName.equals("^")) {
            if (parent.jjtGetChild(1).equals(node)) {
                if (parenthis) {
                    this.result.append("<sup>");
                }
            } else {
                this.result.append("<nobr>(");
            }
        } else if (parenthis) {
            this.result.append("(");
        }
        if (function.getPriority() == 7) {
            this.result.append(name);
            this.result.append("(");
            int n = node.jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                this.processNode(node.jjtGetChild(i));
                if (i >= n - 1) continue;
                this.result.append(", ");
            }
            this.result.append(")");
            return;
        }
        if (function.getNumberOfParameters() == 1) {
            if (name.equals("u-")) {
                name = "&minus;";
            }
            if (name.equals("u+")) {
                name = "+";
            }
            this.result.append(name + " ");
            this.processNode(node.jjtGetChild(0));
        } else {
            if (name.equals("-")) {
                name = "&minus;";
            }
            if (name.equals("&&")) {
                name = "<u>and</u>";
            }
            if (name.equals("||")) {
                name = "<u>or</u>";
            }
            if (name.equals("!")) {
                name = "<u>not</u>";
            }
            if (name.equals("^") && node.jjtGetChild(1) instanceof AstVarNode) {
                String oldTitle = ((AstVarNode)node.jjtGetChild(1)).getName();
                String newTitle = "<sup>" + oldTitle + "</sup></nobr>";
                ((AstVarNode)node.jjtGetChild(1)).setTitle(newTitle);
            }
            if (name.equals("^") && node.jjtGetChild(1) instanceof AstConstant) {
                String newName;
                String oldName = ((AstConstant)node.jjtGetChild(1)).getName();
                if (oldName != null) {
                    newName = "<sup>" + oldName + "</sup></nobr>";
                } else {
                    Object value = ((AstConstant)node.jjtGetChild(1)).getValue();
                    newName = "<sup>" + value + "</sup></nobr>";
                }
                ((AstConstant)node.jjtGetChild(1)).setName(newName);
            }
            if (name.equals("==")) {
                name = "=";
            }
            int n = node.jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                this.processNode(node.jjtGetChild(i));
                if (i >= n - 1 || name.equals("^")) continue;
                this.result.append(" " + name + " ");
            }
        }
        if (parentName != null && parentName.equals("^") && parent.jjtGetChild(1).equals(node)) {
            if (parenthis) {
                this.result.append("</sup></nobr>");
            }
        } else if (parenthis) {
            this.result.append(")");
        }
    }
}

