/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import ru.biosoft.math.model.Function;
import ru.biosoft.math.model.ParserContext;
import ru.biosoft.math.model.PredefinedFunction;

public class DefaultParserContext
implements ParserContext {
    public static final String OR = "||";
    public static final String AND = "&&";
    public static final String NOT = "!";
    public static final String XOR = "xor";
    public static final String GT = ">";
    public static final String LT = "<";
    public static final String GEQ = ">=";
    public static final String LEQ = "<=";
    public static final String EQ = "==";
    public static final String NEQ = "!=";
    public static final String PLUS = "+";
    public static final String MINUS = "-";
    public static final String UMINUS = "u-";
    public static final String TIMES = "*";
    public static final String DIVIDE = "/";
    public static final String MOD = "mod";
    public static final String POWER = "^";
    public static final String ROOT = "root";
    public static final String ABS = "abs";
    public static final String EXP = "exp";
    public static final String LN = "ln";
    public static final String LOG = "log";
    public static final String SQRT = "sqrt";
    public static final String MAX = "max";
    public static final String MIN = "min";
    public static final String SIN = "sin";
    public static final String COS = "cos";
    public static final String TAN = "tan";
    public static final String COT = "cot";
    public static final String ASIN = "arcsin";
    public static final String ACOS = "arccos";
    public static final String ATAN = "arctan";
    public static final String ARCCOSH = "arccosh";
    public static final String ARCSINH = "arcsinh";
    public static final String ARCCOT = "arccot";
    public static final String ARCCOTH = "arccoth";
    public static final String ARCSCS = "arccsc";
    public static final String ARCCSCH = "arccsch";
    public static final String ARCSEC = "arcsec";
    public static final String ARCSECH = "arcsech";
    public static final String ARCTANH = "arctanh";
    public static final String COSH = "cosh";
    public static final String COTH = "coth";
    public static final String CSC = "csc";
    public static final String CSCH = "csch";
    public static final String SEC = "sec";
    public static final String SECH = "sech";
    public static final String SINH = "sinh";
    public static final String TANH = "tanh";
    public static final String DIFF = "diff";
    public static final String ASSIGNMENT = "=";
    public static final String FLOOR = "floor";
    public static final String CEIL = "ceiling";
    public static final String FACTORIAL = "factorial";
    public static final String DELAY = "delay";
    public static final String RATE_OF = "rateOf";
    public static final String REM = "rem";
    public static final String QUOTIENT = "quotient";
    public static final String CONST_TRUE = "true";
    public static final String CONST_FALSE = "false";
    public static final String CONST_PI = "pi";
    public static final String CONST_E = "exp";
    public static final String CONST_EXPONENTIALE = "exponentiale";
    public static final String CONST_AVOGADRO = "avogadro";
    public static final String CONST_INFINITY = "Infinity";
    public static final String CONST_NaN = "NaN";
    public static final double CONST_AVOGADRO_VALUE = 6.02214179E23;
    private static final Set<String> logicalOperators = new HashSet<String>(){
        {
            this.add(DefaultParserContext.OR);
            this.add(DefaultParserContext.XOR);
            this.add(DefaultParserContext.AND);
            this.add(DefaultParserContext.NOT);
        }
    };
    private static final Set<String> relationalOperators = new HashSet<String>(){
        {
            this.add(DefaultParserContext.GT);
            this.add(DefaultParserContext.LT);
            this.add(DefaultParserContext.EQ);
            this.add(DefaultParserContext.GEQ);
            this.add(DefaultParserContext.LEQ);
            this.add(DefaultParserContext.NEQ);
        }
    };
    ParserContext parent = null;
    protected HashMap<String, Object> variablesMap = new HashMap();
    protected HashMap<String, String> substitutionMap = new HashMap();
    protected HashMap<String, Object> constantsMap = new HashMap();
    protected HashMap<String, Function> functionsMap = new HashMap();

    public DefaultParserContext() {
        DefaultParserContext.declareStandardConstants(this);
        DefaultParserContext.declareStandardOperators(this);
    }

    public ParserContext getParentContext() {
        return this.parent;
    }

    public void setParentContext(ParserContext parent) {
        this.parent = parent;
    }

    @Override
    public boolean containsConstant(String name) {
        if (this.constantsMap.containsKey(name)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsConstant(name);
        }
        return false;
    }

    @Override
    public Object getConstantValue(String name) {
        Object value = this.constantsMap.get(name);
        if (value == null && this.parent != null) {
            value = this.parent.getConstantValue(name);
        }
        return value;
    }

    @Override
    public void declareConstant(String name, Object value) {
        this.constantsMap.put(name, value);
    }

    @Override
    public void removeConstant(String name) {
        this.constantsMap.remove(name);
    }

    public static void declareStandardConstants(ParserContext context) {
        context.declareConstant(CONST_TRUE, true);
        context.declareConstant(CONST_FALSE, false);
        context.declareConstant(CONST_PI, Math.PI);
        context.declareConstant("exp", Math.E);
        context.declareConstant(CONST_EXPONENTIALE, Math.E);
        context.declareConstant(CONST_AVOGADRO, 6.02214179E23);
        context.declareConstant(CONST_INFINITY, Double.POSITIVE_INFINITY);
        context.declareConstant(CONST_NaN, Double.NaN);
        context.declareConstant("__INITIAL_VALUE__", 0.0);
    }

    @Override
    public boolean containsVariable(String name) {
        if (this.variablesMap.containsKey(name)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsVariable(name);
        }
        return false;
    }

    @Override
    public Object getVariableValue(String name) {
        Object value = this.variablesMap.get(name);
        if (value == null && this.parent != null) {
            value = this.parent.getVariableValue(name);
        }
        return value;
    }

    @Override
    public void declareVariable(String name, Object value) {
        this.variablesMap.put(name, value);
    }

    public Set<String> getVariableNames() {
        return this.variablesMap.keySet();
    }

    @Override
    public Function getFunction(String name) {
        Function function;
        if (name.startsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        if (this.substitutionMap.containsKey(name)) {
            name = this.substitutionMap.get(name);
        }
        if ((function = this.functionsMap.get(name)) == null && this.parent != null) {
            function = this.parent.getFunction(name);
        }
        return function;
    }

    @Override
    public void declareFunction(Function function) {
        this.functionsMap.put(function.getName(), function);
    }

    public void declareFunctionNameSubstitution(String name, String replaceBy) {
        this.substitutionMap.put(name, replaceBy);
    }

    public static boolean isLogicalConstant(String name) {
        return CONST_TRUE.equals(name) || CONST_FALSE.equals(name);
    }

    public static boolean isLogicalOperator(Function f) {
        return logicalOperators.contains(f.getName());
    }

    public static boolean isRelationalOperator(Function f) {
        return relationalOperators.contains(f.getName());
    }

    public static void declareStandardOperators(ParserContext context) {
        context.declareFunction(new PredefinedFunction(OR, 1, -1));
        context.declareFunction(new PredefinedFunction(AND, 1, -1));
        context.declareFunction(new PredefinedFunction(NOT, 5, 1));
        context.declareFunction(new PredefinedFunction(XOR, 1, -1));
        context.declareFunction(new PredefinedFunction(GT, 2, -1));
        context.declareFunction(new PredefinedFunction(LT, 2, -1));
        context.declareFunction(new PredefinedFunction(EQ, 2, -1));
        context.declareFunction(new PredefinedFunction(GEQ, 2, -1));
        context.declareFunction(new PredefinedFunction(LEQ, 2, -1));
        context.declareFunction(new PredefinedFunction(NEQ, 2, 2));
        context.declareFunction(new PredefinedFunction(PLUS, 3, -1));
        context.declareFunction(new PredefinedFunction(MINUS, 3, 2));
        context.declareFunction(new PredefinedFunction(UMINUS, 5, 1));
        context.declareFunction(new PredefinedFunction(TIMES, 4, -1));
        context.declareFunction(new PredefinedFunction(DIVIDE, 4, 2));
        context.declareFunction(new PredefinedFunction(MOD, 7, 2));
        context.declareFunction(new PredefinedFunction(POWER, 6, 2));
        context.declareFunction(new PredefinedFunction(ROOT, 7, -1));
        context.declareFunction(new PredefinedFunction(ABS, 7, 1));
        context.declareFunction(new PredefinedFunction("exp", 7, 1));
        context.declareFunction(new PredefinedFunction(LN, 7, 1));
        context.declareFunction(new PredefinedFunction(LOG, 7, -1));
        context.declareFunction(new PredefinedFunction(SQRT, 7, 1));
        context.declareFunction(new PredefinedFunction(MAX, 7, -1));
        context.declareFunction(new PredefinedFunction(MIN, 7, -1));
        context.declareFunction(new PredefinedFunction(DIFF, 7, -1));
        context.declareFunction(new PredefinedFunction(ASSIGNMENT, 8, 2));
        context.declareFunction(new PredefinedFunction(SIN, 7, 1));
        context.declareFunction(new PredefinedFunction(COS, 7, 1));
        context.declareFunction(new PredefinedFunction(TAN, 7, 1));
        context.declareFunction(new PredefinedFunction(COT, 7, 1));
        context.declareFunction(new PredefinedFunction(ASIN, 7, 1));
        context.declareFunction(new PredefinedFunction(ACOS, 7, 1));
        context.declareFunction(new PredefinedFunction(ATAN, 7, 1));
        context.declareFunction(new PredefinedFunction(ARCCOSH, 7, 1));
        context.declareFunction(new PredefinedFunction(ARCCOT, 7, 1));
        context.declareFunction(new PredefinedFunction(ARCCOTH, 7, 1));
        context.declareFunction(new PredefinedFunction(ARCSCS, 7, 1));
        context.declareFunction(new PredefinedFunction(ARCCSCH, 7, 1));
        context.declareFunction(new PredefinedFunction(ARCSEC, 7, 1));
        context.declareFunction(new PredefinedFunction(ARCSECH, 7, 1));
        context.declareFunction(new PredefinedFunction(ARCTANH, 7, 1));
        context.declareFunction(new PredefinedFunction(COSH, 7, 1));
        context.declareFunction(new PredefinedFunction(COTH, 7, 1));
        context.declareFunction(new PredefinedFunction(CSC, 7, 1));
        context.declareFunction(new PredefinedFunction(CSCH, 7, 1));
        context.declareFunction(new PredefinedFunction(SEC, 7, 1));
        context.declareFunction(new PredefinedFunction(SECH, 7, 1));
        context.declareFunction(new PredefinedFunction(SINH, 7, 1));
        context.declareFunction(new PredefinedFunction(TANH, 7, 1));
        context.declareFunction(new PredefinedFunction(ARCSINH, 7, 1));
        context.declareFunction(new PredefinedFunction(FLOOR, 7, 1));
        context.declareFunction(new PredefinedFunction(CEIL, 7, 1));
        context.declareFunction(new PredefinedFunction(FACTORIAL, 7, 1));
        context.declareFunction(new PredefinedFunction(DELAY, 7, 2));
        context.declareFunction(new PredefinedFunction(RATE_OF, 7, 1));
        context.declareFunction(new PredefinedFunction(REM, 7, 2));
        context.declareFunction(new PredefinedFunction(QUOTIENT, 7, 2));
        context.declareFunction(new PredefinedFunction("NUMERIC_LT", 7, 2));
        context.declareFunction(new PredefinedFunction("NUMERIC_GT", 7, 2));
        context.declareFunction(new PredefinedFunction("NUMERIC_EQ", 7, 2));
        context.declareFunction(new PredefinedFunction("NUMERIC_LEQ", 7, 2));
        context.declareFunction(new PredefinedFunction("NUMERIC_GEQ", 7, 2));
        context.declareFunction(new PredefinedFunction("NUMERIC_NEQ", 7, 2));
        context.declareFunction(new PredefinedFunction("NUMERIC_AND", 7, 2));
        context.declareFunction(new PredefinedFunction("NUMERIC_OR", 7, 2));
        context.declareFunction(new PredefinedFunction("NUMERIC_XOR", 7, 2));
        context.declareFunction(new PredefinedFunction("NUMERIC_NOT", 7, 1));
    }

    @Override
    public boolean canDeclare(String value) {
        return true;
    }
}

