/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import one.util.streamex.StreamEx;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.Function;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.ParserContext;
import ru.biosoft.math.model.SimpleNode;
import ru.biosoft.math.model.VariableResolver;

public class AstFunctionDeclaration
extends SimpleNode
implements ParserContext,
Function {
    private String name;
    ParserContext parent;
    FunctionVariableResolver resolver = new FunctionVariableResolver();
    protected Map<String, Object> variablesMap = new HashMap<String, Object>();

    public AstFunctionDeclaration(int id) {
        super(id);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getPriority() {
        return 7;
    }

    @Override
    public int getNumberOfParameters() {
        HashSet<String> varNames = new HashSet<String>();
        for (int i = 0; i < this.jjtGetNumChildren() && this.jjtGetChild(i) instanceof AstVarNode; ++i) {
            AstVarNode varNode = (AstVarNode)this.jjtGetChild(i);
            if (varNames.contains(varNode.getName()) || this.containsConstant(varNode.getName())) continue;
            varNames.add(varNode.getName());
        }
        return varNames.size();
    }

    public StreamEx<AstVarNode> getParameters() {
        HashMap<String, AstVarNode> result = new HashMap<String, AstVarNode>();
        for (int i = 0; i < this.jjtGetNumChildren() && this.jjtGetChild(i) instanceof AstVarNode; ++i) {
            AstVarNode node = (AstVarNode)this.jjtGetChild(i);
            if (this.containsConstant(node.getName())) continue;
            result.put(node.getName(), node);
        }
        return StreamEx.of(result.values());
    }

    public String toString() {
        return "Function declaration: " + this.name;
    }

    public void init(ParserContext parent) {
        this.parent = parent;
    }

    public VariableResolver getVariableResolver() {
        return this.resolver;
    }

    @Override
    public boolean containsConstant(String name) {
        return this.parent.containsConstant(name);
    }

    @Override
    public Object getConstantValue(String name) {
        return this.parent.getConstantValue(name);
    }

    @Override
    public void declareConstant(String name, Object value) {
        throw new UnsupportedOperationException("Function declaration can not declare constants.");
    }

    @Override
    public void removeConstant(String name) {
        throw new UnsupportedOperationException("Function declaration can not remove constants.");
    }

    @Override
    public boolean containsVariable(String name) {
        return this.variablesMap.containsKey(name);
    }

    @Override
    public Object getVariableValue(String name) {
        return this.variablesMap.get(name);
    }

    @Override
    public void declareVariable(String name, Object value) {
        this.variablesMap.put(name, value);
    }

    public Node getFunctionBody() {
        return this.jjtGetChild(this.jjtGetNumChildren() - 1);
    }

    @Override
    public Function getFunction(String name) {
        return this.parent.getFunction(name);
    }

    @Override
    public void declareFunction(Function function) {
        throw new UnsupportedOperationException("Function declaration can not declare internal functions.");
    }

    @Override
    public AstFunctionDeclaration cloneAST() {
        AstFunctionDeclaration functionDeclaration = new AstFunctionDeclaration(this.id);
        functionDeclaration.variablesMap = this.variablesMap;
        functionDeclaration.name = this.name;
        functionDeclaration.parent = this.parent;
        return functionDeclaration;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AstFunctionDeclaration other = (AstFunctionDeclaration)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.variablesMap == null ? other.variablesMap != null : !this.variablesMap.equals(other.variablesMap));
    }

    @Override
    public boolean canDeclare(String value) {
        return true;
    }

    public class FunctionVariableResolver
    implements VariableResolver {
        protected int varNameMode;

        @Override
        public String getVariableName(String variableTitle) {
            if (AstFunctionDeclaration.this.containsVariable(variableTitle)) {
                return variableTitle;
            }
            throw new IllegalArgumentException("Undefined variable " + variableTitle);
        }

        @Override
        public String resolveVariable(String variableName) {
            if (AstFunctionDeclaration.this.containsVariable(variableName)) {
                return variableName;
            }
            throw new IllegalArgumentException("Undefined variable " + variableName);
        }
    }
}

