/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math.model;

import java.util.ArrayList;
import java.util.List;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.DefaultParserContext;
import ru.biosoft.math.model.Function;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.Parser;
import ru.biosoft.math.model.ParserContext;
import ru.biosoft.math.model.UndeclaredFunction;
import ru.biosoft.math.model.VariableResolver;

public abstract class AbstractParser
implements Parser {
    protected ParserContext context = new DefaultParserContext();
    protected boolean declareUndefinedVariables = true;
    protected VariableResolver variableResolver;
    protected int status;
    protected ArrayList<String> messages = new ArrayList();
    protected AstStart astStart;

    @Override
    public ParserContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(ParserContext context) {
        this.context = context;
    }

    @Override
    public boolean isDeclareUndefinedVariables() {
        return this.declareUndefinedVariables;
    }

    @Override
    public void setDeclareUndefinedVariables(boolean declareUndefinedVariables) {
        this.declareUndefinedVariables = declareUndefinedVariables;
    }

    public VariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(VariableResolver variableResolver) {
        this.variableResolver = variableResolver;
    }

    public void warning(String warningStr) {
        this.messages.add("Warning: " + warningStr + ".");
        this.status |= 1;
    }

    public void error(String errorStr) {
        this.messages.add("Error: " + errorStr + ".");
        this.status |= 2;
    }

    public void fatalError(String errorStr) {
        this.messages.add("Syntax error: " + errorStr + ".");
        this.status |= 4;
    }

    @Override
    public List<String> getMessages() {
        return this.messages;
    }

    @Override
    public AstStart getStartNode() {
        return this.astStart;
    }

    protected void reinit() {
        this.status = 0;
        this.messages.clear();
        this.astStart = null;
    }

    protected void setOperator(Node node, String name) {
        Function operator = this.context.getFunction(name.trim());
        if (operator == null) {
            this.error("Unknown operator '" + name + "'");
            operator = new UndeclaredFunction(name, -1);
        }
        AstFunNode funNode = (AstFunNode)node;
        funNode.setFunction(operator);
    }

    protected String processVariable(String name) {
        String varName = name;
        String result = name;
        if (this.variableResolver != null) {
            try {
                varName = this.variableResolver.getVariableName(varName);
                result = this.variableResolver.resolveVariable(varName);
            }
            catch (Throwable t) {
                this.error(t.getMessage());
                return name;
            }
        }
        if (varName == null || result == null) {
            varName = name;
            if (this.context.containsConstant(varName)) {
                return varName + "_CONFLICTS_WITH_CONSTANT_";
            }
            if (this.context.canDeclare(varName)) {
                if (this.isDeclareUndefinedVariables()) {
                    this.context.declareVariable(varName, 0.0);
                } else {
                    this.warning("Variable " + varName + " will be added to context");
                }
                return varName;
            }
            this.error("Undefined variable " + varName);
            return null;
        }
        return result;
    }

    protected void processConstant(Node node, String constName) {
        AstConstant constant = (AstConstant)node;
        constant.setName(constName);
        if (this.context.containsConstant(constName)) {
            constant.setValue(this.context.getConstantValue(constName));
        } else if (this.isDeclareUndefinedVariables()) {
            this.context.declareConstant(constName, 0.0);
        } else {
            this.error("undefined constant '" + constName);
            constant.setValue(new Double(0.0));
        }
    }
}

