/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math;

import java.util.ArrayList;
import java.util.Map;
import ru.biosoft.access.script.ScriptEnvironment;
import ru.biosoft.access.script.ScriptJobControl;
import ru.biosoft.jobcontrol.JobControlException;
import ru.biosoft.math.model.Utils;

public class MathScriptJobControl
extends ScriptJobControl {
    private final String expression;
    private final Map<String, Object> scope;
    private final Map<String, Object> outVars;
    private final ScriptEnvironment env;
    private Object result;

    public MathScriptJobControl(String expression, Map<String, Object> scope, Map<String, Object> outVars, ScriptEnvironment env) {
        this.expression = expression;
        this.scope = scope;
        this.outVars = outVars;
        this.env = env;
    }

    public String getResult() {
        return String.valueOf(this.result);
    }

    protected void doRun() throws JobControlException {
        try {
            this.result = Utils.evaluateExpression(this.expression, this.scope);
            this.env.print(this.getResult());
        }
        catch (Utils.ParseException | Utils.UnresolvedVariablesException e) {
            throw new JobControlException(5, e.getMessage());
        }
        for (String var : new ArrayList<String>(this.outVars.keySet())) {
            this.outVars.put(var, this.result);
        }
    }
}

