/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math;

import java.util.Random;

public class MathRoutines {
    public static double normal(double a, double b) {
        return a + new Random().nextGaussian() * b;
    }

    public static double logNormal(double mean, double stddev) {
        Random randGen = new Random();
        double varx = Math.pow(stddev, 2.0);
        double ess = Math.log(1.0 + varx / Math.pow(mean, 2.0));
        double mu = Math.log(mean) - 0.5 * Math.pow(ess, 2.0);
        return Math.exp(mu + ess * randGen.nextGaussian());
    }

    public static double binomial(double n, double prob) {
        int x = 0;
        int i = 0;
        while ((double)i < n) {
            if (Math.random() < prob) {
                ++x;
            }
            ++i;
        }
        return x;
    }

    public static double uniform(double a, double b) {
        return a + Math.random() * (b - a);
    }

    public static double factorial(int n) {
        double result = 1.0;
        for (int i = 1; i <= n; ++i) {
            result *= (double)i;
        }
        return result;
    }

    public static double factorial(double n) {
        return MathRoutines.factorial((int)n);
    }

    public static double sh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }

    public static double ch(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public static double ctgh(double x) {
        double sh = MathRoutines.sh(x);
        if (0.0 == sh) {
            return Double.MAX_VALUE;
        }
        return MathRoutines.ch(x) / sh;
    }

    public static double ash(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static double ach(double x) {
        double y = x * x - 1.0;
        if (y < 0.0) {
            return 0.0;
        }
        if ((y = x + Math.sqrt(y)) < 0.0) {
            return 0.0;
        }
        return Math.log(y);
    }

    public static double atgh(double x) {
        if (x >= 1.0 || x <= -1.0) {
            return 0.0;
        }
        return Math.log((1.0 + x) / (1.0 - x)) / 2.0;
    }

    public static double actgh(double x) {
        if (x <= 1.0 && x >= -1.0) {
            return 0.0;
        }
        return Math.log((x + 1.0) / (x - 1.0)) / 2.0;
    }

    public static double sec(double x) {
        double c = Math.cos(x);
        if (c == 0.0) {
            return Double.MAX_VALUE;
        }
        return 1.0 / c;
    }

    public static double csec(double x) {
        double s = Math.sin(x);
        if (s == 0.0) {
            return Double.MAX_VALUE;
        }
        return 1.0 / s;
    }

    public static double csech(double x) {
        double s = MathRoutines.sh(x);
        if (s == 0.0) {
            return Double.MAX_VALUE;
        }
        return 1.0 / s;
    }

    public static double sech(double x) {
        return 1.0 / MathRoutines.ch(x);
    }

    public static double asec(double x) {
        double y = 0.0;
        y = x == 0.0 ? Double.MAX_VALUE : 1.0 / x;
        return Math.acos(y);
    }

    public static double acsec(double x) {
        double y = 0.0;
        y = x == 0.0 ? Double.MAX_VALUE : 1.0 / x;
        return Math.asin(y);
    }

    public static double acsech(double x) {
        double y = 0.0;
        y = x == 0.0 ? Double.MAX_VALUE : 1.0 / x;
        return MathRoutines.ash(y);
    }

    public static double asech(double x) {
        double y = 0.0;
        y = x == 0.0 ? Double.MAX_VALUE : 1.0 / x;
        return MathRoutines.ach(y);
    }

    public static double actg(Double x) {
        int comparedToZero = x.compareTo(0.0);
        if (comparedToZero >= 0) {
            return 1.5707963267948966 - Math.atan(x);
        }
        return -1.5707963267948966 - Math.atan(x);
    }

    public static double pow(double x, int exp) {
        if (exp == 1) {
            return x;
        }
        if (exp == 2) {
            return x * x;
        }
        if ((exp & 1) == 0) {
            double sub = MathRoutines.pow(x, exp >> 1);
            return sub * sub;
        }
        return x * MathRoutines.pow(x, exp - 1);
    }
}

