/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math;

import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.application.PanelInfo;
import com.developmentontheedge.application.PanelManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.math.Expression;
import ru.biosoft.math.model.AbstractParser;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.VariableResolver;
import ru.biosoft.math.parser.Parser;
import ru.biosoft.math.view.FormulaViewBuilder;
import ru.biosoft.math.xml.MathMLFormatter;
import ru.biosoft.math.xml.MathMLParser;

public class ExpressionEditorPane
extends PanelManager {
    public static final String TEXT_PANEL_NAME = "Text";
    public static final String MATHML_PANEL_NAME = "MathML";
    protected FormulaViewBuilder viewBuilder = new FormulaViewBuilder();
    protected ViewPane viewPane = new ViewPane();
    protected JTextPane textPane = new JTextPane();
    protected JTextPane mathMLPane = new JTextPane();
    protected JTextPane logPane = new JTextPane();
    protected JButton validateButton = new JButton("Validate");
    protected JButton dumpButton = new JButton("Dump");
    protected JButton okButton;
    protected AbstractParser linearParser = new Parser();
    protected AbstractParser mathMLParser = new MathMLParser();
    public static final LinearFormatter linearFormatter = new LinearFormatter();
    public static final MathMLFormatter mathMLFormatter = new MathMLFormatter();
    protected Expression expression;
    protected int status;
    protected JTextPane source;

    public ExpressionEditorPane(JButton okButton, String[] panelNames, boolean dumpAvailable) {
        this.okButton = okButton;
        this.addPanel(new PanelInfo("view", (JComponent)this.viewPane, true, null), null, 0);
        JTabbedPane tabs = new JTabbedPane();
        for (String panelName : panelNames) {
            if (panelName.equals(TEXT_PANEL_NAME)) {
                tabs.add(TEXT_PANEL_NAME, new JScrollPane(this.textPane));
                continue;
            }
            if (!panelName.equals(MATHML_PANEL_NAME)) continue;
            tabs.add(MATHML_PANEL_NAME, new JScrollPane(this.mathMLPane));
        }
        JPanel buttonPane = new JPanel(new FlowLayout());
        buttonPane.add(this.validateButton);
        if (dumpAvailable) {
            buttonPane.add(this.dumpButton);
        }
        JPanel editorPane = new JPanel(new BorderLayout());
        editorPane.add((Component)tabs, "Center");
        editorPane.add((Component)buttonPane, "South");
        this.addPanel(new PanelInfo("editors", (JComponent)editorPane, true, null), "view", 4, 120);
        JScrollPane log = new JScrollPane(this.logPane);
        log.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), "Messages:"));
        this.addPanel(new PanelInfo("log", (JComponent)log, true, null), "editors", 4, 150);
        this.mathMLPane.setFont(new Font("Monospaced", 0, 14));
        this.logPane.setFont(new Font("Monospaced", 0, 14));
        this.logPane.setEditable(false);
        this.setPreferredSize(new Dimension(400, 400));
        tabs.addChangeListener(e -> this.updateTab());
        this.textPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExpressionEditorPane.this.processDocumentEvent(ExpressionEditorPane.this.textPane);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExpressionEditorPane.this.processDocumentEvent(ExpressionEditorPane.this.textPane);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExpressionEditorPane.this.processDocumentEvent(ExpressionEditorPane.this.textPane);
            }
        });
        this.mathMLPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExpressionEditorPane.this.processDocumentEvent(ExpressionEditorPane.this.mathMLPane);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExpressionEditorPane.this.processDocumentEvent(ExpressionEditorPane.this.mathMLPane);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExpressionEditorPane.this.processDocumentEvent(ExpressionEditorPane.this.mathMLPane);
            }
        });
        this.validateButton.addActionListener(e -> this.validateExpression());
        this.dumpButton.addActionListener(e -> this.dump());
    }

    public void setVariableResolver(VariableResolver variableResolver) {
        this.linearParser.setVariableResolver(variableResolver);
        this.mathMLParser.setVariableResolver(variableResolver);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
        this.textPane.setText(expression.getText());
        this.validateButton.setEnabled(false);
        if (this.okButton != null) {
            this.okButton.setEnabled(false);
        }
    }

    public void addVariableToFormula(String varName) {
        int pos = this.textPane.getCaretPosition();
        if (pos >= 0) {
            String text = this.textPane.getText();
            this.textPane.setText(text.substring(0, pos) + varName + text.substring(pos));
            this.processDocumentEvent(this.textPane);
        }
    }

    protected void processDocumentEvent(JTextPane source) {
        if (this.expression == null) {
            return;
        }
        this.source = source;
        AbstractParser parser = source == this.textPane ? this.linearParser : this.mathMLParser;
        String text = source == this.textPane ? this.textPane.getText() : this.mathMLPane.getText();
        parser.setDeclareUndefinedVariables(false);
        parser.setContext(this.expression.getParserContext());
        this.status = parser.parse(text);
        if ((this.status & 4) == 0) {
            this.expression.setText(text);
            this.expression.setAstStart(parser.getStartNode());
            this.updateView();
        }
        this.validateButton.setEnabled(true);
        this.okButton.setEnabled(false);
    }

    protected void updateView() {
        if (this.isVisible()) {
            CompositeView expressionView = this.viewBuilder.createView(this.expression.getAstStart(), ApplicationUtils.getGraphics());
            int x = 0;
            if ((double)this.viewPane.getWidth() > expressionView.getBounds().getWidth()) {
                x = (int)((double)this.viewPane.getWidth() - expressionView.getBounds().getWidth()) / 2;
            }
            int y = 0;
            if ((double)this.viewPane.getHeight() > expressionView.getBounds().getHeight()) {
                y = (int)((double)this.viewPane.getHeight() - expressionView.getBounds().getHeight()) / 2;
            }
            this.viewPane.setView(expressionView, new Point(x, y));
        }
    }

    protected void updateTab() {
        if (this.source == this.textPane) {
            if ((this.status & 4) != 0) {
                this.logPane.setForeground(Color.red.darker());
                this.logPane.setText("Can not generate MathML, reason: text expression is incorrect.\nPress 'Validate' button to display parsing error messages\nor you can edit current MathML expression.");
            } else {
                String math = mathMLFormatter.format(this.expression.getAstStart())[1];
                this.mathMLPane.setText(math);
                this.source = this.mathMLPane;
            }
        } else if ((this.status & 4) != 0) {
            this.logPane.setForeground(Color.red.darker());
            this.logPane.setText("Can not generate text expression, reason: MathML expression is incorrect.\nPress 'Validate' button to display parsing error messages\nor you can edit current text expression.");
        } else {
            String text = linearFormatter.format(this.expression.getAstStart())[1];
            this.textPane.setText(text);
            this.source = this.textPane;
        }
    }

    protected void validateExpression() {
        StringBuffer msg = new StringBuffer();
        List<String> errorList = null;
        errorList = this.source == this.textPane ? this.linearParser.getMessages() : this.mathMLParser.getMessages();
        if (this.status == 0) {
            this.logPane.setForeground(Color.black);
            msg.append("Expression parsed successfully.");
        } else if (errorList != null) {
            if (this.status > 1) {
                this.logPane.setForeground(Color.red.darker());
            } else {
                this.logPane.setForeground(Color.black);
            }
            msg.append(String.join((CharSequence)"\n", errorList));
        }
        this.logPane.setText(msg.toString());
        if (this.status < 2 && this.okButton != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected void dump() {
        StringBuffer msg = new StringBuffer();
        if (this.expression.getAstStart() == null || (this.status & 4) != 0) {
            msg.append("Dump is unavailable.");
        } else {
            msg.append("AST tree dump: \n");
            this.expression.getAstStart().dump(msg, "  ");
        }
        this.logPane.setForeground(Color.blue.darker());
        this.logPane.setText(msg.toString());
    }
}

