/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.math;

import com.developmentontheedge.beans.Option;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.DefaultParserContext;
import ru.biosoft.math.model.ParserContext;
import ru.biosoft.math.parser.Parser;

public class Expression
extends Option {
    protected static final Logger log = Logger.getLogger(Expression.class.getName());
    protected String text;
    protected AstStart astStart;
    protected ParserContext context;
    private Parser linearParser;

    public Expression(Option parent, String text) {
        super(parent);
        if (text.startsWith("<math")) {
            this.parseExpression(text);
        } else {
            this.text = text;
        }
    }

    public Expression(Option parent, Node mathElement) {
        super(parent);
        this.parseExpression(mathElement);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        String oldValue = this.text;
        this.parseExpression(text);
        this.firePropertyChange("text", oldValue, text);
    }

    public AstStart getAstStart() {
        return this.astStart;
    }

    public void setAstStart(AstStart astStart) {
        this.astStart = astStart;
    }

    public ParserContext getParserContext() {
        if (this.context == null) {
            this.context = new DefaultParserContext();
        }
        return this.context;
    }

    public void setParserContext(ParserContext context) {
        this.context = context;
    }

    public void parseExpression(String text) {
        this.text = text;
        try {
            if (!text.startsWith("<math")) {
                StringReader expr = new StringReader(text);
                if (this.linearParser == null) {
                    this.linearParser = new Parser(expr);
                } else {
                    this.linearParser.ReInit(expr);
                }
                this.astStart = this.linearParser.Start();
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "There were errors during expression processing, expression='" + text + "', error: " + t, t);
        }
    }

    public void parseExpression(Node math) {
    }
}

