/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.font;

import java.awt.Color;
import java.awt.Font;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ColorFont {
    private Color color;
    protected Font font = null;
    JSONObject json = null;

    public ColorFont(String name, int style, int size, Color c) {
        this.font = new Font(name, style, size);
        this.color = c;
    }

    public ColorFont(String name, int style, int size) {
        this(name, style, size, Color.black);
    }

    public ColorFont(Font font, Color c) {
        this(font.getName(), font.getStyle(), font.getSize(), c);
    }

    public ColorFont() {
        this("Courier", 0, 12, Color.black);
    }

    public ColorFont(String jsonStr) throws JSONException {
        this(new JSONObject(jsonStr));
    }

    public ColorFont(JSONObject json) {
        this.initFromJSON(json);
    }

    public void setColor(Color color) {
        this.color = color;
        this.json = null;
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.json = null;
    }

    public String toString() {
        try {
            return this.toJSON().toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public JSONObject toJSON() throws JSONException {
        if (this.json == null) {
            this.json = new JSONObject();
            JSONArray JSONfont = new JSONArray();
            JSONfont.put((Object)this.font.getName());
            JSONfont.put(this.font.getStyle());
            JSONfont.put(this.font.getSize());
            this.json.put("font", (Object)JSONfont);
            JSONArray JSONcolor = new JSONArray();
            JSONcolor.put(this.color.getRed());
            JSONcolor.put(this.color.getGreen());
            JSONcolor.put(this.color.getBlue());
            JSONcolor.put(this.color.getAlpha());
            this.json.put("color", (Object)JSONcolor);
        }
        return this.json;
    }

    private void initFromJSON(JSONObject from) {
        try {
            JSONArray font = (JSONArray)from.get("font");
            JSONArray color = (JSONArray)from.get("color");
            String fontName = font.getString(0);
            int fontStyle = font.getInt(1);
            int fontSize = font.getInt(2);
            int red = color.getInt(0);
            int green = color.getInt(1);
            int blue = color.getInt(2);
            int alpha = color.getInt(3);
            this.color = new Color(red, green, blue, alpha);
            this.font = new Font(fontName, fontStyle, fontSize);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorFont other = (ColorFont)obj;
        if (!this.color.equals(other.color)) {
            return false;
        }
        return this.font.equals(other.font);
    }
}

