/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.editor;

import com.developmentontheedge.beans.ActionsProvider;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.editor.BoxSelector;
import ru.biosoft.graphics.editor.GridOptions;
import ru.biosoft.graphics.editor.SelectionManager;
import ru.biosoft.graphics.editor.ViewPaneAdapter;
import ru.biosoft.graphics.editor.ViewPaneEvent;
import ru.biosoft.graphics.editor.ViewPaneLayer;
import ru.biosoft.graphics.editor.ViewPaneListener;

public class ViewPane
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected MPanel mPanel;
    protected AffineTransform at = AffineTransform.getScaleInstance(1.0, 1.0);
    protected Point offset = new Point(0, 0);
    private static final int SCROLL_DELTA = 15;
    private JScrollBar barHor = null;
    private JScrollBar barVert = null;
    protected JScrollPane scrollPane = null;
    private boolean allignToX = false;
    private boolean allignToY = false;
    private final List<ViewPaneLayer> layers = new ArrayList<ViewPaneLayer>();
    protected CompositeView cView;
    protected GridOptions gridOptions;
    protected SelectionManager selectionManager;
    protected ActionsProvider popupActionsProvider;
    protected Vector<ViewPaneListener> viewPaneListeners = new Vector();
    private Object findModel;

    public ViewPane() {
        this.mPanel = new MPanel(true);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.mPanel);
        this.scrollPane.setDoubleBuffered(true);
        this.barHor = this.scrollPane.getHorizontalScrollBar();
        this.barVert = this.scrollPane.getVerticalScrollBar();
        this.barHor.setUnitIncrement(15);
        this.barVert.setUnitIncrement(15);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.mPanel.addMouseListener(this);
        this.mPanel.addMouseMotionListener(this);
        this.addViewPaneListener(new PopupListener());
        SelectionManager selectionManager = new SelectionManager(this);
        selectionManager.setViewSelector(new BoxSelector());
        this.setSelectionManager(selectionManager);
        this.cView = new CompositeView();
    }

    public CompositeView getView() {
        return this.cView;
    }

    public void setView(CompositeView value) {
        this.setView(value, null);
    }

    public void setView(CompositeView value, Point offset) {
        this.cView = value;
        if (value != null) {
            Rectangle rect = (Rectangle)this.cView.getBounds().clone();
            if (offset != null) {
                rect.x -= offset.x;
                rect.y -= offset.y;
            }
            this.offset = rect.getLocation();
        }
        if (this.selectionManager != null) {
            Object[] models = this.selectionManager.getSelectedModels();
            this.selectionManager.clearSelection();
            this.selectionManager.selectModels(models, false);
        }
        this.updateScrollBars();
        this.repaint();
    }

    public GridOptions getGridOptions() {
        return this.gridOptions;
    }

    public void setGridOptions(GridOptions gridOptions) {
        this.gridOptions = gridOptions;
    }

    public void addLayer(ViewPaneLayer layer) {
        this.layers.add(layer);
    }

    public void removeLayer(ViewPaneLayer layer) {
        this.layers.remove(layer);
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void setSelectionManager(SelectionManager selectionManager) {
        this.removeViewPaneListener(this.selectionManager);
        this.selectionManager = selectionManager;
        this.addViewPaneListener(this.selectionManager);
        this.repaint();
    }

    public ActionsProvider getPopupActionsProvider() {
        return this.popupActionsProvider;
    }

    public void setPopupActionsProvider(ActionsProvider popupActionsProvider) {
        this.popupActionsProvider = popupActionsProvider;
    }

    public void addViewPaneListener(ViewPaneListener viewPaneListener) {
        this.viewPaneListeners.addElement(viewPaneListener);
    }

    public void removeViewPaneListener(ViewPaneListener viewPaneListener) {
        this.viewPaneListeners.removeElement(viewPaneListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.mPanel.addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.mPanel.removeMouseListener(mouseListener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseListener) {
        this.mPanel.addMouseMotionListener(mouseListener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseListener) {
        this.mPanel.removeMouseMotionListener(mouseListener);
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener l) {
        this.mPanel.addMouseWheelListener(l);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener l) {
        this.mPanel.removeMouseWheelListener(l);
    }

    public void setSizeAllign(boolean x, boolean y) {
        this.allignToX = x;
        this.allignToY = y;
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.mPanel != null) {
            this.mPanel.repaint();
        }
    }

    public void scale(double sx, double sy) {
        this.setToScale(sx * this.at.getScaleX(), sy * this.at.getScaleY());
    }

    public void setToScale(double sx, double sy) {
        this.at.setToScale(sx, sy);
        this.updateScrollBars();
        this.mPanel.repaint();
        int ADDER = 5;
        if (this.allignToX) {
            if (this.barVert.isVisible()) {
                sx = sx * (double)this.getBounds().width / (double)(this.getBounds().width + this.barVert.getBounds().width + 5);
                sy = sy * (double)this.getBounds().width / (double)(this.getBounds().width + this.barVert.getBounds().width + 5);
            } else {
                sx = sx * (double)this.getBounds().width / (double)(this.getBounds().width + 5);
                sy = sy * (double)this.getBounds().width / (double)(this.getBounds().width + 5);
            }
            if (this.allignToY) {
                this.at.setToScale(sx, sy);
            } else {
                this.at.setToScale(sx, sx);
            }
            this.updateScrollBars();
            this.barHor.setVisible(false);
        }
        if (this.allignToY) {
            if (this.barHor.isVisible()) {
                sx = sx * (double)this.getBounds().height / (double)(this.getBounds().height + this.barHor.getBounds().height + 5);
                sy = sy * (double)this.getBounds().height / (double)(this.getBounds().height + this.barHor.getBounds().height + 5);
            } else {
                sx = sx * (double)this.getBounds().height / (double)(this.getBounds().height + 5);
                sy = sy * (double)this.getBounds().height / (double)(this.getBounds().height + 5);
            }
            if (this.allignToX) {
                this.at.setToScale(sx, sy);
            } else {
                this.at.setToScale(sy, sy);
            }
            this.updateScrollBars();
            this.barVert.setVisible(false);
        }
        this.mPanel.repaint();
    }

    public double getScaleX() {
        return this.at.getScaleX();
    }

    public double getScaleY() {
        return this.at.getScaleY();
    }

    public void updateScrollBars() {
        if (this.cView == null) {
            return;
        }
        Rectangle r = this.cView.getBounds();
        Dimension dm = new Dimension((int)((double)(r.width + 4) * this.at.getScaleX()), (int)((double)(r.height + 4) * this.at.getScaleY()));
        this.mPanel.setPreferredSize(dm);
        this.mPanel.setMinimumSize(dm);
        this.mPanel.setMaximumSize(dm);
        this.mPanel.setSize(dm);
        this.barHor.revalidate();
        this.barVert.revalidate();
    }

    public void setScrollPolicy(int horizontal, int vertical) {
        this.scrollPane.setHorizontalScrollBarPolicy(horizontal);
        this.scrollPane.setVerticalScrollBarPolicy(vertical);
    }

    private Collection<View> traceFor(View v) {
        ArrayList<View> views = new ArrayList<View>();
        if (v.isActive() && v.getModel() == this.findModel) {
            views.add(v);
        } else if (v instanceof CompositeView) {
            for (View vv : (CompositeView)v) {
                Collection<View> col = this.traceFor(vv);
                views.addAll(col);
            }
        }
        return views;
    }

    public View[] getView(Object model) {
        this.findModel = model;
        ArrayList<View> vec = new ArrayList<View>(this.traceFor(this.cView));
        return vec.toArray(new View[0]);
    }

    public Point clientToView(Point pt) {
        Point result = (Point)pt.clone();
        result.x = (int)((double)result.x / this.at.getScaleX());
        result.y = (int)((double)result.y / this.at.getScaleY());
        result.x += this.offset.x;
        result.y += this.offset.y;
        return result;
    }

    protected ViewPaneEvent prepareEvent(MouseEvent e) {
        Point pt = this.clientToView(e.getPoint());
        return new ViewPaneEvent(this, this.cView.getDeepestActive(pt), e, pt.x, pt.y);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        ViewPaneEvent viewPaneEvent = this.prepareEvent(e);
        for (ViewPaneListener vpl : this.viewPaneListeners) {
            vpl.mouseClicked(viewPaneEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ViewPaneEvent viewPaneEvent = this.prepareEvent(e);
        for (ViewPaneListener vpl : this.getListeners()) {
            vpl.mousePressed(viewPaneEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        ViewPaneEvent viewPaneEvent = this.prepareEvent(e);
        for (ViewPaneListener vpl : this.getListeners()) {
            vpl.mouseReleased(viewPaneEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        ViewPaneEvent viewPaneEvent = this.prepareEvent(e);
        for (ViewPaneListener vpl : this.getListeners()) {
            vpl.mouseEntered(viewPaneEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        ViewPaneEvent viewPaneEvent = this.prepareEvent(e);
        for (ViewPaneListener vpl : this.getListeners()) {
            vpl.mouseExited(viewPaneEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Rectangle tmpRect = new Rectangle();
        this.scrollPane.getBounds(tmpRect);
        int val = this.barHor.getValue();
        if (e.getPoint().x < val) {
            val -= 15;
        }
        if (e.getPoint().x > val + tmpRect.width) {
            val += 15;
        }
        this.barHor.setValue(val);
        val = this.barVert.getValue();
        if (e.getPoint().y < val) {
            val -= 15;
        }
        if (e.getPoint().y > val + tmpRect.height) {
            val += 15;
        }
        this.barVert.setValue(val);
        ViewPaneEvent viewPaneEvent = this.prepareEvent(e);
        for (ViewPaneListener vpl : this.getListeners()) {
            vpl.mouseDragged(viewPaneEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        ViewPaneEvent viewPaneEvent = this.prepareEvent(e);
        for (ViewPaneListener vpl : this.getListeners()) {
            vpl.mouseMoved(viewPaneEvent);
        }
    }

    protected ViewPaneListener[] getListeners() {
        return this.viewPaneListeners.toArray(new ViewPaneListener[this.viewPaneListeners.size()]);
    }

    public JComponent getContent() {
        return new MPanel(false);
    }

    public void resetScrollBars() {
        this.barHor.setValue(0);
        this.barVert.setValue(0);
    }

    @Override
    public void setBackground(Color color) {
        if (this.mPanel != null) {
            this.mPanel.setBackground(color);
        }
    }

    public Rectangle getViewportBounds() {
        return this.scrollPane.getViewportBorderBounds();
    }

    protected class MPanel
    extends JPanel {
        protected boolean useGrid = false;

        public MPanel(boolean useGrid) {
            this.useGrid = useGrid;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (ViewPane.this.cView == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.transform(ViewPane.this.at);
            g2.translate(-ViewPane.this.offset.x, -ViewPane.this.offset.y);
            if (this.useGrid && ViewPane.this.gridOptions != null) {
                if (ViewPane.this.gridOptions.getGridStyle() == GridOptions.GridStyle.BACKGROUND_GRID) {
                    this.paintGrid(g2);
                    ViewPane.this.cView.paint((Graphics2D)g);
                } else {
                    ViewPane.this.cView.paint((Graphics2D)g);
                    this.paintGrid(g2);
                }
            } else {
                ViewPane.this.cView.paint((Graphics2D)g);
            }
            if (ViewPane.this.selectionManager != null) {
                ViewPane.this.selectionManager.paintLayer(g2);
            }
            for (ViewPaneLayer layer : ViewPane.this.layers) {
                layer.paintLayer(g2);
            }
            g2.translate(ViewPane.this.offset.x, ViewPane.this.offset.y);
        }

        protected void paintGrid(Graphics2D g2) {
            int i;
            if (!ViewPane.this.gridOptions.isShowGrid()) {
                return;
            }
            int cellSize = this.adoptStep(ViewPane.this.gridOptions.getCellSize(), 5);
            if (cellSize < 0) {
                return;
            }
            g2.setStroke(new BasicStroke(1.0f));
            if (ViewPane.this.gridOptions.getGridStyle() == GridOptions.GridStyle.POINTS) {
                g2.setColor(Color.gray);
            } else {
                g2.setColor(Color.lightGray);
            }
            Rectangle bounds = g2.getClipBounds();
            int startX = (int)(Math.floor((double)bounds.x / (double)cellSize) * (double)cellSize);
            int startY = (int)(Math.floor((double)bounds.y / (double)cellSize) * (double)cellSize);
            for (i = 0; i < bounds.width / cellSize + 2; ++i) {
                int x = startX + i * cellSize;
                this.paintGridLine(g2, x, startY, x, bounds.y + bounds.height);
            }
            for (i = 0; i < bounds.height / cellSize + 2; ++i) {
                int y = startY + i * cellSize;
                this.paintGridLine(g2, startX, y, bounds.x + bounds.width, y);
            }
        }

        protected int adoptStep(int step, int minStep) {
            if (ViewPane.this.getScaleX() > 1.0) {
                return step;
            }
            if ((int)(ViewPane.this.getScaleX() * (double)step) >= minStep) {
                return step;
            }
            return -1;
        }

        protected void paintGridLine(Graphics2D g2, int x1, int y1, int x2, int y2) {
            block5: {
                int stepSize;
                block6: {
                    block4: {
                        if (ViewPane.this.gridOptions.getGridStyle() == GridOptions.GridStyle.POINTS) break block4;
                        g2.drawLine(x1, y1, x2, y2);
                        break block5;
                    }
                    if (ViewPane.this.gridOptions.getStepSize() <= 0) {
                        return;
                    }
                    stepSize = this.adoptStep(ViewPane.this.gridOptions.getStepSize(), 5);
                    if (stepSize < 1 && (stepSize = this.adoptStep(ViewPane.this.gridOptions.getCellSize(), 5)) < 1) {
                        return;
                    }
                    if (x1 != x2) break block6;
                    for (int point = y1; point <= y2; point += stepSize) {
                        g2.drawLine(x1, point, x1, point);
                    }
                    break block5;
                }
                if (y1 != y2) break block5;
                for (int point = x1; point <= x2; point += stepSize) {
                    g2.drawLine(point, y1, point, y1);
                }
            }
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return ViewPane.this.getToolTipText(event);
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            return ViewPane.this.getToolTipLocation(event);
        }
    }

    protected class PopupListener
    extends ViewPaneAdapter {
        protected JPopupMenu popup = null;

        protected PopupListener() {
        }

        @Override
        public void mouseReleased(ViewPaneEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(ViewPaneEvent e) {
            if (!SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            this.initPopupMenu(e);
            int x = (int)((double)e.getX() * ViewPane.this.at.getScaleX());
            int y = (int)((double)e.getY() * ViewPane.this.at.getScaleY());
            if (ViewPane.this.offset != null) {
                x -= ViewPane.this.offset.x;
                y -= ViewPane.this.offset.y;
            }
            if (this.popup != null) {
                this.popup.show(e.getComponent(), x, y);
            }
        }

        private void initPopupMenu(ViewPaneEvent e) {
            this.popup = null;
            if (ViewPane.this.popupActionsProvider == null || e.getViewSource() == null || e.getViewSource().getModel() == null) {
                return;
            }
            Action[] actions = ViewPane.this.popupActionsProvider.getActions((Object)e);
            if (actions == null || actions.length == 0) {
                return;
            }
            this.popup = new JPopupMenu();
            for (Action a : actions) {
                if (a == null) {
                    this.popup.addSeparator();
                    continue;
                }
                JMenuItem menuItem = this.popup.add(a);
                menuItem.setActionCommand((String)a.getValue("ActionCommandKey"));
                Dimension dim = menuItem.getPreferredSize();
                dim.height = 23;
                menuItem.setPreferredSize(dim);
            }
        }
    }
}

