/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.editor;

import com.developmentontheedge.beans.undo.Transactable;
import com.developmentontheedge.beans.undo.TransactionEvent;
import com.developmentontheedge.beans.undo.TransactionListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import ru.biosoft.graphics.ArrowView;
import ru.biosoft.graphics.BoxView;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.PathUtils;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.SimplePath;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.editor.InsertAction;
import ru.biosoft.graphics.editor.RectangleSelectionManager;
import ru.biosoft.graphics.editor.ViewEditorHelper;
import ru.biosoft.graphics.editor.ViewPane;

public class ViewEditorPane
extends ViewPane
implements Transactable,
TransactionListener,
KeyListener {
    public static final int TOOLBAR_BUTTON_SIZE = 25;
    public static final int DEFAULT_MOVE_STEP = 5;
    ViewEditorHelper helper;
    ActionListener insertActionListener;
    Object insertMode;
    ButtonGroup bg;
    JToggleButton selectbutton;
    JToolBar toolbar;
    private boolean selectionEnabled;
    protected boolean initiated = false;
    protected static final int TL = 1;
    protected static final int TC = 2;
    protected static final int TR = 3;
    protected static final int ML = 4;
    protected static final int MR = 5;
    protected static final int BL = 6;
    protected static final int BC = 7;
    protected static final int BR = 8;
    protected boolean resizing = false;
    protected Rectangle initialRect = null;
    protected Rectangle initialRect2 = null;
    protected int resizingDirection = 0;
    protected boolean moving = false;
    protected int controlPoint = -1;
    protected Point startPoint = null;
    protected Point prevPoint = null;
    protected Point prevCorrectedPoint = null;
    protected CompositeView selection = null;
    protected SelectionUndo selectionUndo = null;

    public ViewEditorPane(ViewEditorHelper helper) {
        this.helper = helper;
        helper.register(this);
        this.initUIComponents();
    }

    public ViewEditorHelper getHelper() {
        return this.helper;
    }

    public JPanel getPanel() {
        return this.mPanel;
    }

    protected void initUIComponents() {
        this.bg = new ButtonGroup();
        this.toolbar = new JToolBar(0);
        this.fillToolbar(this.helper);
        this.toolbar.setRollover(true);
        this.add((Component)this.toolbar, "North");
        this.addKeyListener(this);
        this.selectionEnabled = true;
        this.setSelectionManager(new RectangleSelectionManager(this, this.helper));
    }

    private ActionListener getInsertActionListener() {
        if (this.insertActionListener == null) {
            this.insertActionListener = e -> {
                Action insterAction = (Action)e.getSource();
                Object classToInsert = insterAction.getValue("type");
                this.setInsertMode(classToInsert);
            };
        }
        return this.insertActionListener;
    }

    public void fillToolbar(ViewEditorHelper helper) {
        Action[] insterActions;
        this.toolbar.removeAll();
        for (Action action : insterActions = helper.getActions()) {
            String name;
            if (!(action instanceof InsertAction)) continue;
            ((InsertAction)action).addActionListener(this.getInsertActionListener());
            JToggleButton tb = new JToggleButton(action);
            tb.setAlignmentY(0.5f);
            Dimension btnSize = new Dimension(25, 25);
            tb.setSize(btnSize);
            tb.setPreferredSize(btnSize);
            tb.setMinimumSize(btnSize);
            tb.setMaximumSize(btnSize);
            if (tb.getIcon() != null) {
                tb.setText(null);
            }
            if ("Select".equals(name = (String)action.getValue("Name"))) {
                this.selectbutton = tb;
            }
            this.bg.add(tb);
            this.toolbar.add(tb);
        }
        this.resetInsertMode();
    }

    protected void setInsertMode(Object classToInsert) {
        this.insertMode = classToInsert;
    }

    public void resetInsertMode() {
        this.insertMode = null;
        if (this.selectbutton != null) {
            this.bg.setSelected(this.selectbutton.getModel(), true);
            this.toolbar.repaint();
        }
    }

    public boolean isInsertMode() {
        return this.insertMode != null;
    }

    public boolean getSelectionEnabled() {
        return this.selectionEnabled;
    }

    public void setSelectionEnabled(boolean selectionEnabled) {
        this.selectionEnabled = selectionEnabled;
    }

    public synchronized void move(Dimension offset) {
        this.move(offset, false);
    }

    public synchronized void move(Dimension offset, boolean moveOnlyEdges) {
        this.startTransaction("Move " + this.getSelectionName());
        HashSet<Object> processedObjects = new HashSet<Object>();
        for (int i = 0; i < this.selectionManager.getSelectedViewCount(); ++i) {
            View view = this.selectionManager.getSelectedView(i);
            if (processedObjects.contains(view.getModel())) continue;
            processedObjects.add(view.getModel());
            if (this.controlPoint >= -1 && this.initialRect != null) {
                Point pathOffset = ((ArrowView)view).getPathOffset();
                Rectangle boxRectangle = new Rectangle(this.initialRect.x - pathOffset.x, this.initialRect.y - pathOffset.y, this.initialRect.width, this.initialRect.height);
                BoxView cpView = new BoxView(null, null, boxRectangle);
                cpView.setModel(view.getModel());
                try {
                    this.helper.moveView(cpView, offset);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.initialRect2 == null) continue;
                boxRectangle = new Rectangle(this.initialRect2.x - pathOffset.x, this.initialRect2.y - pathOffset.y, this.initialRect2.width, this.initialRect2.height);
                cpView = new BoxView(null, null, boxRectangle);
                cpView.setModel(view.getModel());
                try {
                    this.helper.moveView(cpView, offset);
                }
                catch (Exception exception) {}
                continue;
            }
            if (moveOnlyEdges) continue;
            try {
                this.helper.moveView(view, offset);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.completeTransaction();
    }

    protected String getSelectionName() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.selectionManager.getSelectedViewCount(); ++i) {
            View view = this.selectionManager.getSelectedView(i);
            if (!(view.getModel() instanceof Double)) continue;
            names.add(ViewEditorPane.getName(view.getModel()));
            if (names.size() >= 3) break;
        }
        String selectionName = String.join((CharSequence)", ", names);
        return selectionName;
    }

    protected static String getName(Object obj) {
        String name = null;
        try {
            name = (String)obj.getClass().getMethod("getName", new Class[0]).invoke(obj, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name == null ? obj.toString() : name;
    }

    public synchronized void changeSize(Dimension offset, Dimension size) {
        this.startTransaction("Change size");
        View view = this.selectionManager.getSelectedView(0);
        try {
            if (offset != null) {
                this.helper.resizeView(view, size, offset);
            } else {
                this.helper.resizeView(view, size);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.completeTransaction();
    }

    public synchronized void add(Object obj, Point point) {
        this.startTransaction("Add " + ViewEditorPane.getName(obj));
        this.helper.add(obj, point);
        this.completeTransaction();
    }

    public synchronized void add(List<?> objects, Point point) {
        this.startTransaction("Add elements");
        for (Object obj : objects) {
            this.helper.add(obj, point);
        }
        this.completeTransaction();
    }

    public synchronized void remove() {
        this.startTransaction("Remove " + this.getSelectionName());
        for (int i = 0; i < this.selectionManager.getSelectedViewCount(); ++i) {
            View view = this.selectionManager.getSelectedView(i);
            this.helper.removeView(view);
        }
        this.completeTransaction();
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode;
        if (this.selectionEnabled && ((keyCode = e.getKeyCode()) == 39 || keyCode == 37 || keyCode == 38 || keyCode == 40) && this.selectionManager.getSelectedViewCount() > 0) {
            int moveStep = 5;
            if (this.gridOptions != null && this.gridOptions.isShowGrid()) {
                moveStep = this.gridOptions.getStepSize();
            }
            if (e.isAltDown()) {
                moveStep = 1;
            }
            Point prevPoint = new Point(0, 0);
            Point newPoint = new Point();
            if (keyCode == 39) {
                newPoint.x = moveStep;
            } else if (keyCode == 37) {
                newPoint.x = -moveStep;
            } else if (keyCode == 38) {
                newPoint.y = -moveStep;
            } else if (keyCode == 40) {
                newPoint.y = moveStep;
            }
            if (!e.isAltDown()) {
                Point delta = this.snapToGrid(prevPoint, prevPoint, newPoint, this.selectionManager.getBounds());
                newPoint.x += delta.x;
                newPoint.y += delta.y;
            }
            Dimension offset = new Dimension(newPoint.x, newPoint.y);
            this.move(offset);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyKode;
        if (this.selectionEnabled && (keyKode = e.getKeyCode()) == 127) {
            this.remove();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        block2: {
            int num;
            Point pt;
            block4: {
                block5: {
                    block3: {
                        this.requestFocus();
                        super.mousePressed(e);
                        if (!this.selectionEnabled) break block2;
                        pt = this.clientToView(e.getPoint());
                        num = this.selectionManager.getSelectedViewCount();
                        if (this.isInsertMode()) break block2;
                        if (num != 1 || this.getResizingDirection(this.selectionManager.getSelectedView(0), pt) <= 0) break block3;
                        this.selection = new CompositeView();
                        View view = this.selectionManager.getSelectedView(0);
                        this.initialRect = (Rectangle)view.getBounds().clone();
                        View selectionBox = this.createSelectionBox(this.initialRect);
                        this.selection.add(selectionBox);
                        this.cView.insert(this.selection, this.cView.size());
                        this.resizingDirection = this.getResizingDirection(view, pt);
                        this.startPoint = pt;
                        this.resizing = true;
                        break block2;
                    }
                    if (num != 1 || this.getControlPoint(this.selectionManager.getSelectedView(0), pt) <= -2) break block4;
                    this.controlPoint = this.getControlPoint(this.selectionManager.getSelectedView(0), pt);
                    if (this.controlPoint < 0) break block5;
                    this.selection = new CompositeView();
                    View view = this.selectionManager.getSelectedView(0);
                    this.initialRect = this.getControlPointBounds(view, this.controlPoint);
                    View selectionBox = this.createSelectionBox(this.initialRect);
                    this.selection.add(selectionBox);
                    this.cView.insert(this.selection, this.cView.size());
                    this.startPoint = pt;
                    this.prevPoint = pt;
                    this.prevCorrectedPoint = pt;
                    this.moving = true;
                    break block2;
                }
                int segment = this.getSelectedSegment(this.selectionManager.getSelectedView(0), pt);
                if (segment < 0) break block2;
                this.selection = new CompositeView();
                View view = this.selectionManager.getSelectedView(0);
                this.initialRect = this.getControlPointBounds(view, segment);
                View selectionBox = this.createSelectionBox(this.initialRect);
                this.selection.add(selectionBox);
                this.initialRect2 = this.getControlPointBounds(view, segment + 1);
                selectionBox = this.createSelectionBox(this.initialRect2);
                this.selection.add(selectionBox);
                this.cView.insert(this.selection, this.cView.size());
                this.startPoint = pt;
                this.prevPoint = pt;
                this.prevCorrectedPoint = pt;
                this.moving = true;
                break block2;
            }
            if (num > 0) {
                for (int i = 0; i < num; ++i) {
                    View view = this.selectionManager.getSelectedView(i);
                    Rectangle rect = view.getBounds();
                    if (!rect.contains(pt)) continue;
                    this.startPoint = pt;
                    this.prevPoint = pt;
                    this.prevCorrectedPoint = pt;
                    this.moving = true;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (!this.selectionEnabled) return;
        Point pt = this.clientToView(e.getPoint());
        if (this.isInsertMode()) {
            try {
                Object obj = this.helper.createObject(this.insertMode, pt);
                if (obj == null) return;
                this.add(obj, pt);
                return;
            }
            finally {
                this.resetInsertMode();
            }
        } else if (this.initiated) {
            if (this.resizing) {
                Point endPoint = pt;
                Dimension offset = null;
                switch (this.resizingDirection) {
                    case 1: {
                        offset = new Dimension(endPoint.x - this.startPoint.x, endPoint.y - this.startPoint.y);
                        break;
                    }
                    case 2: 
                    case 3: {
                        offset = new Dimension(0, endPoint.y - this.startPoint.y);
                        break;
                    }
                    case 4: 
                    case 6: {
                        offset = new Dimension(endPoint.x - this.startPoint.x, 0);
                        break;
                    }
                }
                if (offset != null) {
                    if (offset.width >= this.initialRect.width) {
                        offset.width = this.initialRect.width - 1;
                    }
                    if (offset.height >= this.initialRect.height) {
                        offset.height = this.initialRect.height - 1;
                    }
                }
                int dx = this.startPoint.x - pt.x;
                int dy = this.startPoint.y - pt.y;
                if (!e.isAltDown()) {
                    Point delta = this.snapToGrid(this.startPoint, pt, this.resizingDirection, this.initialRect.getBounds());
                    dx -= delta.x;
                    dy -= delta.y;
                }
                Rectangle rect = this.getResizingSelectionRect(this.resizingDirection, this.initialRect, dx, dy);
                this.changeSize(offset, new Dimension(rect.width - this.initialRect.width, rect.height - this.initialRect.height));
                this.cView.remove(this.selection);
                this.repaint();
                this.initialRect = null;
                this.initialRect2 = null;
                this.resizingDirection = 0;
                this.startPoint = null;
                this.selection = null;
                this.resizing = false;
                this.mPanel.setCursor(new Cursor(0));
            } else if (this.moving) {
                Dimension offset = new Dimension(this.prevCorrectedPoint.x - this.startPoint.x, this.prevCorrectedPoint.y - this.startPoint.y);
                this.move(offset, this.helper.drawOnFly());
                this.cView.remove(this.selection);
                this.repaint();
                this.startPoint = null;
                this.prevPoint = null;
                this.prevCorrectedPoint = null;
                this.selection = null;
                this.moving = false;
                this.initialRect = null;
                this.initialRect2 = null;
                this.controlPoint = -1;
            }
            this.initiated = false;
            return;
        } else {
            this.cView.remove(this.selection);
            this.repaint();
            this.initialRect = null;
            this.initialRect2 = null;
            this.resizingDirection = 0;
            this.startPoint = null;
            this.prevPoint = null;
            this.prevCorrectedPoint = null;
            this.selection = null;
            this.resizing = false;
            this.moving = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        if (this.selectionEnabled && !e.isControlDown()) {
            Point pt = this.clientToView(e.getPoint());
            if (this.resizing) {
                int dx = this.startPoint.x - pt.x;
                int dy = this.startPoint.y - pt.y;
                if (!e.isAltDown()) {
                    Point delta = this.snapToGrid(this.startPoint, pt, this.resizingDirection, this.initialRect.getBounds());
                    dx -= delta.x;
                    dy -= delta.y;
                }
                Rectangle rect = this.getResizingSelectionRect(this.resizingDirection, this.initialRect, dx, dy);
                View selectionBox = this.createSelectionBox(rect);
                this.cView.remove(this.selection);
                this.selection = new CompositeView();
                this.selection.add(selectionBox);
                this.cView.insert(this.selection, this.cView.size());
                this.repaint();
                this.initiated = true;
            } else if (this.moving) {
                View viewToAccept;
                if ((Math.abs(pt.x - this.startPoint.x) > 5 || Math.abs(pt.y - this.startPoint.y) > 5) && this.selection == null) {
                    this.selection = new CompositeView();
                    for (int i = 0; i < this.selectionManager.getSelectedViewCount(); ++i) {
                        View view = this.selectionManager.getSelectedView(i);
                        if (view.getModel() != null && this.helper.drawOnFly() && !view.equals(this.cView)) {
                            this.selection.add(view);
                            continue;
                        }
                        Rectangle rect = view.getBounds();
                        View selectionBox = this.createSelectionBox(rect);
                        this.selection.add(selectionBox);
                    }
                    this.cView.insert(this.selection, this.cView.size());
                }
                if (this.selection == null) {
                    return;
                }
                if (!e.isAltDown()) {
                    Rectangle bounds = this.selection.getBounds();
                    if (bounds.width == 6 || bounds.height == 6) {
                        bounds.grow(-3, -3);
                    }
                    Point delta = this.snapToGrid(this.prevPoint, this.prevCorrectedPoint, pt, bounds);
                    this.prevPoint = new Point(pt.x, pt.y);
                    pt.x += delta.x;
                    pt.y += delta.y;
                } else {
                    this.prevPoint = pt;
                }
                Point point = new Point(pt.x - this.prevCorrectedPoint.x, pt.y - this.prevCorrectedPoint.y);
                if (this.selection.getBounds().x + point.x < this.offset.x) {
                    point.x = this.offset.x - this.selection.getBounds().x;
                }
                if (this.selection.getBounds().y + point.y < this.offset.y) {
                    point.y = this.offset.y - this.selection.getBounds().y;
                }
                if ((viewToAccept = this.cView.getDeepestActive(pt)) instanceof CompositeView) {
                    for (int i = 0; i < this.selectionManager.getSelectedViewCount(); ++i) {
                        View viewToDrop = this.selectionManager.getSelectedView(i);
                        View accept = this.cView.getDeepestActive(pt, new Object[]{viewToDrop.getModel()}, null);
                        if (!(accept instanceof CompositeView) || this.helper.canAccept((CompositeView)accept, viewToDrop)) continue;
                        return;
                    }
                }
                this.selection.move(point);
                if (this.helper.drawOnFly()) {
                    for (View v : this.selection) {
                        if (v.getModel() == null) continue;
                        try {
                            this.helper.moveView(v, new Dimension(point.x, point.y));
                        }
                        catch (Exception exception) {}
                    }
                }
                this.prevCorrectedPoint = pt;
                this.repaint();
                this.initiated = true;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        if (this.selectionEnabled && this.selectionManager.getSelectedViewCount() == 1) {
            Point pt = this.clientToView(e.getPoint());
            View view = this.selectionManager.getSelectedView(0);
            switch (this.getResizingDirection(view, pt)) {
                case 1: {
                    this.mPanel.setCursor(new Cursor(6));
                    break;
                }
                case 2: {
                    this.mPanel.setCursor(new Cursor(8));
                    break;
                }
                case 3: {
                    this.mPanel.setCursor(new Cursor(7));
                    break;
                }
                case 4: {
                    this.mPanel.setCursor(new Cursor(10));
                    break;
                }
                case 5: {
                    this.mPanel.setCursor(new Cursor(11));
                    break;
                }
                case 6: {
                    this.mPanel.setCursor(new Cursor(4));
                    break;
                }
                case 7: {
                    this.mPanel.setCursor(new Cursor(9));
                    break;
                }
                case 8: {
                    this.mPanel.setCursor(new Cursor(5));
                    break;
                }
                default: {
                    this.mPanel.setCursor(new Cursor(0));
                }
            }
        }
    }

    protected Rectangle getResizingSelectionRect(int resizingDirection, Rectangle initialRect, int dx, int dy) {
        Rectangle rect = null;
        switch (resizingDirection) {
            case 1: {
                rect = new Rectangle(initialRect.x - dx, initialRect.y - dy, initialRect.width + dx, initialRect.height + dy);
                break;
            }
            case 2: {
                rect = new Rectangle(initialRect.x, initialRect.y - dy, initialRect.width, initialRect.height + dy);
                break;
            }
            case 3: {
                rect = new Rectangle(initialRect.x, initialRect.y - dy, initialRect.width - dx, initialRect.height + dy);
                break;
            }
            case 4: {
                rect = new Rectangle(initialRect.x - dx, initialRect.y, initialRect.width + dx, initialRect.height);
                break;
            }
            case 5: {
                rect = new Rectangle(initialRect.x, initialRect.y, initialRect.width - dx, initialRect.height);
                break;
            }
            case 6: {
                rect = new Rectangle(initialRect.x - dx, initialRect.y, initialRect.width + dx, initialRect.height - dy);
                break;
            }
            case 7: {
                rect = new Rectangle(initialRect.x, initialRect.y, initialRect.width, initialRect.height - dy);
                break;
            }
            case 8: {
                rect = new Rectangle(initialRect.x, initialRect.y, initialRect.width - dx, initialRect.height - dy);
                break;
            }
            default: {
                throw new RuntimeException("getResizingSelectionRect called with invalid resizingDirection=" + resizingDirection);
            }
        }
        if (rect.width <= 0) {
            rect.width = 1;
        }
        if (rect.height <= 0) {
            rect.height = 1;
        }
        if (rect.x >= initialRect.x + initialRect.width) {
            rect.x = initialRect.x + initialRect.width - 1;
        }
        if (rect.y >= initialRect.y + initialRect.height) {
            rect.y = initialRect.y + initialRect.height - 1;
        }
        return rect;
    }

    protected boolean check(Point corner, Point ptToCheck) {
        Rectangle rect = new Rectangle(corner.x - 3, corner.y - 3, 6, 6);
        return rect.contains(ptToCheck);
    }

    protected int getResizingDirection(View view, Point point) {
        if (!this.helper.isResizable(view)) {
            return 0;
        }
        Rectangle r = view.getBounds();
        if (this.check(new Point(r.x, r.y), point)) {
            return 1;
        }
        if (this.check(new Point(r.x + r.width / 2, r.y), point)) {
            return 2;
        }
        if (this.check(new Point(r.x + r.width, r.y), point)) {
            return 3;
        }
        if (this.check(new Point(r.x, r.y + r.height / 2), point)) {
            return 4;
        }
        if (this.check(new Point(r.x + r.width, r.y + r.height / 2), point)) {
            return 5;
        }
        if (this.check(new Point(r.x, r.y + r.height), point)) {
            return 6;
        }
        if (this.check(new Point(r.x + r.width / 2, r.y + r.height), point)) {
            return 7;
        }
        if (this.check(new Point(r.x + r.width, r.y + r.height), point)) {
            return 8;
        }
        return 0;
    }

    protected int getControlPoint(View view, Point point) {
        if (!(view instanceof ArrowView)) {
            return -2;
        }
        Point pathOffset = ((ArrowView)view).getPathOffset();
        Rectangle curRect = new Rectangle(point.x - 3 - pathOffset.x, point.y - 3 - pathOffset.y, 6, 6);
        SimplePath path = ((ArrowView)view).getPath();
        for (int i = 0; i < path.npoints; ++i) {
            if (!curRect.contains(path.xpoints[i], path.ypoints[i])) continue;
            return i;
        }
        return -1;
    }

    protected int getSelectedSegment(View view, Point point) {
        if (!(view instanceof ArrowView)) {
            return -2;
        }
        Point pathOffset = ((ArrowView)view).getPathOffset();
        Point curPoint = new Point(point.x - pathOffset.x, point.y - pathOffset.y);
        SimplePath path = ((ArrowView)view).getPath();
        return PathUtils.getNearestSegment(path, curPoint);
    }

    protected Rectangle getControlPointBounds(View view, int point) {
        if (!(view instanceof ArrowView)) {
            return null;
        }
        Point pathOffset = ((ArrowView)view).getPathOffset();
        SimplePath path = ((ArrowView)view).getPath();
        return new Rectangle(path.xpoints[point] + pathOffset.x - 3, path.ypoints[point] + pathOffset.y - 3, 6, 6);
    }

    protected View createSelectionBox(Rectangle rect) {
        float[] dash = new float[]{3.0f, 3.0f};
        BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
        Pen pen = new Pen(dashed, Color.black);
        return new BoxView(pen, null, rect);
    }

    protected View createAcceptingSelectionBox(Rectangle rect) {
        float[] dash = new float[]{1.0f, 1.0f};
        BasicStroke dashed = new BasicStroke(3.0f, 0, 0, 10.0f, dash, 0.0f);
        Pen pen = new Pen(dashed, Color.blue);
        return new BoxView(pen, null, rect);
    }

    protected Point snapToGrid(Point oldPoint, Point oldCorrectedPoint, Point newPoint, Rectangle oldBounds) {
        Point result = new Point();
        if (this.gridOptions != null && this.gridOptions.isShowGrid() && this.gridOptions.getStepSize() > 0) {
            Point targetLocation = new Point(newPoint.x - oldCorrectedPoint.x, newPoint.y - oldCorrectedPoint.y);
            boolean snapToX = true;
            boolean snapToY = true;
            if (newPoint.x < oldPoint.x) {
                targetLocation.x += oldBounds.x;
            } else if (newPoint.x > oldPoint.x) {
                targetLocation.x += oldBounds.x + oldBounds.width;
            } else {
                snapToX = false;
            }
            if (newPoint.y < oldPoint.y) {
                targetLocation.y += oldBounds.y;
            } else if (newPoint.y > oldPoint.y) {
                targetLocation.y += oldBounds.y + oldBounds.height;
            } else {
                snapToY = false;
            }
            int stepSize = this.gridOptions.getStepSize();
            if (snapToX) {
                result.x = targetLocation.x / stepSize * stepSize - targetLocation.x;
                if (result.x < -stepSize / 2) {
                    result.x = stepSize + result.x;
                }
            } else {
                result.x = oldCorrectedPoint.x - oldPoint.x;
            }
            if (snapToY) {
                result.y = targetLocation.y / stepSize * stepSize - targetLocation.y;
                if (result.y < -stepSize / 2) {
                    result.y = stepSize + result.y;
                }
            } else {
                result.y = oldCorrectedPoint.y - oldPoint.y;
            }
        }
        return result;
    }

    protected Point snapToGrid(Point oldPoint, Point newPoint, int direction, Rectangle viewBounds) {
        Point result = new Point();
        if (this.gridOptions != null && this.gridOptions.isShowGrid() && this.gridOptions.getStepSize() > 0) {
            int stepSize = this.gridOptions.getStepSize();
            boolean snapX = false;
            boolean snapY = false;
            Point targetPoint = new Point(viewBounds.x + newPoint.x - oldPoint.x, viewBounds.y + newPoint.y - oldPoint.y);
            if (direction == 4 || direction == 1 || direction == 6) {
                snapX = true;
            } else if (direction == 5 || direction == 3 || direction == 8) {
                targetPoint.x += viewBounds.width;
                snapX = true;
            }
            if (direction == 1 || direction == 2 || direction == 3) {
                snapY = true;
            } else if (direction == 6 || direction == 7 || direction == 8) {
                targetPoint.y += viewBounds.height;
                snapY = true;
            }
            if (snapX) {
                result.x = targetPoint.x / stepSize * stepSize - targetPoint.x;
                if (result.x < -stepSize / 2) {
                    result.x = stepSize + result.x;
                }
            }
            if (snapY) {
                result.y = targetPoint.y / stepSize * stepSize - targetPoint.y;
                if (result.y < -stepSize / 2) {
                    result.y = stepSize + result.y;
                }
            }
        }
        return result;
    }

    public void addTransactionListener(TransactionListener listener) {
        this.listenerList.add(TransactionListener.class, listener);
    }

    public void removeTransactionListener(TransactionListener listener) {
        this.listenerList.remove(TransactionListener.class, listener);
    }

    public void startTransaction(String name) {
        if (this.cView != null && this.cView.getModel() != null) {
            this.fireStartTransaction(new TransactionEvent(this.cView.getModel(), name));
        }
        this.selectionUndo = new SelectionUndo(this.getSelectionManager().getSelectedModels());
        this.fireAddEdit(this.selectionUndo);
    }

    public void startTransaction(TransactionEvent te) {
        this.fireStartTransaction(te);
        this.selectionUndo = new SelectionUndo(this.getSelectionManager().getSelectedModels());
        this.fireAddEdit(this.selectionUndo);
    }

    public boolean addEdit(UndoableEdit ue) {
        this.fireAddEdit(ue);
        return true;
    }

    public void completeTransaction() {
        SelectionUndo s = this.selectionUndo;
        if (s != null) {
            s.setNewSelection(this.getSelectionManager().getSelectedModels());
        }
        this.selectionUndo = null;
        this.fireCompleteTransaction();
    }

    protected void fireStartTransaction(TransactionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TransactionListener.class) continue;
            ((TransactionListener)listeners[i + 1]).startTransaction(evt);
        }
    }

    protected void fireAddEdit(UndoableEdit ue) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TransactionListener.class) continue;
            ((TransactionListener)listeners[i + 1]).addEdit(ue);
        }
    }

    protected void fireCompleteTransaction() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TransactionListener.class) continue;
            ((TransactionListener)listeners[i + 1]).completeTransaction();
        }
    }

    class SelectionUndo
    extends AbstractUndoableEdit {
        Object[] oldSelection = null;
        Object[] newSelection = null;

        SelectionUndo(Object[] oldSelection) {
            this.oldSelection = oldSelection;
        }

        public void setNewSelection(Object[] newSelection) {
            this.newSelection = newSelection;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.oldSelection.length > 0) {
                ViewEditorPane.this.getSelectionManager().selectModels(this.oldSelection, true);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.newSelection.length > 0) {
                ViewEditorPane.this.getSelectionManager().selectModels(this.newSelection, true);
            }
        }
    }
}

