/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.editor;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import ru.biosoft.graphics.ArrowView;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.editor.BoxSelector;
import ru.biosoft.graphics.editor.PathSelector;
import ru.biosoft.graphics.editor.ResizingBoxSelector;
import ru.biosoft.graphics.editor.ViewEditorHelper;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.graphics.editor.ViewPaneAdapter;
import ru.biosoft.graphics.editor.ViewPaneEvent;
import ru.biosoft.graphics.editor.ViewPaneLayer;
import ru.biosoft.graphics.editor.ViewSelector;

public class SelectionManager
extends ViewPaneAdapter
implements ViewPaneLayer {
    protected ViewPane viewPane;
    protected ViewSelector selector = new BoxSelector();
    protected Vector<View> selectedViews = new Vector();
    protected Set<Object> selectedModels = new HashSet<Object>();
    protected ViewEditorHelper helper = null;

    public SelectionManager(ViewPane viewPane) {
        this.viewPane = viewPane;
    }

    public ViewSelector getViewSelector() {
        return this.selector;
    }

    public void setViewSelector(ViewSelector selector) {
        this.selector = selector;
    }

    public boolean contains(View view) {
        return this.selectedViews.contains(view);
    }

    public int getSelectedViewCount() {
        return this.selectedViews.size();
    }

    public View getSelectedView(int i) {
        return this.selectedViews.get(i);
    }

    public Rectangle getBounds() {
        if (this.selectedViews.size() == 0) {
            return null;
        }
        Rectangle result = this.getSelectedView(0).getBounds();
        for (int i = 1; i < this.selectedViews.size(); ++i) {
            result = result.union(this.getSelectedView(i).getBounds());
        }
        return result;
    }

    public void clearSelection() {
        this.selectedViews.clear();
        this.selectedModels.clear();
    }

    public void selectView(View view, boolean exclusively) {
        if (exclusively) {
            this.selectedViews.clear();
            this.selectedModels.clear();
        } else if (this.selectedViews.contains(view)) {
            return;
        }
        this.selectedViews.add(view);
        Object model = view.getModel();
        if (model != null) {
            this.selectedModels.add(model);
        }
    }

    public Object[] getSelectedModels() {
        return this.selectedModels.toArray();
    }

    public View[] selectModel(Object model, boolean exclusively) {
        if (exclusively) {
            this.selectedViews.clear();
            this.selectedModels.clear();
        }
        View[] views = this.viewPane.getView(model);
        if (this.selectedModels.contains(model)) {
            return views;
        }
        if (views != null && views.length > 0) {
            boolean isEdge = false;
            for (View view : views) {
                if (!(view instanceof ArrowView)) continue;
                this.selectView(view, false);
                isEdge = true;
            }
            if (!isEdge) {
                for (View view : views) {
                    this.selectView(view, false);
                }
            }
        }
        return views;
    }

    public View[] selectModels(Object[] models, boolean exclusively) {
        if (exclusively) {
            this.selectedViews.clear();
            this.selectedModels.clear();
        }
        ArrayList<View> allViews = new ArrayList<View>();
        for (Object model : models) {
            View[] views;
            for (View view : views = this.selectModel(model, false)) {
                allViews.add(view);
            }
        }
        return allViews.toArray(new View[allViews.size()]);
    }

    @Override
    public void paintLayer(Graphics2D g2) {
        if (this.getSelectedViewCount() == 1 && null != this.helper && this.helper.isResizable(this.getSelectedView(0))) {
            this.setViewSelector(new ResizingBoxSelector());
        } else {
            this.setViewSelector(new BoxSelector());
        }
        for (View view : this.selectedViews) {
            if (!view.isVisible() || !view.isActive()) continue;
            if (view instanceof ArrowView) {
                new PathSelector().paint(g2, view);
                continue;
            }
            this.selector.paint(g2, view);
        }
    }

    @Override
    public void mousePressed(ViewPaneEvent e) {
        View view = e.getViewSource();
        if (view == null) {
            return;
        }
        this.selectView(view, true);
        this.viewPane.repaint();
    }
}

