/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.editor;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.editor.ResizableSelectionManager;
import ru.biosoft.graphics.editor.ViewEditorHelper;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.graphics.editor.ViewPaneEvent;

public class RectangleSelectionManager
extends ResizableSelectionManager {
    private static final Color SELECTION_COLOR = new Color(255, 255, 100, 100);
    protected boolean startSelection = false;
    protected Point start;
    protected Rectangle curRect;

    public RectangleSelectionManager(ViewPane viewPane, ViewEditorHelper helper) {
        super(viewPane, helper);
    }

    @Override
    public void mouseDragged(ViewPaneEvent e) {
        super.mouseDragged(e);
        if (this.start != null) {
            if (this.startSelection) {
                Rectangle newRect = this.makeRectangle(this.start, e.getPoint());
                Rectangle repaintRect = new Rectangle(newRect);
                if (this.curRect != null) {
                    repaintRect.add(this.curRect);
                }
                ViewPane viewPane = e.getViewPane();
                double sx = viewPane.getScaleX();
                double sy = viewPane.getScaleY();
                Point offset = viewPane.offset;
                if (offset != null) {
                    repaintRect.x -= offset.x;
                    repaintRect.y -= offset.y;
                }
                repaintRect.x = (int)((double)repaintRect.x * sx);
                repaintRect.y = (int)((double)repaintRect.y * sy);
                repaintRect.width = (int)((double)repaintRect.width * sx);
                repaintRect.height = (int)((double)repaintRect.height * sy);
                repaintRect.grow(1, 1);
                this.curRect = newRect;
                viewPane.mPanel.repaint(repaintRect);
            } else if (e.isControlDown()) {
                this.clearSelection();
                this.viewPane.repaint();
                this.startSelection = true;
                if (e.getViewPane() instanceof ViewEditorPane) {
                    ((ViewEditorPane)e.getViewPane()).setSelectionEnabled(false);
                }
            }
        } else {
            super.mouseDragged(e);
        }
    }

    @Override
    public void mouseReleased(ViewPaneEvent e) {
        super.mouseReleased(e);
        if (this.startSelection) {
            if (e.getViewPane() instanceof ViewEditorPane) {
                ((ViewEditorPane)e.getViewPane()).setSelectionEnabled(true);
            }
            this.startSelection = false;
            Rectangle rect = this.makeRectangle(this.start, e.getPoint());
            this.makeSelections(e.getViewPane().getView(), rect, null);
        }
        this.curRect = null;
    }

    protected void makeSelections(View view, Rectangle rect, Object parentModel) {
        if (view.getModel() != null && view.getModel() != parentModel && rect.contains(view.getBounds())) {
            this.selectView(view, false);
            return;
        }
        if (!(view instanceof CompositeView)) {
            return;
        }
        for (View child : (CompositeView)view) {
            this.makeSelections(child, rect, view.getModel());
        }
    }

    @Override
    public void mousePressed(ViewPaneEvent e) {
        super.mousePressed(e);
        if (e.isControlDown()) {
            this.start = e.getPoint();
        }
    }

    protected Rectangle makeRectangle(Point first, Point second) {
        int width = first.x - second.x;
        int height = first.y - second.y;
        return new Rectangle(first.x < second.x ? first.x : second.x, first.y < second.y ? first.y : second.y, width < 0 ? -width : width, height < 0 ? -height : height);
    }

    @Override
    public void paintLayer(Graphics2D g2) {
        super.paintLayer(g2);
        if (this.curRect != null) {
            g2.setColor(SELECTION_COLOR);
            g2.fillRect(this.curRect.x, this.curRect.y, this.curRect.width, this.curRect.height);
        }
    }
}

