/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.editor;

import java.awt.Point;
import java.awt.Rectangle;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.editor.SelectionManager;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.graphics.editor.ViewPaneEvent;

public class MultipleSelectionManager
extends SelectionManager {
    boolean wasDragged = false;

    public MultipleSelectionManager(ViewPane viewPane) {
        super(viewPane);
    }

    @Override
    public void mousePressed(ViewPaneEvent e) {
        boolean modifier;
        View view = this.getSelectedViewForEvent(e);
        if (view == null) {
            return;
        }
        boolean bl = modifier = e.isControlDown() || e.isShiftDown();
        if (modifier && this.selectedViews.contains(view)) {
            this.selectedViews.remove(view);
            this.selectedModels.remove(view.getModel());
            this.viewPane.repaint();
        } else if (modifier) {
            this.selectView(view, false);
        } else if (this.selectedViews.size() == 0) {
            this.selectView(view, false);
        } else if (!this.selectedViews.contains(view)) {
            this.selectView(view, true);
        }
    }

    @Override
    public void mouseReleased(ViewPaneEvent e) {
        boolean modifier;
        if (this.wasDragged) {
            this.wasDragged = false;
            return;
        }
        View view = this.getSelectedViewForEvent(e);
        if (view == null) {
            return;
        }
        boolean bl = modifier = e.isControlDown() || e.isShiftDown();
        if (!modifier) {
            this.selectView(view, true);
        }
    }

    @Override
    public void mouseDragged(ViewPaneEvent e) {
        this.wasDragged = true;
    }

    private View getSelectedViewForEvent(ViewPaneEvent e) {
        View view = this.getSelectedElement(e.getPoint());
        if (view == null) {
            view = e.getViewSource();
        }
        return view;
    }

    private View getSelectedElement(Point point) {
        for (Object obj : this.selectedViews) {
            View view = (View)obj;
            Rectangle rectInside = (Rectangle)view.getBounds().clone();
            Rectangle rectOutside = (Rectangle)rectInside.clone();
            rectOutside.grow(4, 4);
            if (!rectOutside.contains(point) || rectInside.contains(point)) continue;
            return view;
        }
        return null;
    }

    @Override
    public void mouseClicked(ViewPaneEvent e) {
        boolean modifier;
        View view = e.getViewSource();
        if (view == null) {
            return;
        }
        boolean bl = modifier = e.isControlDown() || e.isShiftDown();
        if (!modifier) {
            this.selectView(view, true);
        }
    }
}

