/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class InsertAction
extends AbstractAction {
    private static final Logger log = Logger.getLogger(InsertAction.class.getName());
    public static final String TYPE = "type";
    private Vector<ActionListener> actionListeners = null;

    public static Icon getIcon(String imageFile) {
        if (imageFile != null) {
            try {
                URL url = imageFile.getClass().getResource(imageFile);
                return new ImageIcon(url);
            }
            catch (Exception e) {
                log.warning("Icon " + imageFile + " initialization error");
            }
        }
        return null;
    }

    public InsertAction() {
    }

    public InsertAction(Object type, String name, String shortDesc, String longDesc, int mnemonic, String imageFile, ActionListener listener) {
        this.putValue(TYPE, type);
        this.putValue("Name", name);
        this.putValue("ShortDescription", shortDesc);
        this.putValue("LongDescription", longDesc);
        this.putValue("MnemonicKey", mnemonic);
        this.putValue("SmallIcon", InsertAction.getIcon(imageFile));
        if (listener != null) {
            this.addActionListener(listener);
        }
    }

    public InsertAction(Object type, Icon icon) {
        this.putValue(TYPE, type);
        this.putValue("SmallIcon", icon);
        try {
            if (type instanceof Class) {
                BeanInfo bi = Introspector.getBeanInfo((Class)type);
                BeanDescriptor bd = bi.getBeanDescriptor();
                this.putValue("Name", bd.getDisplayName());
                this.putValue("ShortDescription", "<html><b>" + bd.getDisplayName() + "</b><br>" + bd.getShortDescription());
            } else {
                this.putValue("Name", type.toString());
                this.putValue("ShortDescription", "<html><b>" + type.toString() + "</b>");
            }
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Can not initialise InsertAction for class " + type, t);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.fireActionPerformed(evt);
    }

    protected void fireActionPerformed(ActionEvent evt) {
        ActionEvent event = new ActionEvent(this, evt.getID(), evt.getActionCommand());
        if (this.actionListeners != null) {
            for (int i = this.actionListeners.size() - 1; i >= 0; --i) {
                ActionListener l = this.actionListeners.get(i);
                if (l == null) continue;
                l.actionPerformed(event);
            }
        }
    }

    public void addActionListener(ActionListener l) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        this.actionListeners.add(l);
    }

    public void removeActionListeners(Class clazz) {
        for (int i = this.actionListeners.size() - 1; i >= 0; --i) {
            ActionListener l = this.actionListeners.get(i);
            if (clazz != l.getClass()) continue;
            this.actionListeners.remove(l);
        }
    }
}

