/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.editor;

import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.Preferences;
import com.developmentontheedge.beans.PropertyChangeObservable;
import com.developmentontheedge.beans.WeakPropertyChangeForwarder;
import com.developmentontheedge.beans.editors.StringTagEditorSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.editor.GridOptionsMessageBundle;
import sun.awt.AppContext;

public class GridOptions
extends Option
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(GridOptions.class.getName());
    public static final String GRID_OPTIONS = "GridOptions";
    private boolean useDefault;
    private boolean showGrid;
    private GridStyle gridStyle;
    private int cellSize;
    private int stepSize;
    JSONObject json = null;

    public GridOptions() {
        this.useDefault = true;
        this.showGrid = true;
        this.gridStyle = GridStyle.POINTS;
        this.cellSize = 20;
        this.stepSize = 5;
    }

    public GridOptions(String str) throws JSONException {
        this.initFromJSON(new JSONObject(str));
    }

    public GridOptions(Preferences preferences) {
        this();
        this.showGrid = preferences.getBooleanValue("showGrid", this.showGrid);
        this.gridStyle = this.getStyleFromString(preferences.getStringValue("gridStyle", this.getStyleAsString(this.gridStyle)));
        this.cellSize = preferences.getIntValue("cellSize", this.cellSize);
        this.stepSize = preferences.getIntValue("stepSize", this.stepSize);
    }

    public Preferences getAsPreferences() {
        Preferences preferences = new Preferences();
        preferences.setSaveOrder(true);
        try {
            GridOptionsMessageBundle messageBundle = new GridOptionsMessageBundle();
            preferences.add(new DynamicProperty("showGrid", messageBundle.getString("SHOW_GRID_NAME"), messageBundle.getString("SHOW_GRID_DESCRIPTION"), Boolean.class, (Object)this.showGrid));
            DynamicProperty styleProperty = new DynamicProperty("gridStyle", messageBundle.getString("GRID_STYLE_NAME"), messageBundle.getString("GRID_STYLE_DESCRIPTION"), String.class, (Object)this.getStyleAsString(this.gridStyle));
            styleProperty.getDescriptor().setPropertyEditorClass(StyleEditor.class);
            preferences.add(styleProperty);
            preferences.add(new DynamicProperty("cellSize", messageBundle.getString("CELL_SIZE_NAME"), messageBundle.getString("CELL_SIZE_DESCRIPTION"), Integer.class, (Object)this.cellSize));
            preferences.add(new DynamicProperty("stepSize", messageBundle.getString("STEP_SIZE_NAME"), messageBundle.getString("STEP_SIZE_DESCRIPTION"), Integer.class, (Object)this.stepSize));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Can not create grid preferences", e);
        }
        return preferences;
    }

    public GridOptions clone() {
        return GridOptions.copy(this, new GridOptions());
    }

    public static GridOptions copy(GridOptions source, GridOptions target) {
        target.useDefault = source.useDefault;
        target.showGrid = source.showGrid;
        target.cellSize = source.cellSize;
        target.stepSize = source.stepSize;
        target.gridStyle = source.gridStyle;
        return target;
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    public void setUseDefault(boolean useDefault) {
        boolean oldValue = this.useDefault;
        this.useDefault = useDefault;
        Preferences preferences = (Preferences)AppContext.getAppContext().get(Preferences.class);
        if (preferences != null) {
            Preferences defaultInstance = (Preferences)preferences.getValue(GRID_OPTIONS);
            if (!useDefault && defaultInstance != null) {
                defaultInstance.removePropertyChangeListener((PropertyChangeListener)this);
            }
            if (useDefault) {
                if (defaultInstance == null) {
                    try {
                        GridOptionsMessageBundle messageBundle = new GridOptionsMessageBundle();
                        preferences.add(new DynamicProperty(GRID_OPTIONS, messageBundle.getString("DISPLAY_NAME"), messageBundle.getString("SHORT_DESCRIPTION"), Preferences.class, (Object)this.getAsPreferences()));
                        defaultInstance = (Preferences)preferences.getValue(GRID_OPTIONS);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Can not create grid properties", e);
                    }
                }
                if (defaultInstance != null) {
                    new WeakPropertyChangeForwarder((PropertyChangeListener)this, (PropertyChangeObservable)defaultInstance);
                }
            }
        }
        this.json = null;
        this.firePropertyChange("useDefault", oldValue, useDefault);
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        boolean oldValue = this.showGrid;
        this.showGrid = showGrid;
        this.firePropertyChange("showGrid", oldValue, showGrid);
        if (showGrid != oldValue) {
            this.setUseDefault(false);
        }
        this.json = null;
    }

    public String getStyleAsString(GridStyle style) {
        if (style == GridStyle.POINTS) {
            return "Points";
        }
        if (style == GridStyle.BACKGROUND_GRID) {
            return "Background grid";
        }
        if (style == GridStyle.FOREGROUND_GRID) {
            return "Foreground grid";
        }
        return null;
    }

    public GridStyle getStyleFromString(String style) {
        if (style.equals("Background grid")) {
            return GridStyle.BACKGROUND_GRID;
        }
        if (style.equals("Foreground grid")) {
            return GridStyle.FOREGROUND_GRID;
        }
        return GridStyle.POINTS;
    }

    public GridStyle getGridStyle() {
        return this.gridStyle;
    }

    public void setGridStyle(GridStyle gridStyle) {
        GridStyle oldValue = this.gridStyle;
        this.gridStyle = gridStyle;
        this.firePropertyChange("gridStyle", (Object)oldValue, (Object)gridStyle);
        if (gridStyle != oldValue) {
            this.setUseDefault(false);
        }
        this.json = null;
    }

    public String getGridStyleString() {
        String styleAsString = this.getStyleAsString(this.getGridStyle());
        return styleAsString != null ? styleAsString : "Points";
    }

    public void setGridStyleFromString(String gridStyle) {
        this.setGridStyle(this.getStyleFromString(gridStyle));
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(int cellSize) {
        int oldValue = this.cellSize;
        this.cellSize = cellSize;
        this.firePropertyChange("cellSize", oldValue, cellSize);
        if (cellSize != oldValue) {
            this.setUseDefault(false);
        }
        this.json = null;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(int stepSize) {
        int oldValue = this.stepSize;
        this.stepSize = stepSize;
        this.firePropertyChange("stepSize", oldValue, stepSize);
        if (stepSize != oldValue) {
            this.setUseDefault(false);
        }
        this.json = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.useDefault) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("showGrid")) {
                this.showGrid = (Boolean)evt.getNewValue();
            } else if (propertyName.equals("gridStyle")) {
                String strStyle = (String)evt.getNewValue();
                this.gridStyle = this.getStyleFromString(strStyle);
            } else if (propertyName.equals("cellSize")) {
                this.cellSize = (Integer)evt.getNewValue();
            } else if (propertyName.equals("stepSize")) {
                this.stepSize = (Integer)evt.getNewValue();
            }
        }
    }

    public JSONObject toJSON() throws JSONException {
        if (this.json == null) {
            this.json = new JSONObject();
            this.json.put("useDefault", this.useDefault);
            this.json.put("showGrid", this.showGrid);
            this.json.put("cellSize", this.cellSize);
            this.json.put("stepSize", this.stepSize);
            this.json.put("gridStyle", (Object)this.gridStyle.toString());
        }
        return this.json;
    }

    private void initFromJSON(JSONObject from) throws JSONException {
        this.useDefault = from.getBoolean("useDefault");
        this.showGrid = from.getBoolean("showGrid");
        this.cellSize = from.getInt("cellSize");
        this.stepSize = from.getInt("stepSize");
        this.gridStyle = GridStyle.valueOf(from.getString("gridStyle"));
    }

    public String toString() {
        try {
            return this.toJSON().toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GridOptions)) {
            return false;
        }
        GridOptions options = (GridOptions)obj;
        if (this.showGrid != options.showGrid) {
            return false;
        }
        if (this.cellSize != options.cellSize) {
            return false;
        }
        if (this.gridStyle != options.gridStyle) {
            return false;
        }
        return this.stepSize == options.stepSize;
    }

    public static class StyleEditor
    extends StringTagEditorSupport {
        private static final String[] TYPES = new String[]{"Points", "Background grid", "Foreground grid"};

        public StyleEditor() {
            super(TYPES);
        }
    }

    static enum GridStyle {
        BACKGROUND_GRID,
        FOREGROUND_GRID,
        POINTS;

    }
}

