/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.editor;

import com.developmentontheedge.beans.editors.CustomEditorSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import ru.biosoft.graphics.editor.FontChooser;
import ru.biosoft.graphics.font.ColorFont;

public class FontEditor
extends CustomEditorSupport {
    JLabel label;

    public Component getCustomEditor() {
        this.label = this.createLabel();
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ColorFont colorFont = FontChooser.showDialog(JOptionPane.getRootFrame(), null, (ColorFont)FontEditor.this.getValue());
                Font font = colorFont.getFont();
                FontEditor.this.setValue(colorFont);
                JLabel source = (JLabel)e.getSource();
                source.setFont(font);
                source.setForeground(colorFont.getColor());
                source.setText(font.getFamily() + ", " + font.getSize());
            }
        });
        return this.label;
    }

    private JLabel createLabel() {
        ColorFont colorFont = (ColorFont)this.getValue();
        Font font = colorFont.getFont();
        String info = font.getFamily() + ", " + font.getSize();
        JLabel label = new JLabel(info, 0);
        label.setForeground(colorFont.getColor());
        label.setBackground(Color.white);
        label.setOpaque(true);
        label.setFont(font);
        return label;
    }

    public Component getCustomRenderer(Component parent, boolean isSelected, boolean hasFocus) {
        if (this.label == null) {
            this.label = this.createLabel();
        }
        if (isSelected && parent instanceof JTable) {
            this.label.setBackground(((JTable)parent).getSelectionBackground());
        }
        return this.label;
    }

    protected Object processValue() {
        Font value = (Font)this.getValue();
        if (this.label == null) {
            value = new Font("Courier", 0, 14);
        }
        return value;
    }
}

