/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.editor;

import com.developmentontheedge.beans.editors.ColorComboBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ru.biosoft.graphics.font.ColorFont;

public class FontChooser
extends JComponent {
    protected JPanel northPanel = null;
    protected JPanel centerPanel = null;
    protected SamplePanel samplePanel = new SamplePanel();
    protected JList<String> fontsList = null;
    protected JList<String> stylesList = null;
    protected JList<String> sizesList = null;
    protected Map<String, Integer> styles = null;
    protected Color color = null;
    static final String sampleText = "Sample text";
    private static final String[] styleNames;
    private static final Vector<String> sizes;

    public FontChooser(ColorFont colorFont) {
        Font font = colorFont.getFont();
        JPanel main = new JPanel();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        this.fontsList = new JList<String>(fontNames);
        this.fontsList.setSelectionMode(0);
        this.fontsList.addListSelectionListener(new FontChangeListener());
        JPanel fontPanel = new JPanel(new BorderLayout());
        fontPanel.add((Component)new JLabel("Font:                                                                 ", 2), "North");
        fontPanel.add((Component)new JScrollPane(this.fontsList), "Center");
        this.styles = new HashMap<String, Integer>();
        this.styles.put(styleNames[0], 0);
        this.styles.put(styleNames[1], 1);
        this.styles.put(styleNames[2], 2);
        this.styles.put(styleNames[3], 3);
        this.stylesList = new JList<String>(styleNames);
        this.stylesList.setSelectionMode(0);
        this.stylesList.addListSelectionListener(new StyleChangeListener());
        JPanel stylePanel = new JPanel(new BorderLayout());
        stylePanel.add((Component)new JLabel("Style:                     ", 2), "North");
        stylePanel.add((Component)new JScrollPane(this.stylesList), "Center");
        String size = "" + font.getSize();
        if (!sizes.contains(size)) {
            sizes.add(size);
        }
        this.sizesList = new JList<String>(sizes);
        this.sizesList.setSelectionMode(0);
        this.sizesList.addListSelectionListener(new SizeChangeListener());
        JPanel sizePanel = new JPanel(new BorderLayout());
        sizePanel.add((Component)new JLabel("Size:          ", 2), "North");
        sizePanel.add((Component)new JScrollPane(this.sizesList), "Center");
        main.add(fontPanel);
        main.add(stylePanel);
        main.add(sizePanel);
        this.northPanel = new JPanel(new BorderLayout());
        this.northPanel.add((Component)main, "Center");
        this.color = colorFont.getColor();
        ColorComboBox colorComboBox = new ColorComboBox(this.color);
        colorComboBox.setEnabled(this.color != null);
        JPanel colorComboBoxPanel = new JPanel();
        colorComboBox.addColorPropertyChangeListener((PropertyChangeListener)new ColorChangeListener());
        colorComboBoxPanel.add((Component)colorComboBox);
        colorComboBox.setPreferredSize(new Dimension(200, 20));
        this.northPanel.add((Component)colorComboBoxPanel, "South");
        this.centerPanel = new JPanel(new BorderLayout());
        this.centerPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.centerPanel.add((Component)this.samplePanel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.northPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.fontsList.setSelectedValue(font.getFamily(), true);
        this.sizesList.setSelectedValue(size, true);
        switch (font.getStyle()) {
            case 0: {
                this.stylesList.setSelectedValue(styleNames[0], true);
                break;
            }
            case 1: {
                this.stylesList.setSelectedValue(styleNames[1], true);
                break;
            }
            case 2: {
                this.stylesList.setSelectedValue(styleNames[2], true);
                break;
            }
            case 3: {
                this.stylesList.setSelectedValue(styleNames[3], true);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected font style: " + font.getStyle());
            }
        }
    }

    public ColorFont getColorFont() {
        String name = this.fontsList.getSelectedValue();
        int style = this.styles.get(this.stylesList.getSelectedValue());
        int size = Integer.parseInt(this.sizesList.getSelectedValue());
        if (this.color != null) {
            return new ColorFont(name, style, size, this.color);
        }
        return new ColorFont(name, style, size);
    }

    public static ColorFont showDialog(Component parent, String title, ColorFont font) {
        if (title == null) {
            title = "Select Font";
        }
        FontChooser chooserPane = new FontChooser(font);
        FontTracker fontTracker = new FontTracker(chooserPane);
        FontChooserDialog dialog = new FontChooserDialog(parent, title, true, chooserPane, fontTracker, null);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Window w = e.getWindow();
                w.setVisible(false);
            }
        });
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                Window w = (Window)e.getComponent();
                w.dispose();
            }
        });
        Dimension screenSize = dialog.getToolkit().getScreenSize();
        dialog.setLocation((screenSize.width - dialog.getSize().width) / 2, (screenSize.height - dialog.getSize().height) / 2);
        dialog.pack();
        dialog.setVisible(true);
        return fontTracker.getFont() == null ? font : fontTracker.getFont();
    }

    static {
        int i;
        styleNames = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
        sizes = new Vector();
        for (i = 0; i < 13; ++i) {
            sizes.add(String.valueOf(i));
        }
        for (i = 14; i < 29; i += 2) {
            sizes.add("" + i);
        }
        sizes.add("36");
        sizes.add("48");
        sizes.add("72");
    }

    static class FontTracker
    implements ActionListener {
        FontChooser chooser;
        ColorFont font;

        public FontTracker(FontChooser f) {
            this.chooser = f;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.font = this.chooser.getColorFont();
        }

        public ColorFont getFont() {
            return this.font;
        }
    }

    static class FontChooserDialog
    extends JDialog {
        public FontChooserDialog(Component c, String title, boolean modal, FontChooser chooserPane, ActionListener okListener, ActionListener cancelListener) {
            super(JOptionPane.getFrameForComponent(c), title, modal);
            String okString = UIManager.getString("ColorChooser.okText");
            String cancelString = UIManager.getString("ColorChooser.cancelText");
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)chooserPane, "Center");
            JPanel buttonPane = new JPanel();
            buttonPane.setLayout(new FlowLayout(1));
            JButton okButton = new JButton(okString);
            if (okListener != null) {
                okButton.addActionListener(okListener);
            }
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setVisible(false);
                }
            });
            buttonPane.add(okButton);
            JButton cancelButton = new JButton(cancelString);
            if (cancelListener != null) {
                cancelButton.addActionListener(cancelListener);
            }
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setVisible(false);
                }
            });
            buttonPane.add(cancelButton);
            this.getRootPane().setDefaultButton(okButton);
            contentPane.add((Component)buttonPane, "South");
            this.pack();
            this.setLocationRelativeTo(c);
        }
    }

    class SamplePanel
    extends JComponent {
        SamplePanel() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHints(hints);
            ColorFont colorFont = FontChooser.this.getColorFont();
            g2.setFont(colorFont.getFont());
            g2.setColor(colorFont.getColor());
            FontMetrics fm = g2.getFontMetrics();
            Rectangle rect = this.getVisibleRect();
            int x = (int)rect.getCenterX() - fm.stringWidth(FontChooser.sampleText) / 2;
            int y = (int)rect.getCenterY() + fm.getHeight() / 3;
            g2.drawString(FontChooser.sampleText, x, y);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(300, 100);
        }
    }

    class SizeChangeListener
    implements ListSelectionListener {
        SizeChangeListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FontChooser.this.samplePanel.repaint();
        }
    }

    class StyleChangeListener
    implements ListSelectionListener {
        StyleChangeListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FontChooser.this.samplePanel.repaint();
        }
    }

    class FontChangeListener
    implements ListSelectionListener {
        FontChangeListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FontChooser.this.samplePanel.repaint();
        }
    }

    class ColorChangeListener
    implements PropertyChangeListener {
        ColorChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Color color = (Color)evt.getNewValue();
            if (color != null) {
                FontChooser.this.color = color;
            }
            FontChooser.this.samplePanel.repaint();
        }
    }
}

