/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.chart;

import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.Collection;
import ru.biosoft.graphics.chart.ChartSeries;

public class HistogramBuilder {
    private double minValue = Double.MAX_VALUE;
    private double maxValue = Double.MIN_VALUE;
    private TDoubleList points = new TDoubleArrayList();

    public void add(double point) {
        if (Double.isInfinite(point) || Double.isNaN(point)) {
            return;
        }
        this.points.add(point);
        this.minValue = Math.min(this.minValue, point);
        this.maxValue = Math.max(this.maxValue, point);
    }

    public void addAll(Collection<? extends Number> points) {
        for (Number number : points) {
            this.add(number.doubleValue());
        }
    }

    public void addAll(double[] points) {
        for (double point : points) {
            this.add(point);
        }
    }

    public ChartSeries createSeries() {
        return this.createSeries(20);
    }

    public ChartSeries createSeries(int minBars) {
        if (this.points.size() == 0) {
            return new ChartSeries(new double[0][]);
        }
        double step = this.maxValue == this.minValue ? 1.0 : HistogramBuilder.snapStep((this.maxValue - this.minValue) / (double)minBars);
        ChartSeries chartSeries = new ChartSeries(HistogramBuilder.getHistogramValues(this.points.toArray(), this.minValue, this.maxValue, step, 0.0));
        chartSeries.getLines().setShow(false);
        chartSeries.getBars().setShow(true);
        chartSeries.getBars().setWidth(step * 0.8);
        return chartSeries;
    }

    public static double[][] getHistogramValues(double[] points, double minValue, double maxValue, double step, double delta) {
        int minBucket = (int)Math.floor(minValue / step);
        double[][] buckets = new double[(int)(Math.ceil(maxValue / step) - (double)minBucket) + 1][];
        for (int i = 0; i < buckets.length; ++i) {
            buckets[i] = new double[2];
            buckets[i][0] = (double)(i + minBucket) * step + delta * step;
        }
        for (double val : points) {
            double[] dArray = buckets[(int)(Math.floor(val / step + 0.5) - (double)minBucket)];
            dArray[1] = dArray[1] + 100.0 / (double)points.length;
        }
        return buckets;
    }

    public static double snapStep(double step) {
        if (step <= 0.0) {
            throw new IllegalArgumentException("Snap step can only be applied to positive number");
        }
        double magnitude = 1.0;
        while (step >= 10.0) {
            magnitude *= 10.0;
            step /= 10.0;
        }
        while (step < 1.0) {
            magnitude /= 10.0;
            step *= 10.0;
        }
        step = step >= 5.0 ? 5.0 : (step >= 2.0 ? 2.0 : 1.0);
        return step *= magnitude;
    }
}

