/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.chart;

import java.awt.Color;
import java.awt.Shape;
import java.io.IOException;
import java.io.Writer;
import java.util.Formatter;
import java.util.Locale;
import one.util.streamex.IntStreamEx;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.chart.BarsOptions;
import ru.biosoft.graphics.chart.Chart;
import ru.biosoft.graphics.chart.LinesOptions;
import ru.biosoft.util.ColorUtils;

public class ChartSeries {
    double[][] data = null;
    String label = null;
    int xAxis = 1;
    int yAxis = 1;
    LinesOptions lines;
    BarsOptions bars;
    Color color = Color.RED;
    Shape shape = Chart.CIRCLE;

    public ChartSeries() {
        this.bars = new BarsOptions();
        this.lines = new LinesOptions();
    }

    public ChartSeries(JSONObject from) {
        if (from == null) {
            return;
        }
        JSONArray dataArray = from.optJSONArray("data");
        if (dataArray != null) {
            this.data = new double[dataArray.length()][2];
            for (int i = 0; i < dataArray.length(); ++i) {
                JSONArray dataPoint = dataArray.optJSONArray(i);
                if (dataPoint == null || dataPoint.length() < 2) continue;
                this.data[i][0] = dataPoint.optDouble(0);
                this.data[i][1] = dataPoint.optDouble(1);
            }
        }
        this.xAxis = from.optInt("xaxis", 1);
        this.yAxis = from.optInt("yaxis", 1);
        if (from.has("label") && !from.isNull("label")) {
            this.label = from.optString("label");
        }
        if (from.has("color")) {
            this.color = ColorUtils.parseColor((String)from.optString("color"));
        }
        this.lines = new LinesOptions(from.optJSONObject("lines"));
        this.bars = new BarsOptions(from.optJSONObject("bars"));
    }

    public ChartSeries(double[][] data) {
        this();
        this.setData(data);
    }

    public ChartSeries(double[] x, double[] y) {
        this();
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arguments lengths must agree");
        }
        double[][] data = (double[][])IntStreamEx.ofIndices((double[])x).mapToObj(i -> new double[]{x[i], y[i]}).toArray(x$0 -> new double[x$0][]);
        this.setData(data);
    }

    public double[][] getData() {
        return this.data;
    }

    public void setData(double[][] data) {
        this.data = data;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getXAxis() {
        return this.xAxis;
    }

    public void setXAxis(int xAxis) {
        this.xAxis = xAxis;
    }

    public int getYAxis() {
        return this.yAxis;
    }

    public void setYAxis(int yAxis) {
        this.yAxis = yAxis;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public LinesOptions getLines() {
        return this.lines;
    }

    public void setLines(LinesOptions lines) {
        this.lines = lines;
    }

    public BarsOptions getBars() {
        return this.bars;
    }

    public void setBars(BarsOptions bars) {
        this.bars = bars;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject barsJSON;
        if (this.data == null) {
            return null;
        }
        JSONArray dataArray = new JSONArray();
        for (double[] point : this.data) {
            if (point.length != 2) continue;
            FormattedDoubleJSONArray dataPoint = new FormattedDoubleJSONArray();
            if (!Double.isFinite(point[0]) || !Double.isFinite(point[1])) continue;
            dataPoint.put(point[0]);
            dataPoint.put(point[1]);
            dataArray.put((Object)dataPoint);
        }
        JSONObject json = new JSONObject();
        json.put("data", (Object)dataArray);
        if (this.label != null) {
            json.put("label", (Object)this.label);
        }
        if (this.xAxis != 1) {
            json.put("xaxis", this.xAxis);
        }
        if (this.yAxis != 1) {
            json.put("yaxis", this.yAxis);
        }
        if (this.color.getAlpha() < 255) {
            json.put("color", (Object)("rgba(" + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue() + "," + this.color.getAlpha() + ")"));
        } else {
            json.put("color", (Object)("rgb(" + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue() + ")"));
        }
        JSONObject linesJSON = this.lines.toJSON();
        if (linesJSON != null) {
            json.put("lines", (Object)linesJSON);
        }
        if ((barsJSON = this.bars.toJSON()) != null) {
            json.put("bars", (Object)barsJSON);
        }
        return json;
    }

    private static class FormattedDoubleJSONArray
    extends JSONArray {
        private FormattedDoubleJSONArray() {
        }

        private String formatNumber(double number) {
            try (Formatter formatter = new Formatter(Locale.US);){
                formatter.format("%.4g", number);
                String s = formatter.toString();
                if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
                    while (s.endsWith("0")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    if (s.endsWith(".")) {
                        s = s.substring(0, s.length() - 1);
                    }
                }
                String string = s;
                return string;
            }
        }

        public String join(String separator) throws JSONException {
            int len = this.length();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(separator);
                }
                sb.append(this.formatNumber(this.optDouble(i)));
            }
            return sb.toString();
        }

        public String toString() {
            try {
                return '[' + this.join(",") + ']';
            }
            catch (Exception e) {
                return super.toString();
            }
        }

        public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
            try {
                writer.write(this.toString());
            }
            catch (IOException e) {
                super.write(writer, indentFactor, indent);
            }
            return writer;
        }
    }
}

