/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.chart;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.chart.AxisOptions;

public class ChartOptions {
    private final List<AxisOptions> xAxes = new ArrayList<AxisOptions>();
    private final List<AxisOptions> yAxes = new ArrayList<AxisOptions>();

    public ChartOptions() {
        this.xAxes.add(new AxisOptions());
        this.yAxes.add(new AxisOptions());
    }

    public ChartOptions(JSONObject json) {
        JSONArray jsonYAxes;
        JSONArray jsonXAxes;
        if (json == null) {
            this.xAxes.add(new AxisOptions());
            this.yAxes.add(new AxisOptions());
            return;
        }
        if (json.has("xaxis") && !json.isNull("xaxis")) {
            this.xAxes.add(new AxisOptions(json.optJSONObject("xaxis")));
        }
        if ((jsonXAxes = json.optJSONArray("xaxes")) != null) {
            for (int i = 0; i < jsonXAxes.length(); ++i) {
                this.xAxes.add(new AxisOptions(jsonXAxes.optJSONObject(i)));
            }
        }
        if (json.has("yaxis") && !json.isNull("yaxis")) {
            this.yAxes.add(new AxisOptions(json.optJSONObject("yaxis")));
        }
        if ((jsonYAxes = json.optJSONArray("yaxes")) != null) {
            for (int i = 0; i < jsonYAxes.length(); ++i) {
                this.yAxes.add(new AxisOptions(jsonYAxes.optJSONObject(i)));
            }
        }
        if (this.xAxes.isEmpty()) {
            this.xAxes.add(new AxisOptions());
        }
        if (this.yAxes.isEmpty()) {
            this.yAxes.add(new AxisOptions());
        }
    }

    public AxisOptions getXAxis(int n) {
        return this.xAxes.get(n - 1);
    }

    public AxisOptions getXAxis() {
        return this.getXAxis(1);
    }

    public int getXAxisCount() {
        return Math.max(this.xAxes.size(), 1);
    }

    public void addXAxis(AxisOptions xaxis) {
        this.xAxes.add(xaxis);
    }

    public void setXAxis(AxisOptions xaxis) {
        this.xAxes.clear();
        this.addXAxis(xaxis);
    }

    public AxisOptions getYAxis(int n) {
        return this.yAxes.get(n - 1);
    }

    public AxisOptions getYAxis() {
        return this.getYAxis(1);
    }

    public int getYAxisCount() {
        return Math.max(this.yAxes.size(), 1);
    }

    public void setYAxis(AxisOptions yaxis) {
        this.yAxes.clear();
        this.addYAxis(yaxis);
    }

    public void addYAxis(AxisOptions yaxis) {
        this.yAxes.add(yaxis);
    }

    public JSONObject toJSON() throws JSONException {
        int i;
        JSONObject axisJson;
        JSONObject json = new JSONObject();
        if (!this.xAxes.isEmpty()) {
            if (this.xAxes.size() == 1) {
                axisJson = this.getXAxis().toJSON();
                if (this.getXAxis() != null && axisJson != null) {
                    json.put("xaxis", (Object)this.correctAxis(axisJson, true));
                }
            } else {
                JSONArray jsonXAxes = new JSONArray();
                for (i = 0; i < this.xAxes.size(); ++i) {
                    JSONObject jsonXAxis = this.xAxes.get(i).toJSON();
                    jsonXAxes.put((Object)(jsonXAxis == null ? new JSONObject() : this.correctAxis(jsonXAxis, true)));
                }
                json.put("xaxes", (Object)jsonXAxes);
            }
        }
        if (!this.yAxes.isEmpty()) {
            if (this.yAxes.size() == 1) {
                axisJson = this.getYAxis().toJSON();
                if (this.getYAxis() != null && axisJson != null) {
                    json.put("yaxis", (Object)this.correctAxis(axisJson, false));
                }
            } else {
                JSONArray jsonYAxes = new JSONArray();
                for (i = 0; i < this.yAxes.size(); ++i) {
                    JSONObject jsonYAxis = this.yAxes.get(i).toJSON();
                    jsonYAxes.put((Object)(jsonYAxis == null ? new JSONObject() : this.correctAxis(jsonYAxis, false)));
                }
                json.put("yaxes", (Object)jsonYAxes);
            }
        }
        return json;
    }

    private JSONObject correctAxis(JSONObject axisOptions, boolean isX) {
        if (!isX) {
            return axisOptions;
        }
        if (axisOptions.optString("position", "").equals("right")) {
            try {
                axisOptions.put("position", (Object)"top");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return axisOptions;
    }
}

