/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.chart;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.chart.AxisOptions;
import ru.biosoft.graphics.chart.ChartOptions;
import ru.biosoft.graphics.chart.ChartSeries;

public class Chart
implements Iterable<ChartSeries> {
    private ChartOptions options = null;
    private final List<ChartSeries> series = new ArrayList<ChartSeries>();
    private CharSequence initString = null;
    public static final Shape CIRCLE = new Ellipse2D.Float(-2.5f, -2.5f, 5.0f, 5.0f);
    public static final Shape RECTANGLE = new Rectangle2D.Float(-3.0f, -3.0f, 6.0f, 6.0f);

    private void initFromJSON(JSONArray from) {
        if (from == null || from.length() < 1) {
            return;
        }
        JSONArray data = null;
        if (from.optJSONObject(0) == null) {
            data = from.optJSONArray(0);
            if (from.optJSONObject(1) != null) {
                this.options = new ChartOptions(from.optJSONObject(1));
            }
        } else {
            data = from;
        }
        if (data != null) {
            for (int i = 0; i < data.length(); ++i) {
                if (data.optJSONObject(i) == null) continue;
                this.series.add(new ChartSeries(data.optJSONObject(i)));
            }
        }
    }

    private void init() {
        if (this.initString != null) {
            try {
                this.initFromJSON(new JSONArray(this.initString.toString()));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.initString = null;
        }
    }

    public Chart() {
    }

    public Chart(CharSequence from) {
        this.initString = from;
    }

    public Chart(JSONArray from) {
        this.initFromJSON(from);
    }

    public ChartOptions getOptions() {
        this.init();
        return this.options;
    }

    public boolean isEmpty() {
        return this.initString == null && this.series.isEmpty();
    }

    public void setOptions(ChartOptions options) {
        this.init();
        this.options = options;
    }

    public int addSeries(ChartSeries series) {
        this.init();
        this.series.add(series);
        return this.series.size();
    }

    public int addSeries(double[][] data) {
        this.init();
        return this.addSeries(new ChartSeries(data));
    }

    public ChartSeries getSeries(int index) {
        this.init();
        return this.series.get(index);
    }

    public int getSeriesCount() {
        this.init();
        return this.series.size();
    }

    public JSONArray toJSON() throws JSONException {
        this.init();
        JSONObject jsonOptions = this.options == null ? null : this.options.toJSON();
        JSONArray data = new JSONArray();
        for (int i = 0; i < this.series.size(); ++i) {
            JSONObject jsonSeries = this.series.get(i).toJSON();
            if (jsonSeries == null) continue;
            data.put((Object)jsonSeries);
        }
        if (jsonOptions == null) {
            return data;
        }
        JSONArray result = new JSONArray();
        result.put((Object)data);
        result.put((Object)jsonOptions);
        return result;
    }

    public String toString() {
        return this.getData().toString();
    }

    public CharSequence getData() {
        if (this.initString != null) {
            return this.initString;
        }
        if (this.isEmpty()) {
            return "";
        }
        try {
            return this.toJSON().toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    protected XYSeries createSeries(ChartSeries curSeries, String label, ChartOptions options) {
        double[][] data;
        XYSeries xySeries = new XYSeries((Comparable)((Object)label), false);
        for (double[] element : data = curSeries.getData()) {
            if (element == null || element.length < 2 || options.getXAxis(curSeries.getXAxis()).getTransform() == AxisOptions.Transform.LOGARITHM && element[0] <= 0.0 || options.getYAxis(curSeries.getYAxis()).getTransform() == AxisOptions.Transform.LOGARITHM && element[1] <= 0.0) continue;
            xySeries.add(element[0], element[1]);
        }
        return xySeries;
    }

    protected String getSeriesId(ChartSeries series) {
        return series.getXAxis() + "." + series.getYAxis() + "." + (series.getBars().isShow() ? "bars" : "lines");
    }

    protected void initXAxes(ChartOptions options, XYPlot xyPlot) {
        for (int i = 0; i < options.getXAxisCount(); ++i) {
            AxisOptions xAxis = options.getXAxis(i + 1);
            String label = xAxis.getLabel() == null || xAxis.getLabel().isEmpty() ? "Axis (X)" : xAxis.getLabel();
            LogAxis logAxis = new LogAxis(label);
            xyPlot.setDomainAxis(i, (ValueAxis)(xAxis.getTransform() == AxisOptions.Transform.LOGARITHM ? logAxis : new NumberAxis(label)));
            xyPlot.setDomainAxisLocation(i, xAxis.isRightOrTop() ? AxisLocation.TOP_OR_RIGHT : AxisLocation.BOTTOM_OR_LEFT);
            ValueAxis axis = xyPlot.getDomainAxis();
            if (xAxis.getMin() != null) {
                axis.setLowerBound(xAxis.getMin().doubleValue());
            }
            if (xAxis.getMax() == null) continue;
            axis.setUpperBound(xAxis.getMax().doubleValue());
        }
    }

    protected void initYAxes(ChartOptions options, XYPlot xyPlot) {
        for (int i = 0; i < options.getYAxisCount(); ++i) {
            AxisOptions yAxis = options.getYAxis(i + 1);
            String label = yAxis.getLabel() == null || yAxis.getLabel().isEmpty() ? "Axis (Y)" : yAxis.getLabel();
            LogAxis logAxis = new LogAxis(label);
            xyPlot.setRangeAxis(i, (ValueAxis)(yAxis.getTransform() == AxisOptions.Transform.LOGARITHM ? logAxis : new NumberAxis(label)));
            xyPlot.setRangeAxisLocation(i, yAxis.isRightOrTop() ? AxisLocation.TOP_OR_RIGHT : AxisLocation.BOTTOM_OR_LEFT);
            ValueAxis axis = xyPlot.getRangeAxis();
            if (yAxis.getMin() != null) {
                axis.setLowerBound(yAxis.getMin().doubleValue());
            }
            if (yAxis.getMax() == null) continue;
            axis.setUpperBound(yAxis.getMax().doubleValue());
        }
    }

    public JFreeChart getChart() {
        this.init();
        ChartOptions options = this.options == null ? new ChartOptions() : this.options;
        ArrayList<XYSeriesCollection> dataSetMap = new ArrayList<XYSeriesCollection>();
        ArrayList<ChartSeries> seriesMap = new ArrayList<ChartSeries>();
        boolean legend = false;
        for (int i = 0; i < this.series.size(); ++i) {
            ChartSeries curSeries = this.series.get(i);
            if (curSeries.getData() == null) continue;
            if (curSeries.getLabel() != null) {
                legend = true;
            }
            String label = curSeries.getLabel() == null ? String.valueOf(i) : curSeries.getLabel();
            XYSeries xySeries = this.createSeries(curSeries, label, options);
            dataSetMap.add(new XYSeriesCollection(xySeries));
            seriesMap.add(curSeries);
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)"", (String)"", (XYDataset)((XYDataset)dataSetMap.get(0)), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)true, (boolean)false);
        XYPlot xyPlot = chart.getXYPlot();
        xyPlot.setBackgroundPaint((Paint)Color.WHITE);
        xyPlot.setDomainGridlinePaint((Paint)Color.GRAY);
        xyPlot.setRangeGridlinePaint((Paint)Color.GRAY);
        this.initXAxes(options, xyPlot);
        this.initYAxes(options, xyPlot);
        for (int dataSetNum = 0; dataSetNum < dataSetMap.size(); ++dataSetNum) {
            XYBarRenderer renderer;
            XYSeriesCollection dataSet = (XYSeriesCollection)dataSetMap.get(dataSetNum);
            ChartSeries curSeries = (ChartSeries)seriesMap.get(dataSetNum);
            xyPlot.mapDatasetToDomainAxis(dataSetNum, curSeries.getXAxis() - 1);
            xyPlot.mapDatasetToRangeAxis(dataSetNum, curSeries.getYAxis() - 1);
            xyPlot.setDataset(dataSetNum, (XYDataset)dataSet);
            if (curSeries.getBars().isShow()) {
                renderer = new XYBarRenderer(1.0 - curSeries.getBars().getWidth());
                renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
                renderer.setShadowVisible(false);
            } else {
                renderer = new XYLineAndShapeRenderer(curSeries.getLines().isShow(), curSeries.getLines().isShapesVisible());
                if (curSeries.getLines().isShapesVisible()) {
                    renderer.setSeriesShape(0, curSeries.getShape());
                }
            }
            renderer.setSeriesPaint(0, (Paint)curSeries.getColor());
            xyPlot.setRenderer(dataSetNum, (XYItemRenderer)renderer);
        }
        return chart;
    }

    public BufferedImage getImage(int width, int height) {
        JFreeChart chart = this.getChart();
        chart.setBackgroundPaint((Paint)Color.white);
        return chart.createBufferedImage(width, height);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        return this.series.iterator();
    }
}

