/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.chart;

import org.json.JSONException;
import org.json.JSONObject;

public class BarsOptions {
    boolean show = false;
    boolean centered = false;
    double width = 1.0;

    public BarsOptions() {
    }

    public BarsOptions(JSONObject from) {
        if (from == null) {
            return;
        }
        this.show = from.optBoolean("show", false);
        this.centered = from.optString("align", "left").equals("center");
        this.width = from.optDouble("barWidth", 1.0);
    }

    public JSONObject toJSON() throws JSONException {
        if (this.show) {
            JSONObject result = new JSONObject();
            result.put("show", true);
            if (this.centered) {
                result.put("align", (Object)"center");
            }
            result.put("barWidth", this.width);
            return result;
        }
        return null;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }
}

