/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.chart;

import org.json.JSONException;
import org.json.JSONObject;

public class AxisOptions {
    private Transform transform = Transform.LINEAR;
    private Double min = null;
    private Double max = null;
    private String label = null;
    private boolean rightOrTop = false;
    private JSONObject json = null;

    public AxisOptions() {
    }

    public AxisOptions(boolean rightOrTop) {
        this.setRightOrTop(rightOrTop);
    }

    public AxisOptions(JSONObject json) {
        String pos;
        if (json == null) {
            return;
        }
        if (json.has("min") && !json.isNull("min")) {
            this.min = json.optDouble("min");
        }
        if (json.has("max") && !json.isNull("max")) {
            this.max = json.optDouble("max");
        }
        if (json.has("label") && !json.isNull("label")) {
            this.label = json.optString("label");
        }
        if (json.optString("transform", "").equals("log")) {
            this.transform = Transform.LOGARITHM;
        }
        if ((pos = json.optString("position", "")).equals("right") || pos.equals("top")) {
            this.rightOrTop = true;
        }
    }

    public boolean isRightOrTop() {
        return this.rightOrTop;
    }

    public void setRightOrTop(boolean rightOrTop) {
        this.rightOrTop = rightOrTop;
        this.json = null;
    }

    public Double getMin() {
        return this.min;
    }

    public void setMin(Double min) {
        this.min = min;
        this.json = null;
    }

    public Double getMax() {
        return this.max;
    }

    public void setMax(Double max) {
        this.max = max;
        this.json = null;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
        this.json = null;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.json = null;
    }

    public JSONObject toJSON() throws JSONException {
        if (this.json == null) {
            this.json = new JSONObject();
            if (this.min != null) {
                this.json.put("min", (Object)this.min);
            }
            if (this.max != null) {
                this.json.put("max", (Object)this.max);
            }
            if (this.transform == Transform.LOGARITHM) {
                this.json.put("transform", (Object)"log");
            }
            if (this.label != null && !this.label.equals("")) {
                this.json.put("label", (Object)this.label);
            }
            if (this.rightOrTop) {
                this.json.put("position", (Object)"right");
            }
        }
        return this.json.length() == 0 ? null : this.json;
    }

    public static enum Transform {
        LINEAR,
        LOGARITHM;

    }
}

