/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.access;

import com.developmentontheedge.application.ApplicationUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringEscapeUtils;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.ComplexTextView;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.PolygonView;
import ru.biosoft.graphics.font.ColorFont;

public class ViewUtils {
    @Nonnull
    private static final PolygonView errorSymbol = new PolygonView(null, new Brush(Color.RED), new int[]{0, 7, 20, 33, 40, 27, 40, 33, 20, 7, 0, 13}, new int[]{7, 0, 13, 0, 7, 20, 33, 40, 27, 40, 33, 20});

    public static BufferedImage paintException(Throwable t) {
        String message = "Error rendering image:<br>" + StringEscapeUtils.escapeHtml((String)ExceptionRegistry.log((Throwable)t)).replace("\n", "<br>");
        CompositeView view = new CompositeView();
        view.add(errorSymbol);
        ComplexTextView textView = new ComplexTextView(message, new ColorFont(new Font("SansSerif", 0, 12), Color.BLACK), null, 12, ApplicationUtils.getGraphics(), 500);
        view.add(textView, 25, new Point(5, 0));
        BufferedImage image = new BufferedImage(view.getBounds().width, view.getBounds().height, 2);
        Graphics2D graphics = image.createGraphics();
        view.paint(graphics);
        return image;
    }
}

