/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics.access;

import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import org.json.JSONException;
import ru.biosoft.access.ImageElement;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.CloneableDataElement;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElementSupport;
import ru.biosoft.graphics.chart.Chart;
import ru.biosoft.util.ImageUtils;

@PropertyName(value="chart")
@ClassIcon(value="resources/plot.gif")
public class ChartDataElement
extends DataElementSupport
implements ImageElement,
CloneableDataElement {
    private Chart chart;

    public ChartDataElement(String name, DataCollection origin) {
        super(name, origin);
    }

    public ChartDataElement(String name, DataCollection origin, Chart chart) {
        super(name, origin);
        this.chart = chart;
    }

    public Chart getChart() {
        return this.chart;
    }

    public BufferedImage getImage(Dimension dimension) {
        Dimension d = dimension == null ? this.getImageSize() : ImageUtils.correctImageSize((Dimension)dimension);
        return this.chart.getImage(d.width, d.height);
    }

    public Dimension getImageSize() {
        return new Dimension(600, 400);
    }

    public ChartDataElement clone(DataCollection origin, String name) throws CloneNotSupportedException {
        ChartDataElement clone = (ChartDataElement)super.clone(origin, name);
        try {
            clone.chart = new Chart(this.chart.toJSON());
        }
        catch (JSONException e) {
            throw new CloneNotSupportedException();
        }
        return clone;
    }
}

