/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Constructor;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.DummyView;

public abstract class View {
    protected Shape shape = null;
    protected int type = 0;
    protected Object model = null;
    protected String description = null;
    protected AffineTransform at;
    public static final int ACTIVE = 4;
    public static final int SELECTABLE = 16;
    public static final int HIDE = 8;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    public static final int BOTTOM = 8;
    public static final int TOP = 16;
    public static final int BASELINE = 0;
    private static ModelResolver modelResolver;

    public View(Shape shape) {
        this.shape = shape;
        this.at = AffineTransform.getScaleInstance(1.0, 1.0);
        this.setToScale(1.0, 1.0);
    }

    public Object getModel() {
        return this.model;
    }

    public void setModel(Object model) {
        this.model = model;
    }

    public Rectangle getBounds() {
        return this.shape.getBounds();
    }

    public Shape getShape() {
        return this.shape;
    }

    public void updateBounds() {
    }

    public boolean intersects(Rectangle rect) {
        return this.shape == null ? false : this.shape.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public int getSelectionPriority(Rectangle rect) {
        return 0;
    }

    public void setLocation(int x, int y) {
        Rectangle r = this.getBounds();
        this.move(new Point(x - r.x, y - r.y));
    }

    public void setLocation(Point pt) {
        this.setLocation(pt.x, pt.y);
    }

    public abstract void move(int var1, int var2);

    public void move(Point offset) {
        this.move(offset.x, offset.y);
    }

    public void setToScale(double factorX, double factorY) {
        this.at.setToScale(factorX, factorY);
    }

    public void scale(double sx, double sy) {
        double ssx = this.at.getScaleX();
        double ssy = this.at.getScaleY();
        this.setToScale(sx * ssx, sy * ssy);
    }

    public boolean isActive() {
        return (this.type & 4) != 0;
    }

    public void setActive(boolean isActive) {
        this.type = isActive ? (this.type |= 0x14) : (this.type &= 0xFFFFFFEB);
    }

    public boolean isSelectable() {
        return (this.type & 0x10) != 0;
    }

    public void setSelectable(boolean isSelectable) {
        this.type = isSelectable ? (this.type |= 0x10) : (this.type &= 0xFFFFFFEF);
    }

    public boolean isVisible() {
        return (this.type & 8) == 0;
    }

    public void setVisible(boolean isVisible) {
        this.type = !isVisible ? (this.type |= 8) : (this.type &= 0xFFFFFFF7);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void paint(Graphics2D g2) {
        if (this.isVisible()) {
            g2.draw(this.shape);
        }
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof View)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        View v = (View)obj;
        if (this.type != v.type) {
            return false;
        }
        if (this.model == null ^ v.model == null || this.model != null && !this.model.toString().equals(v.model.toString())) {
            return false;
        }
        return !(this.shape == null ^ v.shape == null) && (this.shape == null || this.shape.getBounds().equals(v.shape.getBounds()));
    }

    public JSONObject toJSON() throws JSONException {
        String str;
        String className;
        int ind;
        JSONObject result = new JSONObject();
        result.put("type", (Object)String.valueOf(this.type));
        if (this.getDescription() != null) {
            result.put("description", (Object)this.getDescription());
        }
        if ((ind = (className = this.getClass().getName()).lastIndexOf(46)) != -1) {
            className = className.substring(ind + 1);
        }
        result.put("class", (Object)className);
        Object model = this.getModel();
        ModelResolver resolver = View.getModelResolver();
        if (model != null && resolver != null && (str = resolver.toString(model)) != null) {
            result.put("model", (Object)str);
        }
        return result;
    }

    public JSONObject toJSONIfChanged(View v) throws JSONException {
        if (!this.equals(v)) {
            return this.toJSON();
        }
        return new DummyView(this.model, this.isActive()).toJSON();
    }

    protected void initFromJSON(JSONObject from) {
        try {
            ModelResolver resolver;
            this.type = from.getInt("type");
            if (from.has("description")) {
                this.setDescription(from.getString("description"));
            }
            if (from.has("model") && (resolver = View.getModelResolver()) != null) {
                this.setModel(resolver.fromString(from.getString("model")));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static View fromJSON(JSONObject childObj) {
        View child = null;
        try {
            String className = childObj.getString("class");
            int ind = View.class.getName().lastIndexOf(".");
            Class<?> c = View.class.getClassLoader().loadClass(View.class.getName().substring(0, ind + 1) + className);
            Constructor<?> constructor = c.getConstructor(JSONObject.class);
            child = (View)constructor.newInstance(childObj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return child;
    }

    public String toString() {
        try {
            return this.toJSON().toString();
        }
        catch (JSONException e) {
            return "";
        }
    }

    public static ModelResolver getModelResolver() {
        return modelResolver;
    }

    public static void setModelResolver(ModelResolver modelResolver) {
        View.modelResolver = modelResolver;
    }

    public static interface ModelResolver {
        public String toString(Object var1);

        public Object fromString(String var1);
    }
}

