/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.ShapeView;

public class TruncatedView
extends ShapeView {
    private ShapeView baseView;
    private float truncationPercent = 0.75f;

    public TruncatedView(JSONObject jsonObj) {
        super(null);
        this.initFromJSON(jsonObj);
    }

    public TruncatedView(ShapeView view) {
        super(null);
        this.init(view);
    }

    public TruncatedView(ShapeView view, float percent) {
        super(null);
        this.truncationPercent = percent;
        this.init(view);
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = super.toJSON();
        result.append("base", (Object)this.baseView.toJSON());
        result.append("truncationPercent", (Object)Float.valueOf(this.truncationPercent));
        return result;
    }

    @Override
    protected void initFromJSON(JSONObject from) {
        super.initFromJSON(from);
        if (from.has("truncationPercent")) {
            this.truncationPercent = (float)from.getDouble("truncationPercent");
        }
        try {
            this.init((ShapeView)TruncatedView.fromJSON(from.getJSONObject("base")));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void init(ShapeView view) {
        this.baseView = view;
        this.pen = view.getPen();
        this.brush = view.getBrush();
        this.shape = this.truncateShape(view.getShape());
    }

    private Shape truncateShape(Shape shape) {
        Area a = new Area(shape);
        Rectangle2D rect = a.getBounds2D();
        Rectangle2D.Double newRect = new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight() * (double)this.truncationPercent);
        a.subtract(new Area(newRect));
        return a;
    }

    @Override
    public void move(int x, int y) {
        this.baseView.move(x, y);
        this.shape = this.truncateShape(this.baseView.getShape());
    }
}

