/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.font.ColorFont;

public class TextView
extends View {
    protected String text;
    protected int alignment;
    protected int y;
    protected Rectangle rect = new Rectangle();
    protected ColorFont font;
    protected double yPosRatio;

    public TextView(JSONObject jsonObj) {
        super(null);
        this.initFromJSON(jsonObj);
    }

    public TextView(String text, Point pt, int alignment, ColorFont font, Graphics graphics) {
        super(null);
        this.text = text;
        this.rect.x = pt.x;
        this.y = pt.y;
        this.alignment = alignment;
        this.font = font;
        this.initSize(graphics.getFontMetrics(font.getFont()));
    }

    public TextView(String text, ColorFont font, Graphics graphics) {
        this(text, new Point(0, 0), 0, font, graphics);
    }

    protected void initSize(FontMetrics fm) {
        this.rect.width = fm.stringWidth(this.text);
        this.rect.height = fm.getHeight();
        if ((this.alignment & 1) != 0) {
            this.rect.x -= this.rect.width;
        } else if ((this.alignment & 2) != 0) {
            this.rect.x -= this.rect.width / 2;
        }
        if ((this.alignment & 0x10) != 0) {
            this.y += fm.getAscent();
        } else if ((this.alignment & 8) != 0) {
            this.y -= fm.getDescent();
        }
        this.rect.y = this.y - fm.getAscent();
        this.yPosRatio = (double)(this.y - this.rect.y) / (double)this.rect.height;
    }

    public String getText() {
        return this.text;
    }

    public Rectangle getTextPos(int from, int to, FontMetrics fm) {
        String s = this.text.substring(from, to);
        Rectangle r = new Rectangle(this.rect.x, this.rect.y, fm.stringWidth(s), fm.getHeight());
        if (from > 0) {
            String s2 = this.text.substring(0, from);
            r.x += fm.stringWidth(s2) + 1;
        }
        return r;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TextView)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TextView v = (TextView)obj;
        if (this.text == null && v.text != null || this.text != null && !this.text.equals(v.text)) {
            return false;
        }
        if (this.y != v.y || this.alignment != v.alignment || !this.rect.equals(v.rect)) {
            return false;
        }
        return this.font.getColor().equals(v.font.getColor()) && this.font.getFont().equals(v.font.getFont());
    }

    @Override
    public Rectangle getBounds() {
        Rectangle transformedRect = this.at.createTransformedShape(this.rect).getBounds();
        transformedRect.x = this.rect.x;
        transformedRect.y = this.rect.y;
        return transformedRect;
    }

    @Override
    public boolean intersects(Rectangle rect) {
        return this.rect.intersects(rect);
    }

    @Override
    public void move(int x, int y) {
        this.y += y;
        this.rect.y += y;
        this.rect.x += x;
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.isVisible()) {
            g.setColor(this.font.getColor());
            FontRenderContext frc = new FontRenderContext(this.at, g.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON, false);
            Font scaledFont = this.font.getFont().deriveFont(this.at);
            GlyphVector vec = scaledFont.createGlyphVector(frc, this.text);
            Rectangle r = this.getBounds();
            g.drawGlyphVector(vec, this.rect.x, (float)((double)r.y + this.yPosRatio * (double)r.height));
            g.clip(g.getClipBounds());
        }
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = super.toJSON();
        result.put("text", (Object)this.text);
        result.put("font", (Object)this.font.toJSON());
        result.put("alignment", 0);
        result.put("x", this.rect.x);
        result.put("y", this.y);
        result.put("scaleX", this.at.getScaleX());
        result.put("scaleY", this.at.getScaleY());
        result.put("width", this.rect.width);
        result.put("height", this.rect.height);
        result.put("rect.y", this.rect.y);
        return result;
    }

    @Override
    protected void initFromJSON(JSONObject from) {
        super.initFromJSON(from);
        try {
            this.text = from.getString("text");
            this.font = new ColorFont(from.getJSONObject("font").toString());
            this.alignment = 0;
            this.rect.x = from.getInt("x");
            this.y = from.getInt("y");
            this.at.scale(from.optDouble("scaleX", 1.0), from.optDouble("scaleY", 1.0));
            this.rect.width = from.getInt("width");
            this.rect.height = from.getInt("height");
            this.rect.y = from.getInt("rect.y");
            this.yPosRatio = (double)(this.y - this.rect.y) / (double)this.rect.height;
        }
        catch (JSONException e) {
            this.initFromJSONOld(from);
        }
    }

    @Deprecated
    protected void initFromJSONOld(JSONObject from) {
        try {
            this.text = from.getString("text");
            this.font = new ColorFont(from.getJSONObject("font").toString());
            this.alignment = 0;
            this.rect.x = from.getInt("x");
            this.y = from.getInt("y");
            this.at.scale(from.optDouble("scaleX", 1.0), from.optDouble("scaleY", 1.0));
            Canvas c = new Canvas();
            FontMetrics fm = c.getFontMetrics(this.font.getFont());
            this.initSize(fm);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

