/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import com.developmentontheedge.beans.editors.TextButtonEditor;
import java.awt.BasicStroke;
import java.util.Arrays;
import java.util.HashMap;
import ru.biosoft.graphics.Pen;

public abstract class StrokeTextEditor
extends TextButtonEditor {
    public static final float[] SOLID = Pen.SOLID;
    public static final float[] DASHED = Pen.DASHED;
    public static final float[] DOT = Pen.DOT;
    public static final float[] DASH_DOT = Pen.DASH_DOT;
    private static HashMap<String, float[]> patternToArray = new HashMap<String, float[]>(){
        {
            this.put("-", SOLID);
            this.put("--", DASHED);
            this.put("---", DASHED);
            this.put("..", DOT);
            this.put(".", DOT);
            this.put(":", DOT);
            this.put("-.", DASH_DOT);
            this.put("-.-", DASH_DOT);
        }
    };
    private static HashMap<float[], String> arrayToPattern = new HashMap<float[], String>(){
        {
            this.put(SOLID, "-");
            this.put(DASHED, "--");
            this.put(DOT, ":");
            this.put(DASH_DOT, "-.");
        }
    };

    public static String getUserStrokeString(BasicStroke stroke) {
        return StrokeTextEditor.getPatternByArray(stroke.getDashArray());
    }

    private static String getPatternByArray(float[] array) {
        for (float[] val : arrayToPattern.keySet()) {
            if (!Arrays.equals(val, array)) continue;
            return arrayToPattern.get(val);
        }
        return "~";
    }

    public static float[] getArrayByPattern(String pattern) {
        return patternToArray.getOrDefault(pattern, SOLID);
    }
}

