/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.View;

public abstract class ShapeView
extends View {
    protected Pen pen = null;
    protected Brush brush = null;

    public ShapeView(Shape shape) {
        super(shape);
    }

    public ShapeView(Shape shape, Pen pen, Brush brush) {
        super(shape);
        this.pen = pen;
        this.brush = brush;
    }

    public Pen getPen() {
        return this.pen;
    }

    public Brush getBrush() {
        return this.brush;
    }

    public void setBrush(Brush brush) {
        this.brush = brush;
    }

    public void setPen(Pen pen) {
        this.pen = pen;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ShapeView)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ShapeView v = (ShapeView)obj;
        if (this.pen == null && v.pen != null || this.pen != null && !this.pen.equals(v.pen)) {
            return false;
        }
        return (this.brush != null || v.brush == null) && (this.brush == null || this.brush.equals(v.brush));
    }

    @Override
    public void setToScale(double sx, double sy) {
        super.setToScale(sx, sy);
        if (this.pen != null) {
            float w = (float)(this.pen.getWidth() * sx);
            this.pen.setWidth(w);
        }
    }

    @Override
    public void paint(Graphics2D g2) {
        if (this.isVisible()) {
            if (this.brush != null) {
                Paint paint = this.brush.getPaint(this.shape.getBounds());
                g2.setPaint(paint);
                g2.fill(this.shape);
            }
            if (this.pen != null && this.pen.getWidth() > 0.0) {
                g2.setColor(this.pen.color);
                g2.setStroke(this.pen.getStroke());
                try {
                    g2.draw(this.shape);
                }
                catch (Throwable t) {
                    g2.setColor(Color.RED);
                    g2.setStroke(new BasicStroke(3.0f));
                    g2.draw(this.shape);
                }
            }
        }
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = super.toJSON();
        if (this.pen != null) {
            result.put("pen", (Object)this.pen.toJSON());
        }
        if (this.brush != null) {
            result.put("brush", (Object)this.brush.toJSON());
        }
        return result;
    }

    @Override
    protected void initFromJSON(JSONObject from) {
        super.initFromJSON(from);
        try {
            if (from.has("pen")) {
                this.pen = new Pen(from.getJSONObject("pen"));
            }
            if (from.has("brush")) {
                this.brush = new Brush(from.getJSONObject("brush"));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

