/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.font.ColorFont;

public class RulerOptions {
    protected ColorFont majorFont;
    protected ColorFont minorFont;
    protected Dimension decDig;
    protected Pen axisPen;
    protected Pen ticksPen;
    protected Dimension tickSize;
    protected Dimension textOffset;
    int ticks;
    int step;
    protected PropertyChangeSupport pcSupport = null;

    public RulerOptions(ColorFont font) {
        this(font, font, new Dimension(0, 0), new Pen(1.0f, Color.black), new Pen(1.0f, Color.black), new Dimension(10, 5), new Dimension(5, 5));
    }

    public RulerOptions(ColorFont majorFont, ColorFont minorFont, Dimension decDig, Pen axisPen, Pen ticksPen, Dimension tickSize, Dimension textOffset) {
        this.majorFont = majorFont;
        this.minorFont = minorFont;
        this.decDig = decDig;
        this.axisPen = axisPen;
        this.ticksPen = ticksPen;
        this.tickSize = tickSize;
        this.textOffset = textOffset;
    }

    public ColorFont getMajorFont() {
        return this.majorFont;
    }

    public void setMajorFont(ColorFont majorFont) {
        ColorFont oldValue = this.majorFont;
        this.majorFont = majorFont;
        this.firePropertyChange("majorFont", oldValue, majorFont);
    }

    public ColorFont getMinorFont() {
        return this.minorFont;
    }

    public void setMinorFont(ColorFont minorFont) {
        ColorFont oldValue = this.minorFont;
        this.minorFont = minorFont;
        this.firePropertyChange("minorFont", oldValue, minorFont);
    }

    public Dimension getDecDig() {
        return this.decDig;
    }

    public void setDecDig(Dimension decDig) {
        Dimension oldValue = this.decDig;
        this.decDig = decDig;
        this.firePropertyChange("decDig", oldValue, decDig);
    }

    public Pen getAxisPen() {
        return this.axisPen;
    }

    public void setAxisPen(Pen axisPen) {
        Pen oldValue = this.axisPen;
        this.axisPen = axisPen;
        this.firePropertyChange("axisPen", oldValue, axisPen);
    }

    public Pen getTicksPen() {
        return this.ticksPen;
    }

    public void setTicksPen(Pen ticksPen) {
        Pen oldValue = this.ticksPen;
        this.ticksPen = ticksPen;
        this.firePropertyChange("ticksPen", oldValue, ticksPen);
    }

    public Dimension getTickSize() {
        return this.tickSize;
    }

    public void setTickSize(Dimension tickSize) {
        Dimension oldValue = this.tickSize;
        this.tickSize = tickSize;
        this.firePropertyChange("tickSize", oldValue, tickSize);
    }

    public Dimension getTextOffset() {
        return this.textOffset;
    }

    public void setTextOffset(Dimension textOffset) {
        Dimension oldValue = this.textOffset;
        this.textOffset = textOffset;
        this.firePropertyChange("textOffset", oldValue, textOffset);
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getStep() {
        return this.step;
    }

    public RulerOptions clone() {
        RulerOptions rulerOptions = new RulerOptions(new ColorFont(this.majorFont.getFont(), this.majorFont.getColor()), new ColorFont(this.minorFont.getFont(), this.minorFont.getColor()), new Dimension(this.decDig.width, this.decDig.height), new Pen((float)this.axisPen.width, this.axisPen.color), new Pen((float)this.ticksPen.width, this.ticksPen.color), new Dimension(this.tickSize.width, this.tickSize.height), new Dimension(this.textOffset.width, this.textOffset.height));
        return rulerOptions;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcSupport == null) {
            this.pcSupport = new PropertyChangeSupport(this);
        }
        this.pcSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcSupport == null) {
            this.pcSupport = new PropertyChangeSupport(this);
        }
        this.pcSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcSupport != null) {
            this.pcSupport.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcSupport != null) {
            this.pcSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.pcSupport != null) {
            this.pcSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

