/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.LineView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.RulerOptions;
import ru.biosoft.graphics.TextView;
import ru.biosoft.graphics.font.ColorFont;

public class Ruler
extends CompositeView {
    public static final int HORIZONTAL = 1;
    public static final int GENE = 2;
    public static final int TICKS_MAJOR_UP = 4;
    public static final int TICKS_MAJOR_DOWN = 8;
    public static final int TICKS_MINOR_UP = 16;
    public static final int TICKS_MINOR_DOWN = 32;
    public static final int LABELS_MAJOR_SHOW = 64;
    public static final int LABELS_MAJOR_UP = 128;
    public static final int LABELS_MINOR_SHOW = 256;
    public static final int LABELS_MINOR_UP = 512;
    protected int type;
    protected double min;
    protected double max;
    protected double step;
    protected int tPerT;
    protected double scale;
    protected boolean isReversed;
    protected Point anchor;
    protected RulerOptions options;
    protected double density;

    public Ruler(int type, Point anchor, double scale, int min, int max, RulerOptions rulerOptions, double density, Graphics graphics) {
        if (min > max) {
            this.isReversed = true;
            int temp = min;
            min = max;
            max = temp;
        }
        this.type = type;
        this.anchor = anchor;
        this.scale = scale;
        this.min = min;
        this.max = max;
        this.options = rulerOptions;
        this.density = density;
        this.tPerT = this.options.getTicks();
        FontMetrics fmMajor = graphics.getFontMetrics(this.options.getMajorFont().getFont());
        FontMetrics fmMinor = graphics.getFontMetrics(this.options.getMinorFont().getFont());
        Dimension decDig = this.options.getDecDig();
        String lMin = Ruler.valueOf(min, decDig.width);
        String lMax = Ruler.valueOf(max, decDig.height);
        int labelMaxSize = (type & 1) != 0 ? Math.max(Math.max(fmMajor.stringWidth(lMin), fmMajor.stringWidth(lMax)), Math.max(fmMinor.stringWidth(lMin), fmMinor.stringWidth(lMax))) : Math.max(fmMajor.getHeight(), fmMinor.getHeight());
        double length = max - min;
        int intervalNumber = (int)(length * scale / (double)(labelMaxSize * 2)) + 1;
        double stepApr = length / (double)intervalNumber;
        this.step = 1.0;
        if (stepApr > this.step) {
            while (this.step < stepApr) {
                this.step *= 2.0;
                this.tPerT = 1;
                if (this.step > stepApr) break;
                this.step *= 2.5;
                this.tPerT = 4;
                if (!(this.step > stepApr)) {
                    this.step *= 2.0;
                    this.tPerT = 9;
                    continue;
                }
                break;
            }
        } else {
            while (this.step > stepApr) {
                this.step /= 2.0;
                this.tPerT = 1;
                if (this.step < stepApr) break;
                this.step /= 2.5;
                this.tPerT = 4;
                if (!(this.step < stepApr)) {
                    this.step /= 2.0;
                    this.tPerT = 9;
                    continue;
                }
                break;
            }
        }
        rulerOptions.step = (int)this.step;
        rulerOptions.ticks = this.tPerT;
        this.initSize(graphics);
    }

    protected void initSize(Graphics graphics) {
        int tickUB;
        Dimension d = new Dimension(0, 0);
        if (!this.isVisible()) {
            return;
        }
        Pen pAxis = this.options.getAxisPen();
        Pen pTicks = this.options.getTicksPen();
        Dimension dText = this.options.getTextOffset();
        Dimension dTickSize = this.options.getTickSize();
        Dimension decDig = this.options.getDecDig();
        Point pFrom = new Point(this.anchor.x - d.width, this.anchor.y - d.height);
        Point pTo = new Point(pFrom.x, pFrom.y);
        int axisLen = (int)((this.max - this.min) * this.scale);
        if ((this.type & 2) != 0 && this.min < 0.0 && this.max > 0.0) {
            axisLen = (int)((double)axisLen - this.scale);
        }
        if ((this.type & 1) != 0) {
            pTo.x += axisLen;
        } else {
            pTo.y -= axisLen;
        }
        LineView axis = new LineView(pAxis, pFrom.x, pFrom.y, pTo.x, pTo.y);
        if (this.children.size() == 0) {
            this.rect = (Rectangle)axis.getBounds().clone();
        } else {
            this.rect.add(axis.getBounds());
        }
        int TickUB = (this.type & 1) != 0 ? pFrom.y : pFrom.x;
        int tickDB = tickUB = TickUB;
        int TickDB = tickUB;
        if ((this.type & 4) != 0) {
            TickUB -= dTickSize.width;
            tickUB -= dTickSize.height;
        }
        if ((this.type & 8) != 0) {
            TickDB += dTickSize.width;
            tickDB += dTickSize.height;
        }
        if ((this.type & 0x4C) != 0) {
            this.initSizeUsingTicksAndLabels(this.step, 0.0, pFrom, pTicks, this.options.getMajorFont(), graphics, TickUB, TickDB, decDig.width, dText, (this.type & 0xC) != 0, (this.type & 0x40) != 0, (this.type & 0x80) != 0);
        }
        if ((this.type & 0x130) != 0) {
            this.initSizeUsingTicksAndLabels(this.step / (double)(this.tPerT + 1), this.step, pFrom, pTicks, this.options.getMinorFont(), graphics, tickUB, tickDB, decDig.height, dText, (this.type & 0x30) != 0, (this.type & 0x100) != 0, (this.type & 0x200) != 0);
        }
    }

    protected void initSizeUsingTicksAndLabels(double step, double stepMajor, Point pFrom, Pen pTicks, ColorFont fLabel, Graphics graphics, int tickUB, int tickDB, int decDig, Dimension textOffset, boolean ticksShow, boolean labelsShow, boolean labelsUp) {
        FontMetrics fm = graphics.getFontMetrics(fLabel.getFont());
        double cur = step * (this.min / step);
        Point pCur = new Point(0, 0);
        if ((this.type & 1) != 0) {
            pCur.y = pFrom.y;
        } else {
            pCur.x = pFrom.x;
        }
        Point pText = new Point(pCur.x, pCur.y);
        if ((this.type & 1) != 0) {
            pText.y = labelsUp ? tickUB - fm.getDescent() - textOffset.height : tickDB + fm.getAscent() + textOffset.height;
        } else if (!labelsUp) {
            pText.x = tickDB + textOffset.width;
        }
        double curTick = 0.0;
        curTick = cur <= this.min ? this.min : (cur > this.max ? this.max : cur - 1.0);
        double shift = !this.isReversed ? this.scale * (curTick - this.min) : this.scale * (this.max - curTick);
        if ((this.type & 2) != 0 && curTick > 0.0 && this.min < 0.0) {
            shift -= this.scale;
        }
        if ((this.type & 1) != 0) {
            pCur.x = pFrom.x + (int)shift;
        } else {
            pCur.y = pFrom.y - (int)shift;
        }
        if (ticksShow) {
            LineView axis;
            if ((this.type & 1) != 0) {
                axis = new LineView(pTicks, pCur.x, tickUB, pCur.x, tickDB);
                this.rect.add(axis.getBounds());
            } else {
                axis = new LineView(pTicks, tickUB, pCur.y, tickDB, pCur.y);
                this.rect.add(axis.getBounds());
            }
        }
        if (labelsShow) {
            String label = Ruler.valueOf(curTick, decDig);
            if ((this.type & 1) != 0) {
                pText.x = pCur.x - fm.stringWidth(label) / 2;
            } else {
                pText.y = pCur.y;
                if (labelsUp) {
                    pText.x = tickDB - fm.stringWidth(label) - textOffset.width;
                }
            }
            if (pText.x < 0) {
                pText.x = 0;
            }
            TextView text = new TextView(label, new Point(pText.x, pText.y), 0, fLabel, graphics);
            this.rect.add(text.getBounds());
        }
    }

    @Override
    public void move(Point p) {
        this.rect.setLocation(p.x, p.y);
        this.anchor.move(p.x, p.y);
    }

    public void offset(Dimension d) {
        this.rect.x += d.width;
        this.rect.y += d.height;
        this.anchor.x += d.width;
        this.anchor.y += d.height;
    }

    protected void paintTicksAndLabels(double step, double stepMajor, Point pFrom, Pen pTicks, ColorFont fLabel, Graphics graphics, int tickUB, int tickDB, int decDig, Dimension textOffset, boolean ticksShow, boolean labelsShow, boolean labelsUp, boolean shortLabelFormat) {
        FontMetrics fm = graphics.getFontMetrics(fLabel.getFont());
        double cur = stepMajor * Math.floor(this.min / stepMajor);
        Point pCur = new Point(0, 0);
        if ((this.type & 1) != 0) {
            pCur.y = pFrom.y;
        } else {
            pCur.x = pFrom.x;
        }
        Point pText = new Point(pCur.x, pCur.y);
        if ((this.type & 1) != 0) {
            pText.y = labelsUp ? tickUB - fm.getDescent() - textOffset.height : tickDB + fm.getAscent() + textOffset.height;
        } else if (!labelsUp) {
            pText.x = tickDB + textOffset.width;
        }
        Rectangle labelBounds = null;
        while (cur <= this.max + step + 1.0) {
            block18: {
                block19: {
                    double curTick = 0.0;
                    curTick = cur <= this.min ? this.min : (cur > this.max ? this.max : cur);
                    if ((this.type & 2) != 0 && curTick == 0.0) break block18;
                    double shift = !this.isReversed ? this.scale * (curTick - this.min) : this.scale * (this.max - curTick);
                    if ((this.type & 2) != 0 && curTick > 0.0 && this.min < 0.0) {
                        shift -= this.scale;
                    }
                    if ((this.type & 1) != 0) {
                        pCur.x = pFrom.x + (int)shift;
                    } else {
                        pCur.y = pFrom.y - (int)shift;
                    }
                    if (!labelsShow) break block19;
                    String label = shortLabelFormat ? Ruler.valueOf(curTick / 1000000.0, decDig + 2) + "Mb" : Ruler.valueOf(curTick, decDig);
                    if ((this.type & 1) != 0) {
                        pText.x = pCur.x - fm.stringWidth(label) / 2;
                    } else {
                        pText.y = pCur.y;
                        if (labelsUp) {
                            pText.x = tickDB - fm.stringWidth(label) - textOffset.width;
                        }
                    }
                    Rectangle curLabelBounds = new Rectangle(pText.x, pText.y, fm.stringWidth(label) + fm.stringWidth("0") / 2, fm.getHeight());
                    if (labelBounds != null && labelBounds.intersects(curLabelBounds)) break block18;
                    graphics.setColor(fLabel.getColor());
                    graphics.setFont(fLabel.getFont());
                    graphics.drawString(label, pText.x, pText.y);
                    labelBounds = curLabelBounds;
                }
                if (ticksShow) {
                    ((Graphics2D)graphics).setStroke(pTicks.getStroke());
                    graphics.setColor(pTicks.getColor());
                    if ((this.type & 1) != 0) {
                        graphics.drawLine(pCur.x, tickUB, pCur.x, tickDB);
                    } else {
                        graphics.drawLine(tickUB, pCur.y, tickDB, pCur.y);
                    }
                }
            }
            cur += step;
        }
    }

    @Override
    public void paint(Graphics2D graphics) {
        boolean shortLabelFormat;
        int tickUB;
        super.paint(graphics);
        Point loc = this.getLocation();
        Rectangle clip = graphics.getClipBounds();
        if (clip == null) {
            clip = new Rectangle(0, 0, 0, 0);
        }
        Dimension d = new Dimension(-loc.x, -(loc.y + this.rect.height));
        if (!this.isVisible()) {
            return;
        }
        Pen pAxis = this.options.getAxisPen();
        Pen pTicks = this.options.getTicksPen();
        Dimension dText = this.options.getTextOffset();
        Dimension dTickSize = this.options.getTickSize();
        Dimension decDig = this.options.getDecDig();
        Point pFrom = new Point(this.anchor.x - d.width, this.anchor.y - d.height);
        double _min = this.min;
        double _max = this.max;
        double delta = (double)(clip.x - pFrom.x) / this.scale;
        double num = (float)(Math.ceil(delta / this.step) - 1.0);
        this.min += num * this.step;
        if (this.min < _min) {
            this.min = _min;
        } else {
            int diff = (int)(num * this.step * this.scale);
            pFrom.x += diff;
        }
        delta = (double)clip.width / this.scale + this.step;
        num = (float)Math.ceil(delta / this.step);
        this.max = this.min + (num + 1.0) * this.step;
        if (this.max > _max) {
            this.max = _max;
        }
        Point pTo = new Point(pFrom.x, pFrom.y);
        int axisLen = (int)((this.max - this.min) * this.scale);
        if ((this.type & 2) != 0 && this.min < 0.0 && this.max > 0.0) {
            axisLen = (int)((double)axisLen - this.scale);
        }
        if ((this.type & 1) != 0) {
            pTo.x += axisLen;
        } else {
            pTo.y -= axisLen;
        }
        graphics.setStroke(pAxis.getStroke());
        graphics.setColor(pAxis.getColor());
        graphics.drawLine(pFrom.x, pFrom.y, pTo.x, pTo.y);
        int TickUB = (this.type & 1) != 0 ? pFrom.y : pFrom.x;
        int tickDB = tickUB = TickUB;
        int TickDB = tickUB;
        if ((this.type & 4) != 0) {
            TickUB -= dTickSize.width;
            tickUB -= dTickSize.height;
        }
        if ((this.type & 8) != 0) {
            TickDB += dTickSize.width;
            tickDB += dTickSize.height;
        }
        boolean bl = shortLabelFormat = this.density < 0.01;
        if ((this.type & 0x4C) != 0) {
            this.paintTicksAndLabels(this.step, this.step, pFrom, pTicks, this.options.getMajorFont(), graphics, TickUB, TickDB, decDig.width, dText, (this.type & 0xC) != 0, (this.type & 0x40) != 0, (this.type & 0x80) != 0, shortLabelFormat);
        }
        if ((this.type & 0x130) != 0) {
            this.paintTicksAndLabels(this.step / (double)(this.tPerT + 1), this.step, pFrom, pTicks, this.options.getMinorFont(), graphics, tickUB, tickDB, decDig.height, dText, (this.type & 0x30) != 0, (this.type & 0x100) != 0, (this.type & 0x200) != 0, shortLabelFormat);
            this.min = _min;
            this.max = _max;
        }
    }

    public static String valueOf(double value, int decDig) {
        StringBuilder decs = new StringBuilder("");
        if (decDig > 0) {
            decs.append('.');
            for (int i = 0; i < decDig; ++i) {
                decs.append('#');
            }
        }
        return new DecimalFormat("##,###,###,###,###,###,###,###,###,###,###" + decs).format(value);
    }
}

