/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Graphics2D;
import java.awt.Polygon;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.PolygonView;

public class PolylineView
extends PolygonView {
    public PolylineView(Pen pen) {
        this(pen, new Polygon());
    }

    public PolylineView(Pen pen, int[] xpoints, int[] ypoints) {
        this(pen, new Polygon(xpoints, ypoints, xpoints.length));
    }

    public PolylineView(Pen pen, Polygon polygon) {
        super(pen, null, polygon);
    }

    @Override
    public void paint(Graphics2D g) {
        g.setColor(this.pen.color);
        g.setStroke(this.pen.getStroke());
        double sx = this.at.getScaleX();
        double sy = this.at.getScaleY();
        for (int i = 0; i < ((Polygon)this.shape).npoints - 1; ++i) {
            g.drawLine((int)Math.round((double)((Polygon)this.shape).xpoints[i] * sx), (int)Math.round((double)((Polygon)this.shape).ypoints[i] * sy), (int)Math.round((double)((Polygon)this.shape).xpoints[i + 1] * sx), (int)Math.round((double)((Polygon)this.shape).ypoints[i + 1] * sy));
        }
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = super.toJSON();
        return result;
    }
}

