/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import com.developmentontheedge.beans.swing.PropertyInspector;
import java.awt.Color;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import ru.biosoft.graphics.ComplexTextView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.StrokeTextEditor;

public class PenEditor
extends StrokeTextEditor {
    public PenEditor() {
        this.textField.setEditable(true);
        this.getButton().setText("");
        URL url = PenEditor.class.getResource("resources/edit.gif");
        this.getButton().setIcon(new ImageIcon(url));
    }

    public void setValue(Object value) {
        Pen pen = (Pen)value;
        this.textField.setText(this.getUserPenString(pen));
        this.firePropertyChange();
    }

    public Object getValue() {
        try {
            return this.getPenByUserString(this.textField.getText());
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String getUserPenString(Pen pen) {
        if (pen == null) {
            return "Auto";
        }
        if (pen.getColor() == null) {
            return pen.getWidth() + ";" + PenEditor.getUserStrokeString(pen.getStroke());
        }
        Color color = pen.getColor();
        return pen.getWidth() + ";" + color.getRed() + ";" + color.getGreen() + ";" + color.getBlue() + ";" + PenEditor.getUserStrokeString(pen.getStroke());
    }

    private Pen getPenByUserString(String str) {
        if ("Auto".equals(str)) {
            return null;
        }
        try {
            String[] arr = ComplexTextView.split(str, ';');
            float width = Float.parseFloat(arr[0]);
            int red = Integer.parseInt(arr[1]);
            int green = Integer.parseInt(arr[2]);
            int blue = Integer.parseInt(arr[3]);
            Color color = new Color(red, green, blue);
            Pen pen = new Pen(width, color);
            if (arr.length == 5 && !arr[4].isEmpty()) {
                pen.setStroke(Pen.createBasicStroke(PenEditor.getArrayByPattern(arr[4])));
            }
            pen.setWidth(width);
            return pen;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected void buttonPressed() {
        Pen pen = (Pen)this.getValue();
        PropertyInspector inspector = new PropertyInspector();
        inspector.explore((Object)pen);
        inspector.setPreferredSize(new Dimension(480, 200));
        int result = JOptionPane.showOptionDialog(JOptionPane.getRootFrame(), inspector, "Line spec settings:", 2, -1, null, null, null);
        if (result == 0) {
            this.setValue(pen);
        }
    }
}

