/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import com.developmentontheedge.beans.BeanInfoEx;
import com.developmentontheedge.beans.editors.StringTagEditor;
import ru.biosoft.graphics.Pen;

public class PenBeanInfo
extends BeanInfoEx {
    public PenBeanInfo() {
        super(Pen.class, "ru.biosoft.graphics.PenMessageBundle");
        this.beanDescriptor.setDisplayName(this.getResourceString("DISPLAY_NAME"));
        this.beanDescriptor.setShortDescription(this.getResourceString("SHORT_DESCRIPTION"));
    }

    protected void initProperties() throws Exception {
        this.property("color").title("COLOR_NAME").description("COLOR_DESCRIPTION").add();
        this.property("width").editor(PenWidthSelector.class).title("WIDTH_NAME").description("WIDTH_DESCRIPTION").add();
        this.property("stroke").hidden().title("STROKE_NAME").description("STROKE_DESCRIPTION").add();
        this.property("strokeAsString").tags(Pen.getAvailableStrokes()).title("STROKE_NAME").description("STROKE_DESCRIPTION").add();
    }

    public static class PenWidthSelector
    extends StringTagEditor {
        public String getAsText() {
            return String.valueOf(this.getValue());
        }

        public void setAsText(String text) {
            try {
                this.setValue(Double.parseDouble(text));
            }
            catch (NumberFormatException e) {
                this.setValue(1.0);
            }
        }

        public String[] getTags() {
            return new String[]{"0.0", "0.5", "1.0", "1.5", "2.0", "2.5", "3.0", "4.0", "5.0"};
        }
    }
}

