/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.ComplexTextView;

public class Pen {
    protected double width;
    protected Color color;
    protected BasicStroke stroke;
    JSONObject json = null;
    static final float[] SOLID = null;
    static final float[] DASHED = new float[]{9.0f, 6.0f};
    static final float[] DOT = new float[]{2.0f, 9.0f};
    static final float[] DASH_DOT = new float[]{9.0f, 3.0f, 2.0f, 3.0f};
    private static HashMap<String, float[]> nameToArray = new LinkedHashMap<String, float[]>(){
        {
            this.put("Solid", SOLID);
            this.put("Dashed", DASHED);
            this.put("Dot", DOT);
            this.put("Dash-dot", DASH_DOT);
        }
    };
    protected PropertyChangeSupport pcSupport = null;

    public Pen() {
        this(1.0f);
    }

    public Pen(float width) {
        this(width, Color.BLACK);
    }

    public Pen(BasicStroke stroke, Color col) {
        this.color = col;
        this.setStroke(stroke);
    }

    public Pen(float width, Color col) {
        this.color = col;
        this.setWidth(width);
    }

    public Pen(JSONObject jsonObj) {
        this.initFromJSON(jsonObj);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Pen)) {
            return false;
        }
        Pen p = (Pen)obj;
        return p.width == this.width && Objects.equals(p.stroke, this.stroke) && Objects.equals(p.color, this.color);
    }

    public Pen clone() {
        Color newColor = this.color != null ? new Color(this.color.getRGB()) : null;
        return new Pen(Pen.cloneStroke(this.stroke), newColor);
    }

    public static BasicStroke cloneStroke(BasicStroke stroke) {
        return new BasicStroke(stroke.getLineWidth(), stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), stroke.getDashPhase());
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        double oldValue = this.width;
        this.width = width;
        this.stroke = this.stroke == null ? new BasicStroke((float)width) : new BasicStroke((float)width, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        this.json = null;
        this.firePropertyChange("width", oldValue, width);
    }

    public Pen withWidth(float thickness) {
        Pen pen = new Pen(this.stroke, this.color);
        pen.setWidth(thickness);
        return pen;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color oldValue = this.color;
        this.color = color;
        this.json = null;
        this.firePropertyChange("color", oldValue, color);
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(BasicStroke stroke) {
        BasicStroke oldValue = this.stroke;
        this.stroke = stroke;
        this.width = stroke.getLineWidth();
        this.json = null;
        this.firePropertyChange("stroke", oldValue, stroke);
    }

    public String getStrokeAsString() {
        return Pen.getNameByStroke(this.stroke);
    }

    public void setStrokeAsString(String stroke) {
        this.setStroke(Pen.getStrokeByName(this.stroke, stroke));
    }

    public static Pen createInstance(String str) {
        Pen pen = new Pen();
        try {
            pen.initFromJSON(new JSONObject(str));
            return pen;
        }
        catch (Exception e) {
            return pen;
        }
    }

    public String toString() {
        try {
            return this.toJSON().toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public JSONObject toJSON() throws JSONException {
        if (this.json == null) {
            this.json = new JSONObject();
            JSONArray color = new JSONArray();
            Color clr = this.color;
            if (clr == null) {
                clr = Color.BLACK;
            }
            color.put(clr.getRed());
            color.put(clr.getGreen());
            color.put(clr.getBlue());
            color.put(clr.getAlpha());
            this.json.put("color", (Object)color);
            this.json.put("width", this.getWidth());
            if (this.stroke != null && this.stroke.getDashArray() != null) {
                this.json.put("dash", (Object)this.stroke.getDashArray());
            }
            if (this.stroke != null && this.stroke.getDashPhase() != 0.0f) {
                this.json.put("dashOffset", (double)this.stroke.getDashPhase());
            }
        }
        return this.json;
    }

    private void initFromJSON(JSONObject from) {
        try {
            JSONArray color = (JSONArray)from.get("color");
            int red = color.getInt(0);
            int green = color.getInt(1);
            int blue = color.getInt(2);
            int alpha = color.getInt(3);
            this.color = new Color(red, green, blue, alpha);
            float dashPhase = (float)from.optDouble("dashOffset", 0.0);
            float[] dashArray = null;
            JSONArray dashJson = from.optJSONArray("dash");
            if (dashJson != null) {
                dashArray = new float[dashJson.length()];
                for (int i = 0; i < dashJson.length(); ++i) {
                    dashArray[i] = (float)dashJson.optDouble(i, 0.0);
                }
            }
            this.setStroke(new BasicStroke((float)from.getDouble("width"), 2, 0, 10.0f, dashArray, dashPhase));
            this.setWidth((float)from.getDouble("width"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static BasicStroke fromString(String str) {
        try {
            if (str.equals("")) {
                return new BasicStroke();
            }
            String[] arr = ComplexTextView.split(str, ',');
            String[] dashStringArr = arr[0].replace("[", "").split(",");
            float[] dashArray = new float[dashStringArr.length];
            for (int i = 0; i < dashArray.length; ++i) {
                dashArray[i] = Float.parseFloat(dashStringArr[i]);
            }
            float dashOffset = arr.length > 1 ? Float.parseFloat(arr[1]) : 0.0f;
            return new BasicStroke(1.0f, 0, 2, 10.0f, dashArray, dashOffset);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String[] getAvailableStrokes() {
        return nameToArray.keySet().toArray(new String[nameToArray.size()]);
    }

    public static String getNameByStroke(BasicStroke basicStroke) {
        float[] array = basicStroke.getDashArray();
        for (String name : nameToArray.keySet()) {
            if (!Arrays.equals(array, nameToArray.get(name))) continue;
            return name;
        }
        return "Custom";
    }

    public static BasicStroke getStrokeByName(BasicStroke oldStroke, String name) {
        if (oldStroke == null) {
            return Pen.createBasicStroke(nameToArray.get(name));
        }
        return new BasicStroke(oldStroke.getLineWidth(), oldStroke.getEndCap(), oldStroke.getLineJoin(), oldStroke.getMiterLimit(), nameToArray.get(name), 0.0f);
    }

    public static BasicStroke createBasicStroke(float[] array) {
        return new BasicStroke(1.0f, 0, 2, 10.0f, array, 0.0f);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcSupport == null) {
            this.pcSupport = new PropertyChangeSupport(this);
        }
        this.pcSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcSupport == null) {
            this.pcSupport = new PropertyChangeSupport(this);
        }
        this.pcSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcSupport != null) {
            this.pcSupport.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcSupport != null) {
            this.pcSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.pcSupport != null) {
            this.pcSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

