/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.PathUtils;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.ShapeView;

public class PathView
extends ShapeView {
    public PathView(Pen pen, GeneralPath path) {
        super(path, pen, null);
    }

    @Override
    public void move(int sx, int sy) {
        AffineTransform at = new AffineTransform();
        at.translate(sx, sy);
        ((GeneralPath)this.shape).transform(at);
    }

    @Override
    public boolean equals(Object obj) {
        boolean done;
        if (obj == null || !(obj instanceof PathView)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PathView v = (PathView)obj;
        GeneralPath p1 = (GeneralPath)this.shape;
        GeneralPath p2 = (GeneralPath)v.shape;
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        if (p1.getWindingRule() != p2.getWindingRule()) {
            return false;
        }
        PathIterator iterator1 = p1.getPathIterator(null);
        PathIterator iterator2 = p1.getPathIterator(null);
        double[] d1 = new double[6];
        double[] d2 = new double[6];
        boolean bl = done = iterator1.isDone() && iterator2.isDone();
        while (!done) {
            int seg2;
            if (iterator1.isDone() != iterator2.isDone()) {
                return false;
            }
            int seg1 = iterator1.currentSegment(d1);
            if (seg1 != (seg2 = iterator2.currentSegment(d2))) {
                return false;
            }
            if (!Arrays.equals(d1, d2)) {
                return false;
            }
            iterator1.next();
            iterator2.next();
            done = iterator1.isDone() && iterator2.isDone();
        }
        return true;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = this.shape.getBounds();
        if (bounds.width == 0 || bounds.height == 0) {
            Rectangle correctedBounds = new Rectangle(bounds);
            if (bounds.width == 0) {
                correctedBounds.width = 1;
            }
            if (bounds.height == 0) {
                correctedBounds.height = 1;
            }
            return correctedBounds;
        }
        return bounds;
    }

    @Override
    public boolean intersects(Rectangle rect) {
        GeneralPath path = (GeneralPath)this.shape;
        FlatteningPathIterator iter = new FlatteningPathIterator(path.getPathIterator(new AffineTransform()), 5.0);
        double[] coords = new double[6];
        Point prev = new Point();
        while (!iter.isDone()) {
            int type = iter.currentSegment(coords);
            if (type == 1 && PathUtils.lineIntersects(prev.x, prev.y, (int)coords[0], (int)coords[1], rect)) {
                return true;
            }
            prev.x = (int)coords[0];
            prev.y = (int)coords[1];
            iter.next();
        }
        return false;
    }

    public Point getMiddlePoint() {
        GeneralPath path = (GeneralPath)this.shape;
        FlatteningPathIterator iter = new FlatteningPathIterator(path.getPathIterator(new AffineTransform()), 5.0);
        double[] coords = new double[6];
        ArrayList<Point> points = new ArrayList<Point>();
        while (!iter.isDone()) {
            iter.currentSegment(coords);
            points.add(new Point((int)coords[0], (int)coords[1]));
            iter.next();
        }
        int npoints = points.size();
        if (npoints % 2 == 0) {
            return new Point((((Point)points.get((int)(npoints / 2 - 1))).x + ((Point)points.get((int)(npoints / 2))).x) / 2, (((Point)points.get((int)(npoints / 2 - 1))).y + ((Point)points.get((int)(npoints / 2))).y) / 2);
        }
        return new Point((Point)points.get(npoints / 2));
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = super.toJSON();
        result.put("pen", (Object)this.pen.toJSON());
        GeneralPath path = (GeneralPath)this.shape;
        PathIterator iter = path.getPathIterator(new AffineTransform());
        JSONArray xpoints = new JSONArray();
        JSONArray ypoints = new JSONArray();
        JSONArray pointtypes = new JSONArray();
        double[] coords = new double[6];
        while (!iter.isDone()) {
            int segmentType = iter.currentSegment(coords);
            int n = 0;
            switch (segmentType) {
                case 0: 
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                case 4: {
                    xpoints.put(xpoints.get(0));
                    ypoints.put(ypoints.get(0));
                    pointtypes.put(0);
                }
            }
            for (int i = 0; i < n; ++i) {
                xpoints.put((int)coords[i * 2]);
                ypoints.put((int)coords[i * 2 + 1]);
                pointtypes.put(n - 1);
            }
            result.put("xpoints", (Object)xpoints);
            result.put("ypoints", (Object)ypoints);
            result.put("pointtypes", (Object)pointtypes);
            iter.next();
        }
        return result;
    }
}

